/*
  $Id: daemon.c,v 1.5 1996/08/11 18:51:23 luik Exp $

  daemon.c - daemon() library function to move process into background.
  Based on the BSD4.4 version. UCB copyrights: see below.
  Modified by Andreas Luik, <luik@pharao.s.bawue.de>.

*/

/*-
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#if defined(RCSID) && !defined(lint)
static char rcsid[] = "$Id: daemon.c,v 1.5 1996/08/11 18:51:23 luik Exp $";
#endif /* defined(RCSID) && !defined(lint) */

#if defined(LIBC_SCCS) && !defined(lint)
static char sccsid[] = "@(#)daemon.c	8.1 (Berkeley) 6/4/93";
#endif /* LIBC_SCCS and not lint */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <fcntl.h>
#if HAVE_PATHS_H
#include <paths.h>
#endif
#if HAVE_UNISTD_H
#include <unistd.h>
#endif /* HAVE_UNISTD_H */
#ifndef HAVE_SETSID
#if HAVE_TERMIOS_H
#include <termios.h>
#else /* !HAVE_TERMIOS_H */
#if HAVE_SYS_IOCTL_H
#include <sys/ioctl.h>
#endif /* HAVE_SYS_IOCTL_H */
#endif /* !HAVE_TERMIOS_H */
#endif /* !defined(HAVE_SETSID) */

/* Macro default values.  */
#ifndef _PATH_DEVNULL		/* should be in <paths.h> */
#define _PATH_DEVNULL	"/dev/null"
#endif

#ifndef STDIN_FILENO		/* should be in <unistd.h> */
#define STDIN_FILENO	0
#endif

#ifndef STDOUT_FILENO
#define STDOUT_FILENO	1
#endif

#ifndef STDERR_FILENO
#define STDERR_FILENO	2
#endif


#ifndef HAVE_SETSID
static int setsid()
{
    int fd;

#if defined(TIOCNOTTY) || defined(TIOCTTY)
    if ((fd = open("/dev/tty", O_RDWR)) == -1)
	return (-1);
#if defined(TIOCNOTTY)
    if (ioctl(fd, TIOCNOTTY, (char *) 0) == -1) {
	(void) close(fd);
	return (-1);
    }
#else /* !defined(TIOCNOTTY), therefore defined(TIOCTTY) */
    int zero = 0;
    if (ioctl(fd, TIOCTTY, &zero) == -1) {
	(void) close(fd);
	return (-1);
    }
#endif /* !defined(TIOCNOTTY), therefore defined(TIOCTTY) */
    (void) close(fd);
#endif /* defined(TIOCNOTTY) || defined(TIOCTTY) */
#ifdef HAVE_SETPGID
    return setpgid(0, getpid());
#else /* !defined(HAVE_SETPGID) */
#ifdef HAVE_SETPGRP
    return setpgrp();
#endif /* defined(HAVE_SETPGRP) */
#endif /* !defined(HAVE_SETPGID) */
    return (-1);
}
#endif /* !defined(HAVE_SETSID) */


int daemon(int nochdir, int noclose)
{
    int fd;

    switch (fork()) {
      case -1:
	return (-1);
      case 0:
	break;
      default:
	_exit(0);
    }

    if (setsid() == -1)
	return (-1);

    if (!nochdir)
	(void) chdir("/");

    if (!noclose && (fd = open(_PATH_DEVNULL, O_RDWR, 0)) != -1) {
	(void) dup2(fd, STDIN_FILENO);
	(void) dup2(fd, STDOUT_FILENO);
	(void) dup2(fd, STDERR_FILENO);
	if (fd > 2)
	    (void) close(fd);
    }
    return (0);
}

