/*
 *  nwfsctrl.c
 *
 *  Down file server, open bindery, close bindery
 *
 *  Copyright (C) 1998 by Petr Vandrovec <vandrove@vc.cvut.cz>
 *
 */

#include <stdio.h>
#include <unistd.h>
#include <ctype.h>
#include <stdlib.h>
#include "nwcalls.h"

static char *progname;

static void
usage(void)
{
	fprintf(stderr, "usage: %s [options]\n", progname);
	return;
}

static void
help(void)
{
	printf("\n");
	printf("usage: %s [options] -d|-c|-o\n", progname);
	printf("\n"
	       "-h             Print this help text\n"
	       "-S server      Server name to be used\n"
	       "-U username    Username sent to server\n"
	       "-P password    Use this password\n"
	       "-n             Do not use any password\n"
	       "-C             Don't convert password to uppercase\n"
	       "\n"
	       "-d             Down file server\n"
	       "-f             Force down even if there are open files\n"
	       "-o             Open bindery\n"
	       "-c             Close bindery\n"
	       "\n");
}

int
main(int argc, char **argv)
{
	struct ncp_conn *conn;

	long err;
	NWCCODE nwerr;
	int opt;
	int forceDown = 1;
	int binderyOpen = 1;
	int useConn = 0;
	enum {ACT_UNKNOWN, ACT_FSDOWN, ACT_BINDERY} action = ACT_UNKNOWN;

	progname = argv[0];

	if ((conn = ncp_initialize_2(&argc, argv, 1, NCP_BINDERY_USER, &err, 0)) == NULL)
	{
		useConn = 1;
	}
	while ((opt = getopt(argc, argv, "h?ocdf")) != EOF)
	{
		switch (opt)
		{
		case 'h':
		case '?':
			help();
			exit(1);
		case 'd':
			action = ACT_FSDOWN;
			break;
		case 'o':
			action = ACT_BINDERY;
			binderyOpen = 1;
			break;
		case 'c':
			action = ACT_BINDERY;
			binderyOpen = 0;
			break;
		case 'f':
			forceDown = 0;
			break;
		default:
			usage();
			exit(1);
		}
	}

	if (!useConn) {
		if (optind < argc)
		{
			usage();
			exit(1);
		}
	} else {
		char* path;

		if (optind < argc)
			path = argv[optind];
		else
			path = ".";
		if (NWParsePath(path, NULL, &conn, NULL, NULL) || !conn) {
			fprintf(stderr, "%s: %s is not Netware directory/file\n",
				progname, path);
			return 1;
		}
	}

	switch (action) {
		case ACT_FSDOWN:	nwerr = NWDownFileServer(conn, forceDown);
					if (nwerr) {
						fprintf(stderr, "%s: Error 0x%04X (%u) downing file server\n", progname, nwerr, nwerr);
					}
					break;
		case ACT_BINDERY:	if ((!binderyOpen) && (ncp_get_conn_type(conn) == NCP_CONN_TEMPORARY)) {
						fprintf(stderr, "%s: Warning: Bindery cannot be closed by temporary connection\n", progname);
					}
					nwerr = binderyOpen?NWOpenBindery(conn)
							   :NWCloseBindery(conn);
					if (nwerr) {
						fprintf(stderr, 
"%s: Error 0x%04X (%u) %sing bindery\n", progname, nwerr, nwerr, binderyOpen?"open":"clos");
					}
					break;
		default:		fprintf(stderr, "%s: One of -d,-o,-c must be specified\n", progname);
					break;
	}
	ncp_close(conn);
	return 0;
}
