/* 
 *  gstalker stock charter
 * 
 *  Copyright (c) 1998 Stefan S. Stratigakos
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 */

#include "myheader.h"
#include "myerrors.h"
#include <string.h>
#include <ctype.h>
#include <unistd.h>

/***************************************************************************************/
void get_import_filename()
{
	char *tstringpointer, tstring[250];
	int tint;
	extern GtkWidget *openfile, *import_options_entry;
	extern char *error_message;
	
	
	
	tstringpointer = gtk_file_selection_get_filename(GTK_FILE_SELECTION(openfile));
	sscanf(tstringpointer, "%s", tstring);
   	if (strlen(tstring) == 0)
	  RETURN_ERR(gs_nothing_entered);

	tint = strlen(tstring);
	if ((tstring[tint - 1] == '/') || (tstring[tint - 1] == '.'))
	  RETURN_ERR(gs_invalid_entry);

	strcpy(tstring, tstringpointer);
	gtk_entry_set_text(GTK_ENTRY(import_options_entry), tstring);
	if (openfile)
		gtk_widget_destroy(openfile);
}
/******************************************************************************************/
void ok_import()
{
	int tint, tint2, error_flag = 0, format = 0, reload_flag = 0, dateformat = 0, tint3;
	int skip_flag = 0, found = 0;
   	FILE *infile, *infile2, *errorlog_file;
   	char tstring[250], tstring2[250], error_msg[50], *tstringpointer, tstring3[25];
   	unsigned long importline = 0, linecount = 0, date = 0, volume = 0, openint = 0;
   	float tfloat=0.0, open=0.0, high=0.0, low=0.0, close=0.0;
   	extern char *errorlog, *lastdir, *datapath, *error_message;
	extern int chartflag, header_size;
	extern GtkWidget *import_options_radio, *import_options_radio2, *progwindow;
	extern GtkWidget *import_options_radio3, *import_options_radio4, *import_options_radio5;
	extern GtkWidget *import_options_radio6, *import_options_radio7, *import_options_radio11;
	extern GtkWidget *import_options_entry, *progress_bar;
	extern GtkWidget *import_options_radio8, *import_options_radio9, *import_options_radio10;
	extern struct record2 header;
	extern struct record3 config;
	struct record2 header2;
	
	
	
	
	if (GTK_TOGGLE_BUTTON (import_options_radio)->active)
	{
		format = 1;
		config.import_field = 0;
	}
	if (GTK_TOGGLE_BUTTON (import_options_radio2)->active)
	{
		format = 2;
		config.import_field = 1;
	}
	if (GTK_TOGGLE_BUTTON (import_options_radio3)->active)
	{
		format = 3;
		config.import_field = 2;
	}
	if (GTK_TOGGLE_BUTTON (import_options_radio4)->active)
	{
		format = 4;
		config.import_field = 3;
	}
	if (GTK_TOGGLE_BUTTON (import_options_radio5)->active)
	{
		format = 5;
		config.import_field = 4;
	}
	if (GTK_TOGGLE_BUTTON (import_options_radio6)->active)
	{
		dateformat = 1;
		config.import_date = 0;
	}
	if (GTK_TOGGLE_BUTTON (import_options_radio7)->active)
	{
		dateformat = 2;
		config.import_date = 1;
	}
	if (GTK_TOGGLE_BUTTON (import_options_radio8)->active)
	{
		dateformat = 3;
		config.import_date = 2;
	}
	if (GTK_TOGGLE_BUTTON (import_options_radio9)->active)
	{
		dateformat = 4;
		config.import_date = 3;
	}
	if (GTK_TOGGLE_BUTTON (import_options_radio10)->active)
	{
		dateformat = 5;
		config.import_date = 4;
	}
	if (GTK_TOGGLE_BUTTON (import_options_radio11)->active)
	{
		dateformat = 6;
		config.import_date = 5;
	}
	tstringpointer = gtk_entry_get_text(GTK_ENTRY(import_options_entry));
	sscanf(tstringpointer, "%s", tstring);
   	if (strlen(tstring) == 0)
	  RETURN_ERR(gs_nothing_entered);

	tint = strlen(tstring);
	if ((tstring[tint - 1] == '/') || (tstring[tint - 1] == '.'))
	  RETURN_ERR(gs_invalid_entry);

	strcpy(tstring, tstringpointer);
      	infile = fopen(tstring, "r");
      	if (! infile)
	  RETURN_ERR(gs_cant_open_importfile);

     	if (lastdir != 0)
     		free(lastdir);
     	tstringpointer = strrchr(tstring, '/');
     	*(tstringpointer + 1) = '*';
     	*(tstringpointer + 2) = 0;
     	lastdir = (char *) malloc(strlen(tstring) + 1);
     	strcpy(lastdir, tstring);
     	
     	linecount = 0;
	while (fgets(tstring, 250, infile) != NULL)
		linecount++;
	rewind(infile);
	importline = 1;
	errorlog_file = fopen(errorlog, "w");
	if (! errorlog_file)
	  RETURN_ERR(gs_cant_open_errorlog);

	show_progress_window("Importing...");	
	
	while (fgets(tstring, 250, infile) != NULL)
	{
		error_msg[0] = 0;
		error_flag = 0;
		skip_flag = 1;
		tstring2[0] = 0;
		tstring3[0] = 0;
		open = 0.0;
		date = 0;
		high = 0.0;
		low = 0.0;
		close = 0.0;
		volume = 0;
		openint = 0;
		tint = strlen(tstring);
		for (tint2 = 0; tint2 < tint; tint2++)
		{
			if (isalnum(tstring[tint2]))
			{
				skip_flag = 0;
				break;
			}
		}
		if (! skip_flag)
		{
			for (tint2 = 0; tint2 < tint; tint2++)
			{
				if (tstring[tint2] == ',')
					tstring[tint2] = ' ';
			}
			switch(format)
			{
				case 1 : sscanf(tstring,"%s %s %g %g %g %g %ld %ld", tstring3, tstring2, &open, &high, &low, &close, &volume, &openint);
				 	break;
				case 2 : sscanf(tstring,"%s %s %g %g %g %ld", tstring3, tstring2, &high, &low, &close, &volume);
				 	break;
				case 3 : sscanf(tstring,"%s %s %g", tstring3, tstring2, &close);
				 	break;
				case 4 : sscanf(tstring,"%s %s %g %g %g %g", tstring3, tstring2, &open, &high, &low, &close);
				 	break;
				case 5 : sscanf(tstring,"%s %s %g %g %g %g %ld", tstring3, tstring2, &open, &high, &low, &close, &volume);
				 	break;
				default : break;
			}
			tstringpointer = strchr(tstring2, '/');
			if (tstringpointer != NULL)
			{
				tint3 = 0;
				tstring[0] = 0;
				tint = strlen(tstring2);
				for (tint2 = 0; tint2 < tint; tint2++)
				{
					if (tstring2[tint2] != '/')
					{
						tstring[tint3] = tstring2[tint2];
						tint3++;
					}
				}
				tstring[tint3] = 0;
				strcpy(tstring2, tstring);
			}
			tint = strlen(tstring2);
			for (tint2 = 0; tint2 < tint; tint2++)
			{
				if (! isdigit(tstring2[tint2]))
				{
					error_flag++;
					strcpy(error_msg,"Invalid date character, must be all digits.");
					break;
				}
			}
			switch(dateformat)
			{
				case 1 : if (tint != 8)
				 	{
				 		strcpy(error_msg,"Invalid date format, must be 8 numbers.");
				 		error_flag++;
				 	}
				 	else
				 		date = atol(tstring2);
				 	break;
				case 2 : if (tint != 6)
				 	{
				 		strcpy(error_msg, "Invalid date format, must be 6 numbers.");
				 		error_flag++;
				 	}
				 	else
				 	{
				 		strcpy(tstring, "19");
				 		strcat(tstring, tstring2);
				 		date = atol(tstring);
				 	}
				 	break;
				case 3 : if (tint != 8)
				 	{
				 		strcpy(error_msg, "Invalid date format, must be 8 numbers.");
				 		error_flag++;
				 	}
				 	else
				 	{
				 		tstring[0] = tstring2[4];
				 		tstring[1] = tstring2[5];
				 		tstring[2] = tstring2[6];
				 		tstring[3] = tstring2[7];
				 		tstring[4] = tstring2[0];
				 		tstring[5] = tstring2[1];
				 		tstring[6] = tstring2[2];
				 		tstring[7] = tstring2[3];
				 		tstring[8] = 0;
				 		date = atol(tstring);
				 	}
				 	break;
				case 4 : if (tint != 6)
				 	{
				 		strcpy(error_msg, "Invalid date format, must be 6 numbers.");
				 		error_flag++;
				 	}
				 	else
				 	{
				 		tstring[0] = '1';
				 		tstring[1] = '9';
				 		tstring[2] = tstring2[4];
				 		tstring[3] = tstring2[5];
				 		tstring[4] = tstring2[0];
				 		tstring[5] = tstring2[1];
				 		tstring[6] = tstring2[2];
				 		tstring[7] = tstring2[3];
				 		tstring[8] = 0;
				 		date = atol(tstring);
				 	}
				 	break;
				case 5 : if (tint != 8)
				 	{
				 		strcpy(error_msg, "Invalid date format, must be 8 numbers.");
				 		error_flag++;
				 	}
				 	else
				 	{
				 		tstring[0] = tstring2[4];
				 		tstring[1] = tstring2[5];
				 		tstring[2] = tstring2[6];
				 		tstring[3] = tstring2[7];
				 		tstring[4] = tstring2[2];
				 		tstring[5] = tstring2[3];
				 		tstring[6] = tstring2[0];
				 		tstring[7] = tstring2[1];
				 		tstring[8] = 0;
				 		date = atol(tstring);
				 	}
				 	break;
				case 6 : if (tint != 6)
				 	{
				 		strcpy(error_msg, "Invalid date format, must be 6 numbers.");
				 		error_flag++;
				 	}
				 	else
				 	{
				 		tstring[0] = '1';
				 		tstring[1] = '9';
				 		tstring[2] = tstring2[4];
				 		tstring[3] = tstring2[5];
				 		tstring[4] = tstring2[2];
				 		tstring[5] = tstring2[3];
				 		tstring[6] = tstring2[0];
				 		tstring[7] = tstring2[1];
				 		tstring[8] = 0;
				 		date = atol(tstring);
					}
					break;
				default : break;
			}
			if (strlen(tstring3) == 0)
			{
				strcpy(error_msg, "Invalid symbol.");
				error_flag++;
			}
			if (chartflag)
			{
				if (! strcmp(tstring3, header.symbol))
					reload_flag++;
			}
			if (error_flag != 1)
			{
      				strcpy(tstring, datapath);
				strcat(tstring, tstring3);
				infile2 = fopen(tstring, "rb");
				if (infile2)
				{
					fread(&header2, header_size, 1, infile2);
					fclose(infile2);
					if (date > header2.last_date)
						append_chart_record(tstring, date, open, high, low, close, volume, openint);
					else
					{
						found = find_chart_record(tstring, date);
						if (found > -1)
							overwrite_chart_record (tstring, found, date, open, high, low, close, volume, openint);
						else
							insert_chart_record (tstring, date, open, high, low, close, volume, openint);
					}
				}
				else
				{
					tint = create_new_chart(tstring3);
					if (tint) 
					{
				  		RETURN_ERR(gs_cant_create_chart);
				  	}
					else
						append_chart_record(tstring, date, open, high, low, close, volume, openint);
				}
			}
			else
			{
				strcpy(tstring, "Bad data, line# ");
				sprintf(tstring2, "%ld", importline);
				strcat(tstring, tstring2);
				strcat(tstring, " ");
				strcat(tstring, error_msg);
				strcat(tstring, ", data not imported");
				strcat(tstring, "\n");
				fputs(tstring, errorlog_file);
			}
		}
		importline++;
		tfloat = ((float)importline / linecount);
		if (tfloat > 1.0)
			tfloat = 1.0;
		if (tfloat < 0.0)
			tfloat = 0.0;
		gtk_progress_bar_update (GTK_PROGRESS_BAR (progress_bar), tfloat);
		while (gtk_events_pending())
			gtk_main_iteration();
	}
	fclose(infile);
	fclose(errorlog_file);
	if (progwindow)
		gtk_widget_destroy(progwindow);
	if(error_msg[0] != 0)
	  RETURN_ERR(gs_error_notify);
	if (reload_flag)
		load_file(header.symbol);
}
/*****************************************************************************/
void open_import()
{
	gchar tstring[250];
	extern GtkWidget *openfile;
	extern char *lastdir;
   	
	
	if (openfile)
		gtk_widget_destroy(openfile);
		
	openfile = gtk_file_selection_new("Select File To Import");
	gtk_signal_connect (GTK_OBJECT (openfile), "destroy",
			    GTK_SIGNAL_FUNC (gtk_widget_destroyed), &openfile);
	gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION(openfile)->ok_button), "clicked",
			    GTK_SIGNAL_FUNC (get_import_filename), NULL);
	gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION(openfile)->cancel_button),
				   "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy),
				   GTK_OBJECT(openfile));
	gtk_window_position(GTK_WINDOW (openfile), GTK_WIN_POS_CENTER);
	gtk_file_selection_set_filename(GTK_FILE_SELECTION (openfile), tstring);
        if (lastdir)
        	gtk_file_selection_set_filename(GTK_FILE_SELECTION (openfile), lastdir);
        else
        	gtk_file_selection_set_filename(GTK_FILE_SELECTION (openfile), "~/");
        gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION(openfile));
        gtk_widget_show(openfile);
}
/*******************************************************************************************/
void import_options()
{
	GtkWidget *vbox, *vbox2, *vbox3, *hbox, *frame, *hsep, *button, *button2;
	GtkWidget *frame3, *vbox5, *hbox2, *button3, *button4, *hbox3, *hbox4, *hbox5;
	extern GtkWidget *import_options_window, *import_options_radio, *import_options_radio2;
	extern GtkWidget *import_options_radio3, *import_options_radio4, *import_options_radio5;
	extern GtkWidget *import_options_radio6, *import_options_radio7, *import_options_radio8;
	extern GtkWidget *import_options_radio9, *import_options_radio10, *import_options_radio11;
	extern GtkWidget *import_options_entry;
	extern struct record3 config;
	
	
	if (import_options_window)
		return;
		
	import_options_window = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_signal_connect (GTK_OBJECT (import_options_window), "destroy",
			    GTK_SIGNAL_FUNC (gtk_widget_destroyed), &import_options_window);
	gtk_window_position(GTK_WINDOW (import_options_window), GTK_WIN_POS_CENTER);
	gtk_window_set_title (GTK_WINDOW (import_options_window), "Import Options");
	gtk_container_border_width (GTK_CONTAINER (import_options_window), 0);
	gtk_widget_set_usize(GTK_WIDGET (import_options_window), 0, 0);
	
	vbox = gtk_vbox_new (FALSE, 10);
     	gtk_container_border_width (GTK_CONTAINER (vbox), 0);
      	gtk_container_add (GTK_CONTAINER (import_options_window), vbox);
      	gtk_widget_show (vbox);
      	
      	vbox2 = gtk_vbox_new (FALSE, 10);
     	gtk_container_border_width (GTK_CONTAINER (vbox2), 10);
      	gtk_box_pack_start (GTK_BOX (vbox), vbox2, FALSE, TRUE, 0);
      	gtk_widget_show (vbox2);
      	
      	frame3 = gtk_frame_new("Import Filename:");
      	gtk_container_border_width (GTK_CONTAINER (frame3), 0);
      	gtk_box_pack_start (GTK_BOX (vbox2), frame3, FALSE, TRUE, 0);
      	gtk_widget_show(frame3);
      	
      	hbox3 = gtk_hbox_new (FALSE, 10);
      	gtk_container_add (GTK_CONTAINER (frame3), hbox3);
        gtk_container_border_width (GTK_CONTAINER (hbox3), 5);
        gtk_widget_show (hbox3);
      	
      	button4 = gtk_button_new_with_label("Import From...");
      	gtk_box_pack_start (GTK_BOX (hbox3), button4, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (button4), "clicked",
			    GTK_SIGNAL_FUNC (open_import), NULL);
      	gtk_widget_show (button4);
      	
      	import_options_entry = gtk_entry_new ();
      	gtk_box_pack_start (GTK_BOX (hbox3), import_options_entry, TRUE, TRUE, 0);
      	gtk_entry_set_text(GTK_ENTRY(import_options_entry), "/tmp/import.txt");
      	gtk_widget_show (import_options_entry);
      	
      	frame = gtk_frame_new("Import Field Format:");
      	gtk_container_border_width (GTK_CONTAINER (frame), 0);
      	gtk_box_pack_start (GTK_BOX (vbox2), frame, FALSE, TRUE, 0);
      	gtk_widget_show(frame);
      	
      	vbox3 = gtk_vbox_new (FALSE, 0);
        gtk_container_add (GTK_CONTAINER (frame), vbox3);
        gtk_container_border_width (GTK_CONTAINER (vbox3), 5);
        gtk_widget_show (vbox3);
        
        import_options_radio = gtk_radio_button_new_with_label(NULL,"Symbol Date Open High Low Close Volume OpenInt");
      	gtk_box_pack_start (GTK_BOX (vbox3), import_options_radio, FALSE, TRUE, 0);
      	gtk_widget_show (import_options_radio);

      	import_options_radio2 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(import_options_radio)), "Symbol Date High Low Close Volume");
      	gtk_box_pack_start (GTK_BOX (vbox3), import_options_radio2, FALSE, TRUE, 0);
      	gtk_widget_show (import_options_radio2);

      	import_options_radio3 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(import_options_radio)), "Symbol Date Close");
      	gtk_box_pack_start (GTK_BOX (vbox3), import_options_radio3, FALSE, TRUE, 0);
      	gtk_widget_show (import_options_radio3);
      	
      	import_options_radio4 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(import_options_radio)), "Symbol Date Open High Low Close");
      	gtk_box_pack_start (GTK_BOX (vbox3), import_options_radio4, FALSE, TRUE, 0);
      	gtk_widget_show (import_options_radio4);
      	
      	import_options_radio5 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(import_options_radio)), "Symbol Date Open High Low Close Volume");
      	gtk_box_pack_start (GTK_BOX (vbox3), import_options_radio5, FALSE, TRUE, 0);
      	gtk_widget_show (import_options_radio5);
      	
      	switch(config.import_field)
      	{
      		case 0: gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(import_options_radio), TRUE);
      			break;
      		case 1: gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(import_options_radio2), TRUE);
      			break;
      		case 2: gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(import_options_radio3), TRUE);
      			break;
      		case 3: gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(import_options_radio4), TRUE);
      			break;
      		case 4: gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(import_options_radio5), TRUE);
      			break;
      		default: break;
      	}
      	
      	hbox2 = gtk_hbox_new (FALSE, 10);
        gtk_container_border_width (GTK_CONTAINER (hbox2), 0);
        gtk_box_pack_start (GTK_BOX (vbox2), hbox2, TRUE, TRUE, 0);
        gtk_widget_show (hbox2);
      	
      	frame3 = gtk_frame_new("Date Format:");
      	gtk_container_border_width (GTK_CONTAINER (frame3), 0);
      	gtk_box_pack_start (GTK_BOX (hbox2), frame3, TRUE, TRUE, 0);
      	gtk_widget_show(frame3);
      	
      	vbox5 = gtk_vbox_new (FALSE, 0);
        gtk_container_add (GTK_CONTAINER (frame3), vbox5);
        gtk_container_border_width (GTK_CONTAINER (vbox5), 5);
        gtk_widget_show (vbox5);
        
        hbox3 = gtk_hbox_new (FALSE, 10);
        gtk_container_border_width (GTK_CONTAINER (hbox3), 0);
        gtk_box_pack_start (GTK_BOX (vbox5), hbox3, FALSE, TRUE, 0);
        gtk_widget_show (hbox3);
        
        import_options_radio6 = gtk_radio_button_new_with_label (NULL, "YYYYMMDD");
      	gtk_box_pack_start (GTK_BOX (hbox3), import_options_radio6, FALSE, TRUE, 0);
      	gtk_widget_show (import_options_radio6);
      	
      	import_options_radio7 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(import_options_radio6)), "YYMMDD");
      	gtk_box_pack_start (GTK_BOX (hbox3), import_options_radio7, FALSE, TRUE, 0);
      	gtk_widget_show (import_options_radio7);
      	
      	hbox4 = gtk_hbox_new (FALSE, 10);
        gtk_container_border_width (GTK_CONTAINER (hbox4), 0);
        gtk_box_pack_start (GTK_BOX (vbox5), hbox4, FALSE, TRUE, 0);
        gtk_widget_show (hbox4);
      	
      	import_options_radio8 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(import_options_radio6)), "MMDDYYYY");
      	gtk_box_pack_start (GTK_BOX (hbox4), import_options_radio8, FALSE, TRUE, 0);
      	gtk_widget_show (import_options_radio8);
      	
      	import_options_radio9 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(import_options_radio6)), "MMDDYY");
      	gtk_box_pack_start (GTK_BOX (hbox4), import_options_radio9, FALSE, TRUE, 0);
      	gtk_widget_show (import_options_radio9);
      	
      	hbox5 = gtk_hbox_new (FALSE, 10);
        gtk_container_border_width (GTK_CONTAINER (hbox5), 0);
        gtk_box_pack_start (GTK_BOX (vbox5), hbox5, FALSE, TRUE, 0);
        gtk_widget_show (hbox5);
      	
      	import_options_radio10 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(import_options_radio6)), "DDMMYYYY");
      	gtk_box_pack_start (GTK_BOX (hbox5), import_options_radio10, FALSE, TRUE, 0);
      	gtk_widget_show (import_options_radio10);
      	
      	import_options_radio11 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(import_options_radio6)), "DDMMYY");
      	gtk_box_pack_start (GTK_BOX (hbox5), import_options_radio11, FALSE, TRUE, 0);
      	gtk_widget_show (import_options_radio11);
      	
      	switch(config.import_date)
      	{
      		case 0: gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(import_options_radio6), TRUE);
      			break;
      		case 1: gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(import_options_radio7), TRUE);
      			break;
      		case 2: gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(import_options_radio8), TRUE);
      			break;
      		case 3: gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(import_options_radio9), TRUE);
      			break;
      		case 4: gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(import_options_radio10), TRUE);
      			break;
      		case 5: gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(import_options_radio11), TRUE);
      			break;
      		default: break;
      	}
      	
        hsep = gtk_hseparator_new();
	gtk_box_pack_start (GTK_BOX (vbox), hsep, FALSE, TRUE, 0);
        gtk_widget_show(hsep);
        
        hbox = gtk_hbutton_box_new();
        gtk_hbutton_box_set_spacing_default(10);
        gtk_hbutton_box_set_layout_default(GTK_BUTTONBOX_END);
        gtk_container_border_width (GTK_CONTAINER (hbox), 10);
        gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);
      	gtk_widget_show(hbox);
      		
      	button = gtk_button_new_with_label("OK");
      	gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (button), "clicked",
			    GTK_SIGNAL_FUNC (ok_import), NULL);
      	gtk_widget_show (button);
      		
      	button2 = gtk_button_new_with_label("Cancel");
      	gtk_box_pack_start (GTK_BOX (hbox), button2, FALSE, TRUE, 0);
      	gtk_signal_connect_object (GTK_OBJECT (button2), "clicked",
			    GTK_SIGNAL_FUNC (gtk_widget_destroy),
			    GTK_OBJECT(import_options_window));
      	gtk_widget_show (button2);
      	
      	button3 = gtk_button_new_with_label("Help");
      	gtk_box_pack_start (GTK_BOX (hbox), button3, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (button3), "clicked",
			    GTK_SIGNAL_FUNC (help_import_options_window), NULL);
      	gtk_widget_show (button3);
      	
      	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
      	gtk_widget_grab_default(button);	
      	gtk_widget_show(import_options_window);
}