/* 
 *  gstalker stock charter
 * 
 *  Copyright (c) 1998 Stefan S. Stratigakos
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 */

#include "myheader.h"
#include "myerrors.h"
#include <string.h>
#include <unistd.h>
#include <dirent.h>


/*************************************************************************************/
void yes_delete_group()
{
	int tint;
	GList *list = NULL;
	char tstring[250], *tstringpointer;
	extern GtkWidget *workwith_groups_clist, *yesno_window;
	extern char *grouppath;
	
	
	list = GTK_CLIST (workwith_groups_clist)->selection;
	tint = (int) list->data;
	gtk_clist_get_text (GTK_CLIST (workwith_groups_clist), tint, 0, &tstringpointer);  
	strcpy(tstring, grouppath);
	strcat(tstring, tstringpointer);
	unlink(tstring);
	gtk_clist_remove(GTK_CLIST(workwith_groups_clist), tint);
	if (yesno_window)
		gtk_widget_destroy(yesno_window);
}
/*************************************************************************************/
void ok_rename_group()
{
	struct dirent **dirlist;
	int tint, tint2;
	FILE *infile;
	char tstring[250], tstring2[250], *tstringpointer, *line[1];
	extern GtkWidget *rename_group_value_entry, *workwith_groups_clist, *rename_group_window;
	extern GtkWidget *rename_group_old_entry;
    	extern char *grouppath, *error_message;
	
	tstringpointer = gtk_entry_get_text(GTK_ENTRY(rename_group_value_entry));
	tstring[0] = 0;
	sscanf(tstringpointer, "%s", tstring);
	tint = strlen(tstring);
	if (tint == 0)
	  RETURN_ERR(gs_nothing_entered);

	if ((tstring[tint - 1] == '/') || (tstring[tint - 1] == '.'))
	  RETURN_ERR(gs_invalid_entry);

	strcpy(tstring2, grouppath);
	strcat(tstring2, tstring);
	infile = fopen(tstring2, "r");
	if (infile) {
	  fclose(infile);
	  RETURN_ERR(gs_already_exists);
	}
	strcpy(tstring2, grouppath);
	strcat(tstring2, tstringpointer);
	tstringpointer = gtk_entry_get_text(GTK_ENTRY(rename_group_old_entry));
	strcpy(tstring, grouppath);
	strcat(tstring, tstringpointer);
	rename(tstring, tstring2);
	
	gtk_clist_freeze (GTK_CLIST (workwith_groups_clist));
	gtk_clist_clear(GTK_CLIST(workwith_groups_clist));
	tint = scandir(grouppath, &dirlist, NULL, alphasort);
	tint2 = tint;
	for (tint = 2; tint < tint2; tint++)
	{
		strcpy(tstring, dirlist[tint]->d_name); 
   		line[0] = tstring;
		gtk_clist_append (GTK_CLIST (workwith_groups_clist), line);
	}
	gtk_clist_thaw (GTK_CLIST (workwith_groups_clist));
	if (rename_group_window)
		gtk_widget_destroy(rename_group_window);
}
/*************************************************************************************/
void rename_group()
{
	int tint;
	GList *list = NULL;
	gchar *tstringpointer;
    	GtkWidget *vbox, *hbox, *label, *button, *button2, *hsep, *hbox2, *hbox3;
    	GtkWidget *label2, *vbox2, *button3;
	extern GtkWidget *workwith_groups_clist, *rename_group_window, *rename_group_value_entry;
	extern GtkWidget *rename_group_old_entry;
	extern char *error_message;
    	
	
	if (rename_group_window)
		return;
	list = GTK_CLIST (workwith_groups_clist)->selection;
    	if (! list)
	  RETURN_ERR(gs_nothing_selected);

	tint = (int) list->data;
	gtk_clist_get_text (GTK_CLIST (workwith_groups_clist), tint, 0, &tstringpointer);
    		
	rename_group_window = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_signal_connect (GTK_OBJECT (rename_group_window), "destroy",
			    GTK_SIGNAL_FUNC (gtk_widget_destroyed), &rename_group_window);
	gtk_window_position(GTK_WINDOW (rename_group_window), GTK_WIN_POS_CENTER);
	gtk_window_set_title (GTK_WINDOW (rename_group_window), "Rename Group");
	gtk_container_border_width (GTK_CONTAINER (rename_group_window), 0);
	gtk_widget_set_usize(GTK_WIDGET (rename_group_window), 300, 0);
	
	vbox = gtk_vbox_new (FALSE, 0);
     	gtk_container_border_width (GTK_CONTAINER (vbox), 0);
      	gtk_container_add (GTK_CONTAINER (rename_group_window), vbox);
      	gtk_widget_show (vbox);
      	
      	vbox2 = gtk_vbox_new (FALSE, 10);
     	gtk_container_border_width (GTK_CONTAINER (vbox2), 0);
     	gtk_box_pack_start (GTK_BOX (vbox), vbox2, FALSE, TRUE, 10);
      	gtk_widget_show (vbox2);
      		
     	hbox = gtk_hbox_new(FALSE, 0);
        gtk_container_border_width (GTK_CONTAINER (hbox), 0);
        gtk_box_pack_start (GTK_BOX (vbox2), hbox, FALSE, TRUE, 0);
      	gtk_widget_show(hbox);
      		
      	label = gtk_label_new("Old:  ");
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, TRUE, 10);
        gtk_widget_show(label);
        	
        rename_group_old_entry = gtk_entry_new ();
      	gtk_box_pack_start (GTK_BOX (hbox), rename_group_old_entry, TRUE, TRUE, 10);
      	gtk_entry_set_text (GTK_ENTRY(rename_group_old_entry), tstringpointer);
      	gtk_editable_select_region (GTK_EDITABLE (rename_group_old_entry), 0, 0);
        gtk_widget_show(rename_group_old_entry);
        
        hbox2 = gtk_hbox_new(FALSE, 0);
        gtk_container_border_width (GTK_CONTAINER (hbox), 0);
        gtk_box_pack_start (GTK_BOX (vbox2), hbox2, FALSE, TRUE, 0);
      	gtk_widget_show(hbox2);
      	
	label2 = gtk_label_new("New: ");
	gtk_box_pack_start (GTK_BOX (hbox2), label2, FALSE, TRUE, 10);
        gtk_widget_show(label2);
			    
	rename_group_value_entry = gtk_entry_new ();
      	gtk_box_pack_start (GTK_BOX (hbox2), rename_group_value_entry, TRUE, TRUE, 10);
        gtk_widget_show(rename_group_value_entry);
        
        hsep = gtk_hseparator_new();
	gtk_box_pack_start (GTK_BOX (vbox), hsep, FALSE, TRUE, 0);
        gtk_widget_show(hsep);
        
        hbox3 = gtk_hbutton_box_new();
        gtk_hbutton_box_set_spacing_default(10);
        gtk_hbutton_box_set_layout_default(GTK_BUTTONBOX_END);
        gtk_box_pack_start (GTK_BOX (vbox), hbox3, FALSE, TRUE, 0);
        gtk_container_border_width (GTK_CONTAINER (hbox3), 10);
      	gtk_widget_show(hbox3);
      		
      	button = gtk_button_new_with_label("OK");
      	gtk_box_pack_start (GTK_BOX (hbox3), button, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (button), "clicked",
			    GTK_SIGNAL_FUNC (ok_rename_group), NULL);
      	gtk_widget_show (button);
      		
      	button2 = gtk_button_new_with_label("Cancel");
      	gtk_box_pack_start (GTK_BOX (hbox3), button2, FALSE, TRUE, 0);
      	gtk_signal_connect_object (GTK_OBJECT (button2), "clicked",
			    GTK_SIGNAL_FUNC (gtk_widget_destroy),
			    GTK_OBJECT(rename_group_window));
      	gtk_widget_show (button2);
      	
      	button3 = gtk_button_new_with_label("Help");
      	gtk_box_pack_start (GTK_BOX (hbox3), button3, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (button3), "clicked",
			    GTK_SIGNAL_FUNC (help_rename_group_window), NULL);
      	gtk_widget_show (button3);
      	
      	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
      	gtk_widget_grab_default(button);	
      	gtk_widget_show(rename_group_window);
}
/******************************************************************************************/
void edit_group_insert_button()
{
	gint tint, tint2;
    	GList *list = NULL, *list2 = NULL;
	gchar tstring[30], tstring2[60], tstring3[15], tstring4[15], *line[4], *text;
    	extern GtkWidget *edit_group_clist, *edit_group_clist2;
    	extern int edit_group_size;
    	extern char *error_message;
    	
    	
	list2 = GTK_CLIST (edit_group_clist2)->selection;
	if (list2)
	{
		list = GTK_CLIST(edit_group_clist)->selection;
		if (list)
		{
			gtk_clist_freeze (GTK_CLIST (edit_group_clist2));
			while (list)
			{
				tint = (int) list->data;
				tint2 = (int) list2->data;
				gtk_clist_get_text (GTK_CLIST (edit_group_clist), tint, 0, &text);
				strcpy(tstring, text);
				line[0] = tstring;
				gtk_clist_get_text (GTK_CLIST (edit_group_clist), tint, 1, &text);
				strcpy(tstring2, text);
				line[1] = tstring2;
				gtk_clist_get_text (GTK_CLIST (edit_group_clist), tint, 2, &text);
				strcpy(tstring3, text);
				line[2] = tstring3;
				gtk_clist_get_text (GTK_CLIST (edit_group_clist), tint, 3, &text);
				strcpy(tstring4, text);
				strcat(tstring4, "\n");
				line[3] = tstring4;
				gtk_clist_insert(GTK_CLIST (edit_group_clist2), tint2, line);
				edit_group_size++;
				list = list->next;
			}
			gtk_clist_thaw (GTK_CLIST (edit_group_clist2));
		}
		else
		  RETURN_ERR(gs_nothing_selected_edit);

    	}
    	else
	  RETURN_ERR(gs_nothing_selected_edit2);

}
/******************************************************************************************/
void edit_group_add_button()
{
	gint tint;
    	GList *list = NULL;
	gchar tstring[30], tstring2[60], tstring3[15], tstring4[15], *line[4], *text;
    	extern GtkWidget *edit_group_clist, *edit_group_clist2;
    	extern int edit_group_size;
    	extern char *error_message;
    	
    	
	list = GTK_CLIST (edit_group_clist)->selection;
	if (list)
	{
		gtk_clist_freeze (GTK_CLIST (edit_group_clist2));
		while (list)
		{
			tint = (int) list->data;
			gtk_clist_get_text (GTK_CLIST (edit_group_clist), tint, 0, &text);
			strcpy(tstring, text);
			line[0] = tstring;
			gtk_clist_get_text (GTK_CLIST (edit_group_clist), tint, 1, &text);
			strcpy(tstring2, text);
			line[1] = tstring2;
			gtk_clist_get_text (GTK_CLIST (edit_group_clist), tint, 2, &text);
			strcpy(tstring3, text);
			line[2] = tstring3;
			gtk_clist_get_text (GTK_CLIST (edit_group_clist), tint, 3, &text);
			strcpy(tstring4, text);
			strcat(tstring4, "\n");
			line[3] = tstring4;
			gtk_clist_append(GTK_CLIST (edit_group_clist2), line);
			edit_group_size++;
			list = list->next;
		}
		gtk_clist_thaw (GTK_CLIST (edit_group_clist2));
    	}
    	else
	  RETURN_ERR(gs_nothing_selected_edit);
}
/******************************************************************************************/
void edit_group_delete_button()
{
    	int tint;
    	GList *list = NULL;
    	extern GtkWidget *edit_group_clist2;
    	extern int edit_group_size;
    	extern char *error_message;
    	
    	

	list = GTK_CLIST (edit_group_clist2)->selection;
	if (list)
	{
		gtk_clist_freeze (GTK_CLIST (edit_group_clist2));
		tint = (int) list->data;
		gtk_clist_remove(GTK_CLIST (edit_group_clist2), tint);
		edit_group_size--;
		gtk_clist_thaw (GTK_CLIST (edit_group_clist2));
    	}
    	else
	  RETURN_ERR(gs_nothing_selected);
}
/****************************************************************************************/
void edit_group_ok_button()
{
	char tstring[250];
	int tint;
	char *text;
   	FILE *outfile;
   	extern GtkWidget *edit_group_clist2, *edit_group_window;
    	extern int edit_group_size, group_size, group_pointer;
    	extern char *edit_groupfilename, *error_message, *groupfilename;
    	
	
	outfile = fopen (edit_groupfilename, "wb");
	if (! outfile)
	  RETURN_ERR(gs_cant_open_group);

	for (tint = 0; tint <= edit_group_size; tint++)
	{
		gtk_clist_get_text (GTK_CLIST (edit_group_clist2), tint, 0, &text);
		strcpy(tstring, text);
		fwrite(&tstring, GROUP_RECORDSIZE, 1, outfile);
	}
	fclose(outfile);
	if (edit_group_window)
		gtk_widget_destroy(edit_group_window);
	if (groupfilename != NULL)
	{
		if (! strcmp(edit_groupfilename, groupfilename))
		{
			group_size = edit_group_size;
			if (group_pointer > group_size)
				group_pointer = group_size;
			load_file(text);
		}
	}
}
/****************************************************************************************/
void ok_edit_group()
{
    	char tstring[250], tstring2[250], tstring3[15], tstring4[15], tstring5[15], *line[5];
    	char *text2[] = {"Symbol", "Name", "Start", "End"}, *tstringpointer;
	GList *list = NULL;
    	int tint;
    	FILE *infile, *infile2;
    	unsigned long tlong;
    	GtkWidget *vbox, *ok_button, *add_button, *cancel_button, *insert_button, *delete_button;
    	GtkWidget *hbox, *help_button;
    	extern GtkWidget *workwith_groups_clist, *edit_group_window, *new_group_value_entry;
    	extern GtkWidget *edit_group_clist, *edit_group_clist2, *new_group_window;
    	extern GtkWidget *workwith_groups_window;
    	extern int edit_group_size, header_size;
    	extern char *edit_groupfilename, *grouppath, *error_message, *datapath;
    	struct record2 header;
    
	
	if (edit_group_window)
		return;
	if (new_group_window)
		tstringpointer = gtk_entry_get_text(GTK_ENTRY(new_group_value_entry));
	else
	{
    		list = GTK_CLIST (workwith_groups_clist)->selection;
    		if (! list)
		  RETURN_ERR(gs_nothing_selected);

		tint = (int) list->data;
		gtk_clist_get_text (GTK_CLIST (workwith_groups_clist), tint, 0, &tstringpointer);
	}
	strcpy(tstring, grouppath);
	strcat(tstring, tstringpointer);
       	infile = fopen (tstring, "rb");
       	if (! infile)
	  RETURN_ERR(gs_cant_open_group);
	  
       	if (edit_groupfilename != NULL)
       		free(edit_groupfilename);
       	edit_groupfilename = (char*)malloc(strlen(tstring) + 1);
       	strcpy(edit_groupfilename, tstring);
        	
	edit_group_window = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_signal_connect (GTK_OBJECT (edit_group_window), "destroy",
		    	    GTK_SIGNAL_FUNC (gtk_widget_destroyed), &edit_group_window);
	gtk_window_position(GTK_WINDOW (edit_group_window), GTK_WIN_POS_CENTER);
	strcpy(tstring, "Edit Group - [");
	strcat(tstring, tstringpointer);
	strcat(tstring, "]");
	gtk_window_set_title (GTK_WINDOW (edit_group_window), tstring);
	gtk_widget_set_usize(GTK_WIDGET (edit_group_window), 0, 0);
	
	if (workwith_groups_window)
       		gtk_widget_destroy(workwith_groups_window);
       	if (new_group_window)
		gtk_widget_destroy(new_group_window);
	
	hbox = gtk_hbox_new(FALSE, 10);
       	gtk_container_border_width (GTK_CONTAINER (hbox), 10);
       	gtk_container_add (GTK_CONTAINER (edit_group_window), hbox);
	gtk_widget_show(hbox);
      		
	edit_group_clist = gtk_clist_new_with_titles (4, text2);
	gtk_clist_set_column_width(GTK_CLIST(edit_group_clist), 0, 70);
	gtk_clist_set_column_width(GTK_CLIST(edit_group_clist), 1, 200);
	gtk_clist_set_column_width(GTK_CLIST(edit_group_clist), 2, 70);
	gtk_clist_set_column_width(GTK_CLIST(edit_group_clist), 3, 70);
	gtk_clist_set_selection_mode (GTK_CLIST (edit_group_clist), GTK_SELECTION_MULTIPLE);
	gtk_clist_set_policy(GTK_CLIST(edit_group_clist),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
 	gtk_container_add (GTK_CONTAINER (hbox), edit_group_clist);
      	gtk_container_border_width (GTK_CONTAINER (edit_group_clist), 0);
      	gtk_widget_set_usize(GTK_WIDGET (edit_group_clist), 200, 0);
      	gtk_widget_show (edit_group_clist);
      		
      	vbox = gtk_vbutton_box_new();
      	gtk_container_border_width (GTK_CONTAINER (vbox), 0);
      	gtk_box_pack_start (GTK_BOX (hbox), vbox, FALSE, TRUE, 0);
      	gtk_vbutton_box_set_spacing_default(5);
      	gtk_vbutton_box_set_layout_default(GTK_BUTTONBOX_START);
      	gtk_widget_show (vbox);
      	
      	edit_group_clist2 = gtk_clist_new_with_titles (4, text2);
	gtk_clist_set_column_width(GTK_CLIST(edit_group_clist2), 0, 70);
	gtk_clist_set_column_width(GTK_CLIST(edit_group_clist2), 1, 200);
	gtk_clist_set_column_width(GTK_CLIST(edit_group_clist2), 2, 70);
	gtk_clist_set_column_width(GTK_CLIST(edit_group_clist2), 3, 70);
	gtk_clist_set_selection_mode (GTK_CLIST (edit_group_clist2), GTK_SELECTION_MULTIPLE);
	gtk_clist_set_policy(GTK_CLIST(edit_group_clist2),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
      		
      	gtk_container_add (GTK_CONTAINER (hbox), edit_group_clist2);
      	gtk_container_border_width (GTK_CONTAINER (edit_group_clist2), 0);
      	gtk_widget_set_usize(GTK_WIDGET (edit_group_clist2), 200, 0);
      	gtk_widget_show (edit_group_clist2);
      		
      	insert_button = gtk_button_new_with_label("Insert");
      	gtk_box_pack_start (GTK_BOX (vbox), insert_button, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (insert_button), "clicked",
			    GTK_SIGNAL_FUNC (edit_group_insert_button), NULL);
      	gtk_widget_show (insert_button);
      		
	add_button = gtk_button_new_with_label("Add");
      	gtk_box_pack_start (GTK_BOX (vbox), add_button, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (add_button), "clicked",
			    GTK_SIGNAL_FUNC (edit_group_add_button), NULL);
      	gtk_widget_show (add_button);
      		
      	delete_button = gtk_button_new_with_label("Delete");
      	gtk_box_pack_start (GTK_BOX (vbox), delete_button, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (delete_button), "clicked",
			    GTK_SIGNAL_FUNC (edit_group_delete_button), NULL);
      	gtk_widget_show (delete_button);
      		
      	ok_button = gtk_button_new_with_label("OK");
      	gtk_box_pack_start (GTK_BOX (vbox), ok_button, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (ok_button), "clicked",
			    GTK_SIGNAL_FUNC (edit_group_ok_button), NULL);
      	gtk_widget_show (ok_button);
      		
      	cancel_button = gtk_button_new_with_label("Cancel");
      	gtk_box_pack_start (GTK_BOX (vbox), cancel_button, FALSE, TRUE, 0);
      	gtk_signal_connect_object (GTK_OBJECT (cancel_button), "clicked",
			    GTK_SIGNAL_FUNC (gtk_widget_destroy),
			    GTK_OBJECT(edit_group_window));
      	gtk_widget_show (cancel_button);
      	
      	help_button = gtk_button_new_with_label("Help");
      	gtk_box_pack_start (GTK_BOX (vbox), help_button, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (help_button), "clicked",
			    GTK_SIGNAL_FUNC (help_edit_group_window), NULL);
      	gtk_widget_show (help_button);
  		
  	gtk_clist_freeze (GTK_CLIST (edit_group_clist2));
  	fseek(infile, 0L, SEEK_END);
	tlong = ftell(infile);
	edit_group_size = tlong / GROUP_RECORDSIZE;
	edit_group_size--;
	fseek(infile, 0L, SEEK_SET);
	for (tint = 0; tint <= edit_group_size; tint++)
	{
		fread(tstring2, GROUP_RECORDSIZE, 1, infile);
		strcpy(tstring, datapath);
		strcat(tstring, tstring2); 
   		infile2 = fopen(tstring, "rb");
   		if (infile2)
   		{
   			fread(&header, header_size, 1, infile2);
			line[1] = header.name;
			line[0] = header.symbol;
			sprintf(tstring5, "%ld", header.first_date);
			tstring3[0] = tstring5[4];
			tstring3[1] = tstring5[5];
			tstring3[2] = '/';
			tstring3[3] = tstring5[6];
			tstring3[4] = tstring5[7];
			tstring3[5] = '/';
			tstring3[6] = tstring5[0];
			tstring3[7] = tstring5[1];
			tstring3[8] = tstring5[2];
			tstring3[9] = tstring5[3];
			tstring3[10] = 0;
			line[2] = tstring3;
			sprintf(tstring5, "%ld", header.last_date);
			tstring4[0] = tstring5[4];
			tstring4[1] = tstring5[5];
			tstring4[2] = '/';
			tstring4[3] = tstring5[6];
			tstring4[4] = tstring5[7];
			tstring4[5] = '/';
			tstring4[6] = tstring5[0];
			tstring4[7] = tstring5[1];
			tstring4[8] = tstring5[2];
			tstring4[9] = tstring5[3];
			tstring4[10] = 0;
			line[3] = tstring4;
			fclose(infile2);
			gtk_clist_append (GTK_CLIST (edit_group_clist2), line);
		}
	}
	gtk_clist_thaw (GTK_CLIST (edit_group_clist2));
	fclose(infile);
	show_chart_list(edit_group_clist);		
	gtk_widget_show(edit_group_window);
}
/*****************************************************************************************/
void ok_delete_group()
{
	GList *list = NULL;
	int tint;
	char *tstringpointer, tstring[250];
    	extern GtkWidget *workwith_groups_clist,*yesno_window,*yesno_yes_button,*yesno_no_button;
	extern int global_int;
	extern char *error_message;
    	

	if (yesno_window)
		return;
    	list = GTK_CLIST (workwith_groups_clist)->selection;
    	if (! list)
	  RETURN_ERR(gs_nothing_selected);

	tint = (int) list->data;
	global_int = tint;
	gtk_clist_get_text (GTK_CLIST (workwith_groups_clist),tint,0,&tstringpointer);  
	
      	strcpy(tstring, "Are you sure you want to delete ");
      	strcat(tstring, tstringpointer);
      	strcat(tstring, " ?");
	show_yesno_window(tstring);
      	gtk_signal_connect (GTK_OBJECT (yesno_yes_button), "clicked",
			    GTK_SIGNAL_FUNC (yes_delete_group), NULL);
      	gtk_signal_connect_object (GTK_OBJECT (yesno_no_button), "clicked",
			    GTK_SIGNAL_FUNC (gtk_widget_destroy),
			    GTK_OBJECT(yesno_window));
}
/****************************************************************************************/
void load_group()
{
	gchar tstring[250], *text;
	FILE *infile;
	int tint = 0;
	GList *list = NULL;
	long tlong;
    	extern GtkWidget *workwith_groups_clist, *workwith_groups_window;
    	extern char *groupfilename, *grouppath, *error_message;
    	extern int group_pointer, group_size, open_file_flag;
    	extern struct record3 config;

	
	list = GTK_CLIST (workwith_groups_clist)->selection;
	if (! list)
	  RETURN_ERR(gs_nothing_selected);

	tint = (int) list->data;
	gtk_clist_get_text (GTK_CLIST (workwith_groups_clist), tint, 0, &text);  
	strcpy(tstring, grouppath);
	strcat(tstring, text);
	infile = fopen(tstring, "rb");
	if (! infile)
	  RETURN_ERR(gs_cant_open_group);

	fseek(infile, 0L, SEEK_END);
	tlong = ftell(infile);
	group_size = tlong / GROUP_RECORDSIZE;
	fclose(infile);
	if (group_size > 0)
	{
		group_size--;
		if (groupfilename != NULL)
        		free(groupfilename);
        	groupfilename = (char*)malloc(strlen(tstring) + 1);
        	strcpy(groupfilename, tstring);
        	strcpy(config.last_group, text);
		group_pointer = 0;
		open_file_flag = 0;
       		load_file(tstring);
       		if (workwith_groups_window)
       			gtk_widget_destroy(workwith_groups_window);
	}
	else
	  RETURN_ERR(gs_group_empty);
}
/****************************************************************************************/
void create_group()
{
	gchar tstring[250];
	FILE *infile;
	gchar *infilename;
	extern GtkWidget *new_group_value_entry;
    	extern char *grouppath, *error_message;
	
	
	infilename = gtk_entry_get_text(GTK_ENTRY(new_group_value_entry));
	if (strlen(infilename) != 0)
	{
	       strcpy(tstring, grouppath);
               strcat(tstring, infilename);
	       infile = fopen(tstring, "rb");
	       if (infile) {
		 fclose(infile);
		 RETURN_ERR(gs_already_exists);
	       }
	       else
	       {
	       		infile = fopen(tstring, "wb");
	       		if (! infile)
			  RETURN_ERR(gs_cant_create);

	       		fclose(infile);
	       		ok_edit_group();
	       }
	}
	else
	  RETURN_ERR(gs_nothing_entered);
}
/***********************************************************************************/
void new_group()
{
	GtkWidget *vbox, *hbox, *hbox2, *label, *button, *button2, *button3, *hsep;
	extern GtkWidget *new_group_window, *new_group_value_entry;
    	
	
	if (new_group_window)
		return;
		
	new_group_window = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_signal_connect (GTK_OBJECT (new_group_window), "destroy",
			    GTK_SIGNAL_FUNC (gtk_widget_destroyed), &new_group_window);
	gtk_window_position(GTK_WINDOW (new_group_window), GTK_WIN_POS_CENTER);
	gtk_window_set_title (GTK_WINDOW (new_group_window), "New Group");
	gtk_widget_set_usize(GTK_WIDGET (new_group_window), 300, 0);
	
	vbox = gtk_vbox_new (FALSE, 0);
      	gtk_container_add (GTK_CONTAINER (new_group_window), vbox);
      	gtk_widget_show (vbox);
      	
     	hbox = gtk_hbox_new (FALSE, 10);
      	gtk_container_border_width (GTK_CONTAINER (hbox), 10);
      	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);
      	gtk_widget_show (hbox);
      	
	label = gtk_label_new("New group:");
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, TRUE, 0);
        gtk_widget_show(label);
        
	new_group_value_entry = gtk_entry_new ();
     	gtk_box_pack_start (GTK_BOX (hbox), new_group_value_entry, TRUE, TRUE, 0);
        gtk_widget_show(new_group_value_entry);
        
        hsep = gtk_hseparator_new();
	gtk_box_pack_start (GTK_BOX (vbox), hsep, FALSE, TRUE, 0);
        gtk_widget_show(hsep);
        
        hbox2 = gtk_hbutton_box_new();
        gtk_hbutton_box_set_spacing_default(10);
        gtk_hbutton_box_set_layout_default(GTK_BUTTONBOX_END);
        gtk_container_border_width (GTK_CONTAINER (hbox2), 10);
        gtk_box_pack_start (GTK_BOX (vbox), hbox2, FALSE, TRUE, 0);
      	gtk_widget_show(hbox2);
      	
      	button = gtk_button_new_with_label("OK");
      	gtk_box_pack_start (GTK_BOX (hbox2), button, TRUE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (button), "clicked",
			    GTK_SIGNAL_FUNC (create_group), NULL);
	gtk_widget_show (button);
	
	button2 = gtk_button_new_with_label("Cancel");
      	gtk_box_pack_start (GTK_BOX (hbox2), button2, TRUE, TRUE, 0);
      	gtk_signal_connect_object (GTK_OBJECT (button2), "clicked",
			    GTK_SIGNAL_FUNC (gtk_widget_destroy),
			    GTK_OBJECT(new_group_window));
      	gtk_widget_show (button2);
      	
      	button3 = gtk_button_new_with_label("Help");
      	gtk_box_pack_start (GTK_BOX (hbox2), button3, TRUE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (button3), "clicked",
			    GTK_SIGNAL_FUNC (help_new_group_window), NULL);
      	gtk_widget_show (button3);
      	
      	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
      	gtk_widget_grab_default(button);
      	gtk_widget_show(new_group_window);
}
/****************************************************************************************/
void workwith_groups()
{
	struct dirent **dirlist;
	int tint, tint2;
	gchar *text[] = {"Group Name:"}, *line[1], tstring[250];
	GtkWidget *vbox, *hbox, *open_button, *edit_button, *rename_button, *delete_button;
	GtkWidget *cancel_button, *help_button;
	extern GtkWidget *workwith_groups_window, *workwith_groups_clist, *workwith_charts_window;
	extern char *grouppath, *error_message;

    	
	if (workwith_groups_window)
		return;
	if (workwith_charts_window)
		return;
		
	workwith_groups_window = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_signal_connect (GTK_OBJECT (workwith_groups_window), "destroy",
			    GTK_SIGNAL_FUNC (gtk_widget_destroyed), &workwith_groups_window);
	gtk_window_position(GTK_WINDOW (workwith_groups_window), GTK_WIN_POS_CENTER);
	gtk_window_set_title (GTK_WINDOW (workwith_groups_window), "Work With Groups");
	gtk_container_border_width (GTK_CONTAINER (workwith_groups_window), 0);
	
	hbox = gtk_hbox_new (FALSE, 10);
      	gtk_container_border_width (GTK_CONTAINER (hbox), 10);
      	gtk_container_add (GTK_CONTAINER (workwith_groups_window), hbox);
      	gtk_widget_show (hbox);
      	
      	workwith_groups_clist = gtk_clist_new_with_titles (1, text);
      	gtk_clist_set_selection_mode (GTK_CLIST (workwith_groups_clist), GTK_SELECTION_SINGLE);
       	gtk_clist_set_policy(GTK_CLIST(workwith_groups_clist),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
      	gtk_container_add (GTK_CONTAINER (hbox), workwith_groups_clist);
      	gtk_container_border_width (GTK_CONTAINER (workwith_groups_clist), 0);
      	gtk_widget_set_usize(GTK_WIDGET (workwith_groups_clist), 350, 0);
      	gtk_widget_show (workwith_groups_clist);
      	
      	vbox = gtk_vbutton_box_new ();
      	gtk_container_border_width (GTK_CONTAINER (vbox), 0);
      	gtk_box_pack_start (GTK_BOX (hbox), vbox, FALSE, TRUE, 0);
      	gtk_vbutton_box_set_spacing_default(5);
      	gtk_vbutton_box_set_layout_default(GTK_BUTTONBOX_START);
      	gtk_widget_show (vbox);
      	
      	open_button = gtk_button_new_with_label("Open");
      	gtk_box_pack_start (GTK_BOX (vbox), open_button, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (open_button), "clicked",
			    GTK_SIGNAL_FUNC (load_group), NULL);
	gtk_widget_show (open_button);
	
      	edit_button = gtk_button_new_with_label("Edit");
      	gtk_box_pack_start (GTK_BOX (vbox), edit_button, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (edit_button), "clicked",
			    GTK_SIGNAL_FUNC (ok_edit_group), NULL);
	gtk_widget_show (edit_button);
	
      	rename_button = gtk_button_new_with_label("Rename");
      	gtk_box_pack_start (GTK_BOX (vbox), rename_button, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (rename_button), "clicked",
			    GTK_SIGNAL_FUNC (rename_group), NULL);
	gtk_widget_show (rename_button);
	
      	delete_button = gtk_button_new_with_label("Delete");
      	gtk_box_pack_start (GTK_BOX (vbox), delete_button, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (delete_button), "clicked",
			    GTK_SIGNAL_FUNC (ok_delete_group), NULL);
	gtk_widget_show (delete_button);
      	
      	cancel_button = gtk_button_new_with_label("Cancel");
      	gtk_box_pack_start (GTK_BOX (vbox), cancel_button, FALSE, TRUE, 0);
      	gtk_signal_connect_object (GTK_OBJECT (cancel_button), "clicked",
			    GTK_SIGNAL_FUNC (gtk_widget_destroy),
			    GTK_OBJECT(workwith_groups_window));
      	gtk_widget_show (cancel_button);
      	
      	help_button = gtk_button_new_with_label("Help");
      	gtk_box_pack_start (GTK_BOX (vbox), help_button, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (help_button), "clicked",
			    GTK_SIGNAL_FUNC (help_workwith_groups_window), NULL);
      	gtk_widget_show (help_button);
      	
	gtk_clist_freeze (GTK_CLIST (workwith_groups_clist));
	tint = scandir(grouppath, &dirlist, NULL, alphasort);
	if (tint < 0)
	  RETURN_ERR(gs_group_missing);

	tint2 = tint;
	for (tint = 2; tint < tint2; tint++)
	{
		strcpy(tstring, dirlist[tint]->d_name); 
   		line[0] = tstring;
		gtk_clist_append (GTK_CLIST (workwith_groups_clist), line);
	}
	gtk_clist_thaw (GTK_CLIST (workwith_groups_clist));
      	
      	gtk_widget_show(workwith_groups_window);
}
/****************************************************************************************/
void load_first_group()
{
	gchar tstring[250];
	FILE *infile;
	long tlong;
    	extern char *groupfilename, *grouppath;
    	extern int group_pointer, open_file_flag, group_size;
    	extern struct record3 config;
    	

	strcpy(tstring, grouppath);
	strcat(tstring, config.last_group);
      	infile = fopen(tstring, "rb");
      	if (! infile)
		return;
      	fseek(infile, 0L, SEEK_END);
	tlong = ftell(infile);
	group_size = tlong / GROUP_RECORDSIZE;
	fclose(infile);
	if (group_size > 0)
	{
		group_size--;
		if (groupfilename != NULL)
       			free(groupfilename);
       		groupfilename = (char*)malloc(strlen(tstring) + 1);
       		strcpy(groupfilename, tstring);
		group_pointer = 0;
      		open_file_flag = 0;
		load_file(tstring);
	}
}
