/*
    Copyright (C) 1998  Dennis Roddeman
    email: dennis.roddeman@uibk.ac.at

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.


    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation 
    59 Temple Place, Suite 330, Boston, MA, 02111-1307, USA
*/

#include "tochnog.h"

long int check( long int idat, long int task )

{
  long int data_number=0, ok=1;

  data_number = scalar_iabs( idat );

    // some often used data first for speed; the rest alphabetical
  if ( data_number==NODE ) 
    ok = 1;
  if ( data_number==ELEMENT ) 
    ok = 1;
  if ( data_number==BAR2 )
    ok = check_ndim( 1, 1, task );
  if ( data_number==BAR3 )
    ok = check_ndim( 1, 1, task );
  if ( data_number==BAR4 )
    ok = check_ndim( 1, 1, task );
  if ( data_number==BAR5 )
    ok = check_ndim( 1, 1, task );
  if ( data_number==HEX8 )
    ok = check_ndim( 3, 3, task );
  if ( data_number==HEX27 )
    ok = check_ndim( 3, 3, task );
  if ( data_number==HEX64 )
    ok = check_ndim( 3, 3, task );
  if ( data_number==HEX125 )
    ok = check_ndim( 3, 3, task );
  if ( data_number==QUAD4 )
    ok = check_ndim( 2, 2, task );
  if ( data_number==QUAD9 )
    ok = check_ndim( 2, 2, task );
  if ( data_number==QUAD16 )
    ok = check_ndim( 2, 2, task );
  if ( data_number==QUAD25 )
    ok = check_ndim( 2, 2, task );
  if ( data_number==TET4 )
    ok = check_ndim( 3, 3, task );
  if ( data_number==TRIA3 )
    ok = check_ndim( 2, 2, task );
  if ( data_number==BAR )
    ok = check_ndim( 1, 1, task );
  if ( data_number==BOUNDA_FORCE )
    ok = check_unknowns_are_specified( task );
  if ( data_number==BOUNDA_SINE )
    ok = check_unknowns_are_specified( task );
  if ( data_number==BOUNDA_TIME )
    ok = check_unknowns_are_specified( task );
  if ( data_number==BOUNDA_TIME_FILE )
    ok = check_unknowns_are_specified( task );
  if ( data_number==BOUNDA_UNKNOWN )
    ok = check_unknowns_are_specified( task );
  if ( data_number==BRICK )
    ok = check_ndim( 3, 3, task );
  if ( data_number==BUCKLING )
    ok = check_unknown( "materi_stress", YES, task );
  if ( data_number==CIRCLE )
    ok = check_ndim( 2, 2, task );
  if ( data_number==CIRCLE_HOLLOW )
    ok = check_ndim( 2, 2, task );
  if ( data_number==CONDIF ) {
    ok = check_unknown( "condif_temperature", YES, task );
    ok = ok && check_unknown( "wave_scalar", NO, task );
  }
  if ( data_number==CONDIF_CONVECTION ) {
    ok = check_ndim( 2, 3, task );
    ok = ok && check_unknown( "condif_temperature", YES, task );
  }
  if ( data_number==CONDIF_CONVECTION_GEOMETRY ) {
    ok = check_ndim( 2, 3, task );
    ok = ok && check_unknown( "condif_temperature", YES, task );
  }
  if ( data_number==CONDIF_RADIATION ) {
    ok = check_ndim( 2, 3, task );
    ok = check_unknown( "condif_temperature", YES, task );
  }
  if ( data_number==CONDIF_RADIATION_GEOMETRY ) {
    ok = check_ndim( 2, 3, task );
    ok = check_unknown( "condif_temperature", YES, task );
  }
  if ( data_number==CONTACT_FRICTION )
    ok = check_unknown( "materi_velocity", YES, task );
  if ( data_number==CONTACT_GEOMETRY )
    ok = check_unknown( "materi_velocity", YES, task );
  if ( data_number==CONTACT_HEAT_GENERATION ) {
    ok = check_unknown( "materi_velocity", YES, task );
    ok = ok && check_unknown( "condif_temperature", YES, task );
  }
  if ( data_number==CONTACT_PENALTY_PRESSURE ) {
    ok = check_unknown( "materi_velocity", YES, task );
    ok = ok && check_unknown( "groundflow_pressure", YES, task );
  }
  if ( data_number==CONTACT_PENALTY_TEMPERATURE ) {
    ok = check_unknown( "materi_velocity", YES, task );
    ok = ok && check_unknown( "condif_temperature", YES, task );
  }
  if ( data_number==CONTACT_PENALTY_VELOCITY )
    ok = check_unknown( "materi_velocity", YES, task );
  if ( data_number==CONTROL_EIGEN )
    ok = check_unknowns_are_specified( task );
  if ( data_number==CONTROL_EIGEN_SCALE )
    ok = check_unknowns_are_specified( task );
  if ( data_number==CONTROL_MESH_SPLIT )
    ok = check_ndim( 2, 3, task );
  if ( data_number==CONTROL_PRINT_GMV )
    ok = check_ndim( 2, 3, task );
  if ( data_number==CONTROL_RELAXATION_CONDIF_TEMPERATURE )
    ok = check_unknown( "condif_temperature", YES, task );
  if ( data_number==CONTROL_RELAXATION_GROUNDFLOW_PRESSURE )
    ok = check_unknown( "groundflow_pressure", YES, task );
  if ( data_number==CONTROL_RELAXATION_WAVE_FSCALAR )
    ok = check_unknown( "wave_fscalar", YES, task );
  if ( data_number==CONTROL_RELAXATION_MATERI_VELOCITY )
    ok = check_unknown( "materi_velocity", YES, task );
  if ( data_number==CONTROL_SKIP_INERTIA_CONDIF_TEMPERATURE )
    ok = check_unknown( "condif_temperature", YES, task );
  if ( data_number==CONTROL_SKIP_INERTIA_MATERI_VELOCITY )
    ok = check_unknown( "materi_velocity", YES, task );
  if ( data_number==CONTROL_SKIP_INERTIA_GROUNDFLOW_PRESSURE )
    ok = check_unknown( "groundflow_pressure", YES, task );
  if ( data_number==CONTROL_SKIP_INERTIA_WAVE_FSCALAR )
    ok = check_unknown( "wave_fscalar", YES, task );
  if ( data_number==CONTROL_SKIP_SPATIAL_STABILIZATION )
    ok = check_unknowns_are_specified( task );
  if ( data_number==CONTROL_SOLVER )
    ok = check_unknowns_are_specified( task );
  if ( data_number==CONTROL_TIMESTEP_ITERATIONS_AUTOMATIC )
    ok = check_unknowns_are_specified( task );
  if ( data_number==CYLINDER_HOLLOW )
    ok = check_ndim( 3, 3, task );
  if ( data_number==DEPENDENCY_DIAGRAM )
    ok = check_unknowns_are_specified( task );
  if ( data_number==DEPENDENCY_ITEM )
    ok = check_unknowns_are_specified( task );
  if ( data_number==DOF_LABEL )
    ok = check_unknowns_are_specified( task );
  if ( data_number==DOF_TYINGS )
    ok = check_unknowns_are_specified( task );
  if ( data_number==FORCE_ELEMENT_EDGE )
    ok = check_unknowns_are_specified( task );
  if ( data_number==FORCE_ELEMENT_EDGE_GEOMETRY )
    ok = check_unknowns_are_specified( task );
  if ( data_number==FORCE_ELEMENT_EDGE_TIME )
    ok = check_unknowns_are_specified( task );
  if ( data_number==FORCE_ELEMENT_VOLUME )
    ok = check_unknowns_are_specified( task );
  if ( data_number==FORCE_ELEMENT_VOLUME_FACTOR ) {
    ok = check_unknowns_are_specified( task );
    ok = ok && check_ndim( 1, 2, task );
  }
  if ( data_number==FORCE_ELEMENT_VOLUME_GEOMETRY )
    ok = check_unknowns_are_specified( task );
  if ( data_number==FORCE_ELEMENT_VOLUME_TIME ) {
    ok = check_unknowns_are_specified( task );
    ok = ok && check_ndim( 1, 2, task );
  }
  if ( data_number==FORCE_GRAVITY )
    ok = check_unknown( "materi_velocity", YES, task );
  if ( data_number==FORCE_GRAVITY_TIME )
    ok = check_unknown( "materi_velocity", YES, task );
  if ( data_number==GEOMETRY_BOUNDA_FACTOR )
    ok = check_ndim( 2, 3, task );
  if ( data_number==GEOMETRY_CIRCLE )
    ok = check_ndim( 2, 2, task );
  if ( data_number==GEOMETRY_CYLINDER )
    ok = check_ndim( 3, 3, task );
  if ( data_number==GEOMETRY_POLYNOMIAL )
    ok = check_ndim( 2, 3, task );
  if ( data_number==GEOMETRY_QUADRILATERAL )
    ok = check_ndim( 2, 3, task );
  if ( data_number==GEOMETRY_SPHERE )
    ok = check_ndim( 3, 3, task );
  if ( data_number==GEOMETRY_TRIANGLE )
    ok = check_ndim( 2, 3, task );
  if ( data_number==FORCE_GRAVITY )
    ok = check_unknown( "materi_velocity", YES, task );
  if ( data_number==FORCE_GRAVITY )
    ok = check_unknown( "materi_velocity", YES, task );
  if ( data_number==GROUNDFLOW )
    ok = check_unknown( "wave_scalar", NO, task );
  if ( data_number==GROUNDFLOW_PRESSURE )
    ok = check_unknown( "groundflow_pressure", YES, task );
  if ( data_number==GROUP_CONDIF_CONDUCTIVITY )
    ok = check_unknown( "condif_temperature", YES, task );
  if ( data_number==GROUP_CONDIF_DENSITY )
    ok = check_unknown( "condif_temperature", YES, task );
  if ( data_number==GROUP_CONDIF_CAPACITY )
    ok = check_unknown( "condif_temperature", YES, task );
  if ( data_number==GROUP_CONDIF_FLOW )
    ok = check_unknown( "condif_temperature", YES, task );
  if ( data_number==GROUP_GROUNDFLOW_COMPRESSIBILITY )
    ok = check_unknown( "groundflow_pressure", YES, task );
  if ( data_number==GROUP_GROUNDFLOW_DENSITY )
    ok = check_unknown( "groundflow_pressure", YES, task );
  if ( data_number==GROUP_GROUNDFLOW_PERMEABILITY )
    ok = check_unknown( "groundflow_pressure", YES, task );
  if ( data_number==GROUP_INTEGRATION_POINTS )
    ok = check_unknowns_are_specified( task );
  if ( data_number==GROUP_MATERI_DAMAGE_FAILURE )
    ok = check_unknown( "materi_damage", YES, task );
  if ( data_number==GROUP_MATERI_DAMAGE_MAZARS )
    ok = check_unknown( "materi_damage", YES, task );
  if ( data_number==GROUP_MATERI_DAMPING )
    ok = check_unknown( "materi_velocity", YES, task );
  if ( data_number==GROUP_MATERI_DENSITY )
    ok = check_unknown( "materi_velocity", YES, task );
  if ( data_number==GROUP_MATERI_DENSITY_MINIMUM ) {
    ok = check_unknown( "materi_velocity", YES, task );
    ok = check_unknown( "materi_density", YES, task );
  }
  if ( data_number==GROUP_MATERI_EXPANSION_LINEAR )
    ok = check_unknown( "condif_temperature", YES, task );
  if ( data_number==GROUP_MATERI_EXPANSION_VOLUME )
    ok = check_unknown( "condif_temperature", YES, task );
  if ( data_number==GROUP_MATERI_ELASTI_COMPRESSIBILITY ) {
    ok = check_unknown( "materi_stress", YES, task );
    ok = ok && check_unknown( "materi_velocity", YES, task );
  }
  if ( data_number==GROUP_MATERI_ELASTI_POISSON ) {
    ok = check_unknown( "materi_stress", YES, task );
    ok = ok && check_unknown( "materi_velocity", YES, task );
  }
  if ( data_number==GROUP_MATERI_ELASTI_TRANSVERSE_ISOTROPY ) {
    ok = check_unknown( "materi_stress", YES, task );
    ok = ok && check_unknown( "materi_velocity", YES, task );
  }
  if ( data_number==GROUP_MATERI_ELASTI_YOUNG ) {
    ok = check_unknown( "materi_stress", YES, task );
    ok = ok && check_unknown( "materi_velocity", YES, task );
  }
  if ( data_number==GROUP_MATERI_HYPER_BESSELING ) {
    ok = check_unknown( "materi_displacement", YES, task );
    ok = ok && check_unknown( "materi_strain_elasti", YES, task );
    ok = ok && check_unknown( "materi_stress", YES, task );
  }
  if ( data_number==GROUP_MATERI_HYPER_MOONEY_RIVLIN ) {
    ok = check_unknown( "materi_displacement", YES, task );
    ok = ok && check_unknown( "materi_strain_elasti", YES, task );
    ok = ok && check_unknown( "materi_stress", YES, task );
  }
  if ( data_number==GROUP_MATERI_MAXWELL_CHAIN )
    ok = check_unknown( "materi_maxwell_stress", YES, task );
  if ( data_number==GROUP_MATERI_MEMBRANE ) {
    ok = check_ndim( 1, 2, task );
    ok = check_unknown( "groundflow_pressure", NO, task );
  }
  if ( data_number==GROUP_MATERI_MEMORY )
    ok = check_unknown( "materi_stress", YES, task );
  if ( data_number==GROUP_MATERI_PLASTI_COMPRESSION )
    ok = check_unknown( "materi_strain_plasti", YES, task );
  if ( data_number==GROUP_MATERI_PLASTI_DRUCKPRAG )
    ok = check_unknown( "materi_strain_plasti", YES, task );
  if ( data_number==GROUP_MATERI_PLASTI_GURSON )
    ok = check_unknown( "materi_strain_plasti", YES, task );
  if ( data_number==GROUP_MATERI_PLASTI_HEAT_GENERATION ) {
    ok = check_unknown( "materi_strain_plasti", YES, task );
    ok = check_unknown( "condif_temperature", YES, task );
  }
  if ( data_number==GROUP_MATERI_PLASTI_KINEMATIC_HARDENING )
    ok = check_unknown( "materi_strain_plasti", YES, task );
  if ( data_number==GROUP_MATERI_PLASTI_MOHRCOUL )
    ok = check_unknown( "materi_strain_plasti", YES, task );
  if ( data_number==GROUP_MATERI_PLASTI_TENSION )
    ok = check_unknown( "materi_strain_plasti", YES, task );
  if ( data_number==GROUP_MATERI_PLASTI_VISCO )
    ok = check_unknown( "materi_strain_plasti", YES, task );
  if ( data_number==GROUP_MATERI_PLASTI_VONMISES )
    ok = check_unknown( "materi_strain_plasti", YES, task );
  if ( data_number==GROUP_MATERI_STRAIN_PLASTI_FAILURE )
    ok = check_unknown( "materi_strain_plasti", YES, task );
  if ( data_number==GROUP_MATERI_STRAIN_TOTAL_FAILURE )
    ok = check_unknown( "materi_strain_total", YES, task );
  if ( data_number==GROUP_MATERI_PLASTI_COMPRESSION )
    ok = check_unknown( "materi_stress", YES, task );
  if ( data_number==GROUP_MATERI_PLASTI_DRUCKPRAG )
    ok = check_unknown( "materi_stress", YES, task );
  if ( data_number==GROUP_MATERI_PLASTI_GURSON ) {
    ok = check_unknown( "materi_stress", YES, task );
    ok = check_unknown( "materi_void_fraction", YES, task );
  }
  if ( data_number==GROUP_MATERI_PLASTI_KINEMATIC_HARDENING )
    ok = check_unknown( "materi_plasti_rho", YES, task );
  if ( data_number==GROUP_MATERI_PLASTI_MOHRCOUL )
    ok = check_unknown( "materi_stress", YES, task );
  if ( data_number==GROUP_MATERI_PLASTI_HEAT_GENERATION )
    ok = check_unknown( "condif_temperature", YES, task );
  if ( data_number==GROUP_MATERI_PLASTI_TENSION )
    ok = check_unknown( "materi_stress", YES, task );
  if ( data_number==GROUP_MATERI_PLASTI_VISCO )
    ok = check_unknown( "materi_stress", YES, task );
  if ( data_number==GROUP_MATERI_PLASTI_VONMISES )
    ok = check_unknown( "materi_stress", YES, task );
  if ( data_number==NODE_RHSIDE )
    ok = check_unknowns_are_specified( task );
  if ( data_number==GROUP_MATERI_STOKES )
    ok = check_unknown( "materi_velocity", YES, task );
  if ( data_number==GROUP_MATERI_VISCOSITY )
    ok = check_unknown( "materi_velocity", YES, task );
  if ( data_number==GROUP_TYPE )
    ok = check_unknowns_are_specified( task );
  if ( data_number==GROUP_USER_DATA )
    ok = check_unknown( "materi_strain_elasti", YES, task );
  if ( data_number==GROUP_USER_UMAT )
    ok = check_unknown( "materi_strain_elasti", YES, task );
  if ( data_number==GROUP_WAVE_SPEED_OF_SOUND ) {
    ok = check_unknown( "wave_scalar", YES, task );
    ok = ok && check_unknown( "wave_fscalar", YES, task );
  }
  if ( data_number==MATERI )
    ok = ok && check_unknown( "wave_scalar", NO, task );
  if ( data_number==MATERI_STRAIN_ELASTI )
    ok = check_unknown( "materi_strain_elasti", YES, task );
  if ( data_number==MATERI_STRAIN_PLASTI )
    ok = check_unknown( "materi_strain_plasti", YES, task );
  if ( data_number==MATERI_STRAIN_TOTAL )
    ok = check_unknown( "materi_strain_total", YES, task );
  if ( data_number==MATERI_STRESS )
    ok = check_unknown( "materi_stress", YES, task );
  if ( data_number==MATERI_VELOCITY )
    ok = check_unknown( "materi_velocity", YES, task );
  if ( data_number==NODE_DAMPING )
    ok = check_unknown( "materi_velocity", YES, task );
  if ( data_number==NODE_DOF )
    ok = check_unknowns_are_specified( task );
  if ( data_number==NODE_DOF_CALCUL )
    ok = check_unknowns_are_specified( task );
  if ( data_number==NODE_LOCATE ) {
    ok = check_unknown( "materi_velocity", YES, task );
    ok = ok && check_unknown( "materi_displacement", NO, task );
  }
  if ( data_number==NODE_MASS )
    ok = check_unknown( "materi_velocity", YES, task );
  if ( data_number==OPTIONS_AXISYMMETRIC ) 
    ok = check_ndim( 1, 2, task );
  if ( data_number==OPTIONS_RESIDUEFACTOR )
    ok = check_unknowns_are_specified( task );
  if ( data_number==POST_LINE )
    ok = check_unknowns_are_specified( task );
  if ( data_number==POST_LINE_N )
    ok = check_unknowns_are_specified( task );
  if ( data_number==POST_LINE_DOF )
    ok = check_unknowns_are_specified( task );
  if ( data_number==POST_POINT )
    ok = check_unknowns_are_specified( task );
  if ( data_number==POST_POINT_DOF )
    ok = check_unknowns_are_specified( task );
  if ( data_number==POST_QUADRILATERAL ) {
    ok = check_ndim( 2, 3, task );
    ok = ok && check_unknowns_are_specified( task );
  }
  if ( data_number==POST_QUADRILATERAL_N ) {
    ok = check_ndim( 2, 3, task );
    ok = ok && check_unknowns_are_specified( task );
  }
  if ( data_number==POST_QUADRILATERAL_DOF ) {
    ok = check_ndim( 2, 3, task  );
    ok = ok && check_unknowns_are_specified( task );
  }
  if ( data_number==RECTANGLE )
    ok = check_ndim( 2, 2, task );
  if ( data_number==SLIDE_GEOMETRY )
    ok = check_unknown( "materi_velocity", YES, task );
  if ( data_number==SLIDE_FRICTION )
    ok = check_unknown( "materi_velocity", YES, task );
  if ( data_number==TENDON_ELASTI ) {
    ok = check_unknown( "materi_stress", YES, task );
    ok = ok && check_unknown( "materi_velocity", YES, task );
  }
  if ( data_number==TENDON_EXPANSION ) {
    ok = check_unknown( "materi_stress", YES, task );
    ok = ok && check_unknown( "condif_temperature", YES, task );
  }
  if ( data_number==TENDON_PLASTI ) {
    ok = check_unknown( "materi_stress", YES, task );
    ok = ok && check_unknown( "materi_velocity", YES, task );
  }
  if ( data_number==TENDON_STRESS ) {
    ok = check_unknown( "materi_stress", YES, task );
    ok = ok && check_unknown( "materi_velocity", YES, task );
  }
  if ( data_number==TOTAL ) {
    ok = check_unknown( "materi_displacement", YES, task );
    ok = ok && check_unknown( "materi_velocity", YES, task );
    ok = ok && check_unknown( "materi_stress", YES, task );
    ok = ok && check_unknown( "materi_strain_total", YES, task );
  }
  if ( data_number==UPDATED ) {
    ok = check_unknown( "materi_velocity", YES, task );
    ok = ok && check_unknown( "materi_stress", YES, task );
  }
  if ( data_number==UPDATED_WITHOUT_ROTATION )
    ok = check_unknown( "materi_stress", YES, task );
  if ( data_number==VOLUME_ELEMENT_FACTOR )
    ok = check_ndim( 1, 2, task );
  if ( data_number==VOLUME_FACTOR )
    ok = check_ndim( 1, 2, task );
  if ( data_number==WAVE ) {
    ok = check_unknown( "wave_scalar", YES, task );
    ok = ok && check_unknown( "wave_fscalar", YES, task );
    ok = ok && check_unknown( "materi_velocity", NO, task );
  }

  return ok;
}


long int check_ndim( long int lower, long int higher, long int task ) 

{
  long int ok=1;

  if ( ndim<lower || ndim>higher ) {
    if ( task==CHECK_USAGE_AND_ERROR ) {
      pri( "\n\n Error: inconsistent with number_of_space_dimensions." );
      exit(TN_EXIT_STATUS);
    }
    else {
      assert( task==CHECK_USAGE );
      ok = 0;
    }
  }

  return ok;
}

long int check_unknown( char str[], long int initialization_needs_to_exist, 
  long int task ) 

{
  long int iinitia=0, initialization_exists=0, ok=1, ninitia=0;

  ninitia = db_len( INITIALIZATION_VALUES, 0, VERSION_NORMAL );

  for ( iinitia=0; iinitia<ninitia; iinitia++ ) {
    if ( !strcmp(str,initialization_names[iinitia]) ) 
      initialization_exists = 1;
  }

  if ( initialization_needs_to_exist==YES && !initialization_exists ) {
    if ( task==CHECK_USAGE_AND_ERROR ) {
      cout << "\n\nError: " << str << " should be initialized.\n";
      exit(TN_EXIT_STATUS);
    }
    else {
      assert( task==CHECK_USAGE );
      ok = 0;
    }
  }
  else if ( initialization_needs_to_exist==NO && initialization_exists ) {
    if ( task==CHECK_USAGE_AND_ERROR ) {
      cout << "\n\nError: " << str << " should not be initialized.\n";
      exit(TN_EXIT_STATUS);
    }
    else {
      assert( task==CHECK_USAGE );
      ok = 0;
    }
  }

  return ok;
}

long int check_unknown_minimum( char str[], long int min, long int task ) 

{
  long int ok=1, iinitia=0, ninitia=0, initialization_value=0,
    initialization_values[DATA_ITEM_SIZE];
  double ddum[1];

  db( INITIALIZATION_VALUES, 0, initialization_values, ddum, 
    ninitia, VERSION_NORMAL, GET );

  for ( iinitia=0; iinitia<ninitia; iinitia++ ) {
    if ( !strcmp(str,initialization_names[iinitia]) )
      initialization_value = initialization_values[iinitia];
  }

  if ( initialization_value<min ) {
    if ( task==CHECK_USAGE_AND_ERROR ) {
      cout << "\n\nError: " << str << " should be " << min << ".\n";
      exit(TN_EXIT_STATUS);
    }
    else {
      assert( task==CHECK_USAGE );
      ok = 0;
    }
  }

  return ok;
}


long int check_unknowns_are_specified( long int task )

{
  long int ok=1;

  if ( nuknwn==0 ) {
    if ( task==CHECK_USAGE_AND_ERROR ) {
      pri( "\n\nError: no unknowns (e.g. condif_temperature, ..) initialized");
      exit(TN_EXIT_STATUS);
    }
    else {
      assert( task==CHECK_USAGE );
      ok = 0;
    }
  }

  return ok;
}
