/*
   Copyright (C) 1998  Ulric Eriksson <ulric@edu.stockholm.se>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the Licence, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.
 */

#ifndef s_Richtext_h
#define s_Richtext_h

/****************************************************************
 *
 * Richtext widget
 *
 ****************************************************************/

/* Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 richtextData	     RichtextData		Pointer		NULL
 richtextExpose	     RichtextExpose	Pointer		NULL
 destroyCallback     Callback		Pointer		NULL
 height		     Height		Dimension	0
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 sensitive	     Sensitive		Boolean		True
 width		     Width		Dimension	0
 x		     Position		Position	0
 y		     Position		Position	0

*/

/* define any special resource names here that are not in <X11/StringDefs.h> */

#define XtNrichtextTopRow "richtextTopRow"
#define XtNrichtextTopCol "richtextTopCol"
#define XtNrichtextSelectTopRow "richtextSelectTopRow"
#define XtNrichtextSelectTopCol "richtextSelectTopCol"
#define XtNrichtextSelectBottomRow "richtextSelectBottomRow"
#define XtNrichtextSelectBottomCol "richtextSelectBottomCol"
#define XtNrichtextPointRow "richtextPointRow"
#define XtNrichtextPointCol "richtextPointCol"
#define XtNrichtextRowHeight "richtextRowHeight"
#define XtNrichtextAdjHoriz "richtextAdjHoriz"
#define XtNrichtextStyle "richtextStyle"
#define XtNrichtextText "richtextText"
#define XtNrichtextData "richtextData"
#define XtNrichtextRedisplay "richtextRedisplay"
#define XtNrichtextVisibleCursor "richtextVisibleCursor"
#define XtNrichtextPaperWidth "richtextPaperWidth"
#define XtNrichtextLeftMargin "richtextLeftMargin"
#define XtNrichtextRightMargin "richtextRightMargin"
#define XtNrichtextPluginCoords "richtextPluginCoords"

#define XtCRichtextTopRow "RichtextTopRow"
#define XtCRichtextTopCol "RichtextTopCol"
#define XtCRichtextSelectTopRow "RichtextSelectTopRow"
#define XtCRichtextSelectTopCol "RichtextSelectTopCol"
#define XtCRichtextSelectBottomRow "RichtextSelectBottomRow"
#define XtCRichtextSelectBottomCol "RichtextSelectBottomCol"
#define XtCRichtextPointRow "RichtextPointRow"
#define XtCRichtextPointCol "RichtextPointCol"
#define XtCRichtextRowHeight "RichtextRowHeight"
#define XtCRichtextAdjHoriz "RichtextAdjHoriz"
#define XtCRichtextStyle "RichtextStyle"
#define XtCRichtextText "RichtextText"
#define XtCRichtextData "RichtextData"
#define XtCRichtextRedisplay "RichtextRedisplay"
#define XtCRichtextVisibleCursor "RichtextVisibleCursor"
#define XtCRichtextPaperWidth "RichtextPaperWidth"
#define XtCRichtextLeftMargin "RichtextLeftMargin"
#define XtCRichtextRightMargin "RichtextRightMargin"
#define XtCRichtextPluginCoords "RichtextPluginCoords"

/* declare specific RichtextWidget class and instance datatypes */

typedef struct s_RichtextClassRec*	RichtextWidgetClass;
typedef struct s_RichtextRec*		RichtextWidget;

/* declare the class constant */

extern WidgetClass richtextWidgetClass;

/* a few functions */
extern void rt_pr_line(Widget, int);

#endif /* s_Richtext_h */

