;;
;; Set up the menu
;;
(add-menu-entry "File" "New" "(new-pw)")
(add-menu-entry "File" "Open" "(load-buffer)")
(add-menu-entry "File" "Save" "(save-buffer)")
(add-menu-entry "File" "Save As" "(save-buffer-as)")
(add-menu-entry "File" "Preview" "(preview)")
(add-menu-entry "File" "Print" "(print)")
(add-menu-entry "File" "-" "-")
(add-menu-entry "File" "Load External" "(load-external)")
(add-menu-entry "File" "Save External" "(save-external)")
(add-menu-entry "File" "-" "-")
(add-menu-entry "File" "Exit" "(quit-pw)")

(add-menu-entry "Edit" "Delete" "(delete-char)")
(add-menu-entry "Edit" "Insert Line" "(insert-line)")
(add-menu-entry "Edit" "Remove Line" "(remove-line)")
(add-menu-entry "Edit" "Select All" "(select-all)")
(add-menu-entry "Edit" "-" "-")
(add-menu-entry "Edit" "Find" "(search-forward)")
(add-menu-entry "Edit" "Find Backward" "(search-backward)")
(add-menu-entry "Edit" "Replace" "(query-replace)")
(add-menu-entry "Edit" "Spell" "(spell-buffer)")
; Deprecated
;(add-menu-entry "Edit" "-" "-")
;(add-menu-entry "Edit" "Embed Object" "(embed-object)")
;(add-menu-entry "Edit" "Remove Object" "(embed-remove)")
;(add-menu-entry "Edit" "Open Object" "(embed-open)")
;(add-menu-entry "Edit" "Save Object" "(embed-save)")

(add-menu-entry "Block" "Set Block" "(set-block)")
(add-menu-entry "Block" "Set Mark" "(set-mark-command)")
(add-menu-entry "Block" "Copy Block" "(copy-block)")
(add-menu-entry "Block" "Delete Block" "(delete-block)")
(add-menu-entry "Block" "Fill Block" "(fill-block)")

(add-menu-entry "Format" "Line Height" "(set-line-height)")
(add-menu-entry "Format" "Segment Format" "(set-segment-format)")
(add-menu-entry "Format" "Line Format" "(set-line-format)")
(add-menu-entry "Format" "-" "-")
(add-menu-entry "Format" "Copy" "(copy-current-format)")
(add-menu-entry "Format" "Use" "(use-copied-format)")
(add-menu-entry "Format" "Define Style" "(define-style)")
(add-menu-entry "Format" "Cleanup" "(cleanup-style)")

(add-menu-entry "Window" "Change Buffer" "(switch-to-buffer)")
(add-menu-entry "Window" "Delete Buffer" "(kill-buffer)")
(add-menu-entry "Window" "-" "-")
(add-menu-entry "Window" "Split Window" "(split-window-vertically)")
(add-menu-entry "Window" "Remove Window" "(delete-window)")
(add-menu-entry "Window" "One Window" "(delete-other-windows)")
(add-menu-entry "Window" "Change Window" "(other-window)")
(add-menu-entry "Window" "-" "-")
(add-submenu "Window" "Go To")
(add-submenu-entry "Window" "Go To" "Beginning of buffer" "(beginning-of-buffer)")
(add-submenu-entry "Window" "Go To" "End of buffer" "(end-of-buffer)")

(define (tooltip-set m)
  (set! *tooltip-mode* m)
  (tooltip-mode m))
(add-submenu "Window" "Helptexts")
(add-submenu-entry "Window" "Helptexts" "Disable" "(tooltip-set 0)")
(add-submenu-entry "Window" "Helptexts" "Label" "(tooltip-set 1)")
(add-submenu-entry "Window" "Helptexts" "Popup" "(tooltip-set 2)")
(add-submenu-entry "Window" "Helptexts" "Both" "(tooltip-set 3)")

(add-menu-entry "Window" "Save Preferences" "(save-preferences)")

(add-menu-entry "Help" "Contents" "(help-contents)")
(add-menu-entry "Help" "Search" "(help-search)")
(add-menu-entry "Help" "Copying" "(help-copyright)")
(add-menu-entry "Help" "Help for Help" "(help-for-help)")
(add-menu-entry "Help" "-" "-")
(add-menu-entry "Help" "About Pathetic Writer" "(print-version)")

(add-submenu "Tools" "Command")
(add-submenu-entry "Tools" "Command" "SIOD" "(exec-siod)")
(add-submenu-entry "Tools" "Command" "Tcl" "(exec-tcl)")
(add-submenu-entry "Tools" "Command" "Guile" "(exec-guile)")

(add-menu-entry "Tools" "-" "-")
(require (string-append SIAGHOME "/common/tools.scm"))
(add-menu-entry "Tools" "-" "-")
(add-menu-entry "Tools" "Spell Test" "(spell-test)")
(add-menu-entry "Tools" "Dump Words" "(dump-words)")
(add-menu-entry "Tools" "-" "-")
(add-submenu "Tools" "Form Test")
(add-submenu-entry "Tools" "Form Test" "Test 1" "(form-test)")
(add-submenu-entry "Tools" "Form Test" "Test 2" "(form-test2)")
(add-submenu-entry "Tools" "Form Test" "Test 3" "(form-test3)")

(add-menu-entry "Plugin" "Import" "(plugin-import nil)")
(add-menu-entry "Plugin" "Export" "(plugin-export)")
(add-menu-entry "Plugin" "Link" "(plugin-link nil)")
(add-menu-entry "Plugin" "Delete" "(plugin-delete)")
(add-menu-entry "Plugin" "Move" "(plugin-move)")
(add-submenu "Plugin" "App")
(add-submenu-entry "Plugin" "App" "Xclock" "(plugin-import \"xclock.run\")")
(add-submenu-entry "Plugin" "App" "Xterm" "(plugin-import \"xterm.run\")")
(add-submenu-entry "Plugin" "App" "Xload" "(plugin-import \"xload.run\")")
(add-submenu-entry "Plugin" "App" "Siag" "(plugin-import \"PlUgIn.siag\")")
(add-submenu-entry "Plugin" "App" "PW" "(plugin-import \"PlUgIn.pw\")")
(add-submenu-entry "Plugin" "App" "Hello World" "(plugin-import \"x.hello\")")

(add-menu-entry "Shortcuts" "Open" "(load-buffer)")
(add-menu-entry "Shortcuts" "Save" "(save-buffer-as)")
(add-menu-entry "Shortcuts" "-" "-")
(add-menu-entry "Shortcuts" "Undo" "(undo-restore)")
(add-menu-entry "Shortcuts" "Spell" "(spell-buffer)")
(add-menu-entry "Shortcuts" "Command" "(exec-siod)")
(add-menu-entry "Shortcuts" "-" "-")
(add-submenu "Shortcuts" "Plugin")
(add-submenu-entry "Shortcuts" "Plugin" "Import" "(plugin-import)")
(add-submenu-entry "Shortcuts" "Plugin" "Export" "(plugin-export)")
(add-submenu-entry "Shortcuts" "Plugin" "Link" "(plugin-link)")
(add-submenu-entry "Shortcuts" "Plugin" "Delete" "(plugin-delete)")
(add-submenu-entry "Shortcuts" "Plugin" "Move" "(plugin-move)")
(add-menu-entry "Shortcuts" "Help" "(help-contents)")
(add-menu-entry "Shortcuts" "-" "-")
(add-menu-entry "Shortcuts" "Quit" "(quit-pw)")

