#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <signal.h>
#include <sys/wait.h>
#include "cmalloc.h"

/* Case insensitive compare */
int cstrcasecmp(const char *p, const char *q)
{
	int c;

	while (!(c = toupper(*p)-toupper(*q)) && *p) {
		p++;
		q++;
	}
	return c;
}

/* Case insensitive compare, length limited */
int cstrncasecmp(const char *p, const char *q, size_t n)
{
	size_t i = 0;
	int c = 0;

	while ((i < n) && !(c = toupper(*p)-toupper(*q)) && *p) {
		p++;
		q++;
		i++;
	}
	return c;
}

/* delete all temp directories whose processes are no longer around */
void stale_dirs(char *dn)
{
}

/* a little bookkeeping to keep track of temp files and make sure they
   are deleted when child processes terminate */

static int ndeletia;
static struct {
	long p;
	char *fn;
} *deletia;

/* associate a temp file with a process */
void deletia_add(long p, char *fn)
{
	int i;

	for (i = 0; i < ndeletia; i++)
		if (deletia[i].fn == NULL) break;
	if (i == ndeletia) {
		ndeletia++;
		deletia = crealloc(deletia, ndeletia*sizeof *deletia);
	}
	deletia[i].p = p;
	deletia[i].fn = cstrdup(fn);
}

/* mark all files related to a process to be deleted later */
/* p == 0 marks *all* files */
void deletia_mark(long p)
{
	int i;

	for (i = 0; i < ndeletia; i++) {
		if (p == 0 || p == deletia[i].p)
			deletia[i].p = 0;
	}
}

/* remove files that have previously been marked */
void deletia_reap(void)
{
	int i;

	for (i = 0; i < ndeletia; i++) {
		if (deletia[i].p == 0 && deletia[i].fn) {
			remove(deletia[i].fn);
			cfree(deletia[i].fn);
			deletia[i].fn = NULL;
		}
	}
}

void waitforchild(int i)
{
	pid_t p;
	long lp;

	p = waitpid(-1, NULL, WNOHANG);
	lp = (long)p;
	if (p > 0) deletia_mark(lp);
	signal(SIGCHLD, waitforchild);
}

static struct {
	char *key, *xl;
} *dict = NULL;

static long nw = 0;

static void chomp(char *p)
{
        if ((p = strchr(p, '\n'))) *p = '\0';
}

void load_dictionary(char *fn)
{
        FILE *fp = fopen(fn, "r");
        char b[1024], *p;

        if (!fp) {
                fprintf(stderr, "Can't open dictionary\n");
                return;
        }
        while (fgets(b, sizeof b, fp)) {
                chomp(b);
                p = strchr(b, '\t');
                if (!p) continue;
                *p++ = 0;
                p += strspn(p, "\t");
                dict = realloc(dict, (nw+1)*(sizeof dict[0]));
                dict[nw].key = cstrdup(b);
                dict[nw++].xl = cstrdup(p);
        }
}

void dummy_fun(void)
{
	;
}

char *translate(char *key)
{
        long i;

        for (i = 0; i < nw; i++)
                if (!strcmp(key, dict[i].key)) {
			return dict[i].xl;
		}
        return key;
}


