#include "Mathlib.h"
#ifdef HAVE_ISNAN
double R_Zero_Hack = 0.0;		/* silence the compiler */
#endif


double	R_tmp;				/* Temporary Value */
double	R_NaN;				/* NaN or -DBL_MAX */
double	R_PosInf;			/* IEEE Inf or DBL_MAX */
double	R_NegInf;			/* IEEE -Inf or -DBL_MAX */
int	R_NaInt;			/* NA_INTEGER */
double	R_NaReal;			/* NA_REAL */

double (* uniform_deviate)();
void set_random_generator (double (*function)()) {
  uniform_deviate = function;
}
void InitArithmetic()
{ 
	R_NaInt = INT_MIN;

#ifdef HAVE_ISNAN
	R_NaN = 0.0/1.0;
	R_NaReal = R_NaN;
	R_PosInf = 1.0/R_Zero_Hack;
	R_NegInf = -1.0/R_Zero_Hack;
#else
	R_NaN = -DBL_MAX;
	R_NaReal = R_NaN;
	R_PosInf = -DBL_MAX;
	R_NegInf = DBL_MAX;

#ifdef Unix
	signal(SIGFPE, handle_fperror);
#endif
#endif
}

			/* Arithmetic Values */

