#include <math.h>
#include <stddef.h>

extern double	R_NaN;			/* IEEE NaN or -DBL_MAX */

#define FUNC(x) ((*func)(x))

void polint(double xa[], double ya[], int n, double x, double *y,
	    double *dy, int *err);

static int nn;
static double alphai, yi, setai, cetai;

static double func1(double s){
  double sa;
  sa=pow(s,alphai);
  return(cos(-yi*s+sa*setai)*exp(-sa*cetai));}

static double func2(double s){
  double sa;
  sa=pow(s,-alphai);
  return(cos(-yi/s+sa*setai)*exp(-sa*cetai))/(s*s);}

static double midpnt(double (*func)(double), int n)
/* Press et al. p.142 */
{
  double x, tnm, sum, del, ddel;
  static double s;
  int it,j;

  if (n==1)return(s=FUNC(0.5));
  else {
    for(it=1,j=1;j<n-1;j++) it*=3;
    tnm=it;
    del=1/(3.0*tnm);
    ddel=del+del;
    x=0.5*del;
    sum=0.0;
    for(j=1;j<=it;j++){
      sum+=FUNC(x);
      x+=ddel;
      sum+=FUNC(x);
      x+=del;}
    s=(s+sum/tnm)/3.0;
    return(s);}}

#define JMAX 16
#define JMAXP (JMAX+1)

static double qromo(double (*func)(double), double eps)
/* Press et al. p.143 */
{
  int j, err;
  double ss,dss,h[JMAXP+1],s[JMAXP+1];

  err=0;
  h[1]=1.0;
  for(j=1;j<=JMAX;j++){
    s[j]=midpnt(func,j);
    if(j>=5){
      polint(&h[j-5],&s[j-5],5,0.0,&ss,&dss,&err);
      if(fabs(dss)<eps*fabs(ss))return(ss);}
    s[j+1]=s[j];
    h[j+1]=h[j]/9.0;}
  return(R_NaN);}

void stable(int *n, double *y, double *beta, double *alpha, int *npt, double *up, double *eps, int *type, int *err, double *ffy)
{
  int i, j;
  double h, s, *eta, *seta, *ceta, *sa;
  *err=0;
  eta=(double*)malloc((size_t)((*n+1)*sizeof(double)));
  seta=(double*)malloc((size_t)((*n+1)*sizeof(double)));
  ceta=(double*)malloc((size_t)((*n+1)*sizeof(double)));
  sa=(double*)malloc((size_t)((*n+1)*sizeof(double)));
  nn=*n;
  if(!eta||!seta||!ceta||!sa){
    *err=1;
    return;}
  for(i=0;i<*n;i++){
    ffy[i]=0.0;
    eta[i]=beta[i]*(1.0-fabs(1.0-alpha[i]))*M_PI/2.0;
    seta[i]=sin(eta[i]);
    ceta[i]=cos(eta[i]);}
  if(*type==1){
    *npt=*npt-*npt%2;
    h=*up/ *npt;
	   for(j=0;j<=*npt;j++){
	     s=(*npt-j)*h;
	     for(i=0;i<*n;i++){
	       sa[i]=pow(s,alpha[i]);
	       ffy[i]=ffy[i]+(4-2*(j%2==0)-(j==1||j==*npt))*cos(-y[i]*s+sa[i]*seta[i])*exp(-sa[i]*ceta[i]);}}
	   for(i=0;i<*n;i++)ffy[i]=ffy[i]*h/3.0/M_PI;}
  else {
    for(i=0;i<*n;i++){
      alphai=alpha[i];
      yi=y[i];
      setai=seta[i];
      cetai=ceta[i];
      ffy[i]=qromo(func1, *eps)+qromo(func2, *eps);}
    for(i=0;i<*n;i++)ffy[i]=ffy[i]/M_PI;}
  free((char *)sa);
  free((char *)ceta);
  free((char *)seta);
  free((char *)eta);}
