#include <math.h>
#include <stddef.h>

extern double	R_NaN;			/* IEEE NaN or -DBL_MAX */

#define FUNC(x) ((*func)(x))

void polint(double xa[], double ya[], int n, double x, double *y,
	    double *dy, int *err);

static int nn;
static double alphai, etai, setai, cetai, yyi;

static double func1(double s){
  double sa;
  sa=pow(s,alphai);
  return((sin(yyi*s-sa*setai)/s)*exp(-sa*cetai));}

static double func2(double s){
  double sa;
  sa=pow(s,-alphai);
  return((sin(yyi/s-sa*setai)*s)*exp(-sa*cetai))/(s*s);}

static double midpnt(double (*func)(double), int n)
/* Press et al. p.142 */
{
  double x, tnm, sum, del, ddel;
  static double s;
  int it,j;

  if (n==1)return(s=FUNC(0.5));
  else {
    for(it=1,j=1;j<n-1;j++) it*=3;
    tnm=it;
    del=1/(3.0*tnm);
    ddel=del+del;
    x=0.5*del;
    sum=0.0;
    for(j=1;j<=it;j++){
      sum+=FUNC(x);
      x+=ddel;
      sum+=FUNC(x);
      x+=del;}
    s=(s+sum/tnm)/3.0;
    return(s);}}

#define JMAX 16
#define JMAXP (JMAX+1)

static double qromo(double (*func)(double), double eps)
/* Press et al. p.143 */
{
  int j, err;
  double ss,dss,h[JMAXP+1],s[JMAXP+1];

  err=0;
  h[1]=1.0;
  for(j=1;j<=JMAX;j++){
    s[j]=midpnt(func,j);
    if(j>=5){
      polint(&h[j-5],&s[j-5],5,0.0,&ss,&dss,&err);
      if(fabs(dss)<eps*fabs(ss))return(ss);}
    s[j+1]=s[j];
    h[j+1]=h[j]/9.0;}
  return(R_NaN);}

void pstable(int *n, double *y, double *beta, double *alpha, double *eps, int *err, double *ffy)
{
  int i, j;
  double h, s;
  *err=0;
  nn=*n;
  for(i=0;i<*n;i++){
    ffy[i]=0.0;
    etai=beta[i]*(1.0-fabs(1.0-alpha[i]))*M_PI/2.0;
    setai=sin(etai);
    cetai=cos(etai);
    alphai=alpha[i];
    yyi=y[i];
    if(etai==0.&&yyi==0)
      ffy[i]=0.5;
    else {
      ffy[i]=qromo(func1, *eps)+qromo(func2, *eps);
      ffy[i]=0.5+ffy[i]/M_PI;}}}

