\name{autocorr}
\title{Autocorrelation function for Markov chains}

\usage{autocorr(mcmc.obj, lags = c(1, 5, 10, 50) * thin(x)}

\description{
\code{autocorr} calculates the autocorrelation function for the
Markov chain \code{mcmc.obj} at the lags given by \code{lags}.
The lag values are \emph{absolute}, not relative to the thinning
interval, so they should be a multiple of thin(x).

High autocorrelations within chains indicate slow mixing and, usually,
slow convergence. It may be useful to thin out a chain with high
autocorrelations before calculating summary statistics: a thinned
chain may contain most of the information, but take up less space in
memory. Re-running the MCMC sampler with a different parameterization
may help to reduce autocorrelation.
}

\value{
A matrix or array containing the autocorrelations.
}

\author{Martyn Plummer}

\seealso{
\code{\link{acf}}, \code{\link{autocorr.plot}}}
}
