"set.mfrow" <-
function (Nchains = 1, Nparms = 1, nplots = 1, sepplot = F, one.page = F) 
{
        #  
        # Set up dimensions of graphics window: 
        # If only density plots OR trace plots are requested, dimensions are: 
        #	1 x 1	if Nparms = 1 
        #	1 X 2 	if Nparms = 2 
        #	2 X 2 	if Nparms = 3 or 4 
        #	3 X 2 	if Nparms = 5 or 6 or 10 - 12 
        #	3 X 3 	if Nparms = 7 - 9 or >= 13 
        # If both density plots AND trace plots are requested, dimensions are: 
        #	1 x 2	if Nparms = 1 
        #	2 X 2 	if Nparms = 2 
        #	3 X 2 	if Nparms = 3, 5, 6, 10, 11, or 12 
        #	4 x 2	if Nparms otherwise 
        # If separate plots are requested for each chain, dimensions are: 
        #	1 x 2	if Nparms = 1 & Nchains = 2 
        #	2 X 2 	if Nparms = 2 & Nchains = 2 OR Nparms = 1 & Nchains = 3 or 4 
        #	3 x 2	if Nparms = 3 or >= 5 & Nchains = 2  
        #		   OR Nchains = 5 or 6 or 10 - 12 (and any Nparms) 
        #	2 x 3	if Nparms = 2 or 4 & Nchains = 3 
        #	4 x 2   if Nparms = 4 & Nchains = 2  
        #		   OR Nchains = 4 & Nparms > 1 
        #	3 x 3	if Nparms = 3 or >= 5  & Nchains = 3  
        #		   OR Nchains = 7 - 9 or >= 13 (and any Nparms) 
        # If more plots are required than will fit on one page, the 
        # browser function is used to cycle round multiple pages of plots 
        #  
        if (one.page) 
                Nparms <- 1
        if (sepplot && Nchains > 1) {
                if (nplots == 1) {
                        mrows <- ifelse((Nparms == 1 && Nchains == 
                                2), 1, ifelse((Nparms == 2 && 
                                Nchains == 2) || (Nparms == 1 && 
                                any(Nchains == c(3, 4))) || (any(Nparms == 
                                c(2, 4)) && Nchains == 3), 2, 
                                ifelse((Nparms == 4 && Nchains == 
                                 2) || (Nchains == 4 && Nparms > 
                                 1), 4, 3)))
                        mcols <- ifelse((Nchains == 3 && any(Nparms == 
                                c(2, 4))) || ((Nparms == 3 || 
                                Nparms >= 5) && Nchains == 3) || 
                                any(Nchains == c(7:9)) || Nchains >= 
                                13, 3, 2)
                }
                else {
                        mrows <- ifelse(Nchains <= 4, Nchains, 
                                ifelse(any(Nchains == c(5, 6, 
                                 10:12)), 3, 4))
                        mcols <- 2
                }
        }
        else {
                if (nplots == 1) {
                        mrows <- ifelse(Nparms <= 2, 1, ifelse(Nparms <= 
                                4, 2, 3))
                        mcols <- ifelse(Nparms <= 9, Nparms%/%mrows + 
                                ifelse(Nparms%%mrows == 0, 0, 
                                 1), ifelse(any(Nparms == c(10:12)), 
                                2, 3))
                }
                else {
                        mrows <- ifelse(Nparms <= 4, Nparms, 
                                ifelse(any(Nparms == c(5, 6, 
                                 10:12)), 3, 4))
                        mcols <- 2
                }
        }
        return(mfrow = c(mrows, mcols))
}
