"read.bugs.interactive" <-
function () 
{
        #Interactively read BUGS output 
        # 
        cat("\nEnter problem title, followed by return key:\n")
        mtitle <- scan(what = character(), sep = "\n", nmax = 1, 
                strip.white = T, quiet = T)
        cat("Enter BUGS output filenames, separated by return key\n")
        cat("(Leave blank and hit return to exit):\n")
        filenames <- scan(what = character(), sep = "\n", strip.white = T, 
                quiet = T)
        if (length(filenames) == 0) {
                warning("No file name given")
                cat("Using default name \"bugs\"\n")
                filenames <- "bugs"
        }
        nfiles <- length(filenames)
        chains <- vector("list", nfiles)
        names(chains) <- filenames
        tspar.mat <- matrix(NA, nrow = nfiles, ncol = 3)
        niters <- vector("numeric", length = nfiles)
        allnames <- character(0)
        for (i in 1:nfiles) {
                chains[[i]] <- read.bugs(file = filenames[i])
                tspar.mat[i, ] <- tspar(chains[[i]])
                niters[i] <- nrow(chains[[i]])
                allnames <- unique(c(allnames, colnames(chains[[i]])))
        }
        if (any(tspar.mat[, 2] != tspar.mat[1, 2])) 
                stop("Chains have different thinning intervals\nYou cannot combine them")
        if (nfiles > 1) {
                parm.OK <- rep(F, length(allnames))
                for (i in 1:length(allnames)) for (j in 1:nfiles) {
                        parm.OK[i] <- any(colnames(chains[[j]]) == 
                                allnames[i])
                        if (!parm.OK[i]) 
                                break
                }
                if (all(parm.OK == F)) {
                        cat("\n******* Warning: *******\nThere are no variables common to all chains\nOnly first \nchain (", 
                                filenames[1], ".out) will be used\n", 
                                sep = "")
                        chains <- chains[[1]]
                        filenames <- filenames[1]
                        nfiles <- 1
                }
                else if (any(parm.OK == F)) {
                        warning(paste("Only variable(s) ", paste(allnames[parm.OK], 
                                sep = ", "), " are common to all chains"))
                        cat("All others will be deleted\n")
                }
                for (i in 1:nfiles) {
                        chains[[i]] <- chains[[i]][, allnames[parm.OK], 
                                ]
                }
                if (!all(niters == niters[1])) {
                        warning("Chains are of different lengths\n")
                        cat("Truncating each to last", min(niters), 
                                "iterations\n")
                        for (i in 1:nfiles) {
                                chains[[i]] <- chains[[i]][(niters[i] - 
                                 min(niters) + 1):niters[i], 
                                 , ]
                        }
                }
                if (!all(tspar.mat[, 1] == tspar.mat[1, 1])) {
                        cat("\n******* Warning:  *******\nChains start at different iteration numbers\nAll plots will \nbe labelled by iteration numbers for first chain (", 
                                filenames[1], ")\n", sep = "")
                }
        }
        y <- join.mcmc(chains)
        attr(y, "title") <- mtitle
        return(y)
}
