"read.bugs" <-
function (file = "bugs.out", start, end, thin) 
{
        #Based on readdat by Karen Vines 
        #Index object not required  
        #We don't remove missing values - each row of the output should 
        #contain at least one non-missing value. 
        #We return an mcmc object, if possible 
        # 
        nc <- nchar(file)
        if (nc > 3 && substring(file, nc - 3, nc) == ".out") 
                root <- substring(file, 1, nc - 4)
        else root <- file
        index <- read.table(file = paste(root, ".ind", sep = ""), 
                row.names = 1, col.names = c("", "begin", "end"))
        vnames <- row.names(index)
        # 
        temp <- scan(file = paste(root, ".out", sep = ""), what = list(iter = 0, 
                val = 0), quiet = T)
        # Do one pass through the data to see if we can construct 
        # a regular time series easily 
        # 
        start.vec <- end.vec <- thin.vec <- numeric(nrow(index))
        for (i in 1:length(vnames)) {
                iter.i <- temp$iter[index[i, "begin"]:index[i, 
                        "end"]]
                thin.i <- unique(diff(iter.i))
                thin.vec[i] <- if (length(thin.i) == 1) 
                        thin.i
                else NA
                start.vec[i] <- iter.i[1]
                end.vec[i] <- iter.i[length(iter.i)]
        }
        if (any(is.na(start.vec)) || any(thin.vec != thin.vec[1]) || 
                any((start.vec - start.vec[1])%%thin.vec[1] != 
                        0)) {
                # 
                # Do it the brute force way 
                # 
                iter <- sort(unique(temp$iter))
                old.thin <- unique(diff(iter))
                if (length(old.thin) == 1) 
                        is.regular <- TRUE
                else {
                        if (all(old.thin%%min(old.thin) == 0)) 
                                old.thin <- min(old.thin)
                        else old.thin <- 1
                        is.regular <- FALSE
                }
        }
        else {
                iter <- seq(from = min(start.vec), to = max(end.vec), 
                        by = thin.vec[1])
                old.thin <- thin.vec[1]
                is.regular <- TRUE
        }
        if (missing(start)) 
                start <- min(start.vec)
        else if (start < min(start.vec)) {
                warning("start not changed")
                start <- min(start.vec)
        }
        else if (start > max(end.vec)) 
                stop("Start after end of data")
        else iter <- iter[iter >= start]
        if (missing(end)) 
                end <- max(end.vec)
        else if (end > max(end.vec)) {
                warning("end not changed")
                end <- max(end.vec)
        }
        else if (end < min(start.vec)) 
                stop("End before start of data")
        else iter <- iter[iter <= end]
        if (missing(thin)) 
                thin <- old.thin
        else if (thin%%old.thin != 0) {
                thin <- old.thin
                warning("thin not changed")
        }
        else {
                new.iter <- iter[(iter - start)%%thin == 0]
                new.thin <- unique(diff(new.iter))
                if (length(new.thin) != 1 || new.thin != thin) 
                        warning("thin not changed")
                else {
                        iter <- new.iter
                        end <- max(iter)
                        is.regular <- TRUE
                }
        }
        out <- matrix(NA, nrow = length(iter), ncol = nrow(index))
        dimnames(out) <- list(iter, vnames)
        for (v in vnames) {
                cat("Abstracting", v, "... ")
                inset <- index[v, "begin"]:index[v, "end"]
                iter.v <- temp$iter[inset]
                if (!is.regular) {
                        use.v <- duplicated(c(iter, iter.v))[-(1:length(iter))]
                        use <- duplicated(c(iter.v, iter))[-(1:length(iter.v))]
                }
                else {
                        use.v <- (iter.v - start)%%thin == 0 & 
                                iter.v >= start & iter.v <= end
                        use <- (iter.v[use.v] - start)%/%thin + 
                                1
                }
                if (any(use) & any(use.v)) 
                        out[use, v] <- temp$val[inset[use.v]]
                cat(length(use), "valid values\n")
        }
        if (is.regular) {
                out <- mcmc(out, start = start, end = end, thin = thin)
                dimnames(out)[3] <- file
        }
        else warning("not returning an mcmc object")
        return(out)
}
