"geweke.diag" <-
function (x, frac1 = 0.1, frac2 = 0.5) 
{
        xstart <- c(start(x), end(x) - frac2 * (end(x) - start(x)))
        xend <- c(start(x) + frac1 * (end(x) - start(x)), end(x))
        y.vom <- y.mean <- array(dim = c(2, nvar(x), nchain(x)), 
                dimnames = list(NULL, varnames(x), chanames(x)))
        for (i in 1:2) {
                y <- window(x, start = xstart[i], end = xend[i])
                y.mean[i, , ] <- apply(y, c(2, 3), mean)
                spans <- min(sqrt(niter(y))/0.3 + 1, niter(y) - 
                        1)
                for (j in 1:nvar(x)) for (k in 1:nchain(x)) {
                        spec0 <- spec.pgram(y[, j, k], spans = spans, 
                                demean = T, detrend = F, plot = F)$spec[1]
                        y.vom[i, j, k] <- 10^(spec0/10)/niter(y)
                }
        }
        z <- (y.mean[1, , ] - y.mean[2, , ])/sqrt(y.vom[1, , 
                ] + y.vom[2, , ])
        out <- list(z = z, frac = c(frac1, frac2))
        class(out) <- "geweke.diag"
        return(out)
}
