"gelman.trace.plot" <-
function (x, auto.layout = T) 
{
        # 
        # gandr.trace.plot -- function for plotting multiple chains on
        # same graph and printing Gelman & Rubin's convergence diagnostic
        # for each variable.
        # 
        # Author: Nicky Best 
        # 
        oldpar <- NULL
        if (auto.layout) 
                oldpar <- par(mfrow = set.mfrow(Nchains = nchain(x), 
                        Nparms = nvar(x)))
        oldpar <- c(oldpar, par(set.scale()))
        on.exit(par(oldpar))
        title.scale <- par("cex") * switch(coda.options("ps.plot"), 
                0.8, 0.7, 0.65)
        scale <- par("cex") * switch(coda.options("ps.plot"), 
                1, 0.8, 0.6)
        for (i in 1:nvar(x)) {
                r <- x[, i, , drop = F]
                lim <- range(pretty(c(min(r), max(r))))
                plot.default(time(x), r[, , 1], type = "l", ylim = lim, 
                        xlab = "Iteration", ylab = colnames(r), 
                        cex = scale, axes = F)
                axis(1, at = pretty(time(x), 3), cex = scale, 
                        labels = format(pretty(time(x), 3)))
                par(crt = 90, srt = 90)
                axis(2, at = pretty(c(min(r), max(r)), 2), cex = scale, 
                        labels = format(pretty(c(min(r), max(r)), 
                                2)))
                par(crt = 0, srt = 0)
                box()
                for (j in 2:(dim(x)[3])) {
                        lines(r[, , j], lty = j, col = j)
                }
                shrink <- gelman.diag(r)$confshrink
                title(main = paste("Median =", format(round(shrink[1], 
                        2)), ",", "97.5% =", format(round(shrink[2], 
                        2))), cex = title.scale)
                if (i != nvar(x) && mpause2()) 
                        break
        }
}
