"crosscorr" <-
function (x, combine.chains = F) 
{
        x <- as.mcmc(x)
        Nvars <- dim(x)[2]
        Nchains <- dim(x)[3]
        if (combine.chains & Nchains > 1) 
                y <- cor(matrix(aperm(x, c(2, 1, 3)), ncol = nvar(x), 
                        byrow = T))
        else {
                y <- array(apply(x, 3, cor), dim = c(Nvars, Nvars, 
                        Nchains))
                dimnames(y)[[3]] <- dimnames(x)[[3]]
        }
        dimnames(y)[1:2] <- list(dimnames(x)[[2]], dimnames(x)[[2]])
        y <- drop(y)
        return(y)
}
