"codamenu.options.stats" <-
function () 
{
        #
        # codamenu.options.stats -- Summary statistics options menu for CODA system
        #
        # Author: Nicky Best
        #
        #
        # Check that quantiles are between 0 and 1
        #
        next.menu <- "codamenu.options.stats"
        cat("\nCODA Summary Statistics Defaults Menu \n*************************************\n")
        choices <- c("Display current statistics options", "Combine chains for summary statistics", 
                "Quantiles for summary statistics", 
                "Number of significant digits for printing", 
                "Return to main options menu")
        pick <- menu(choices)
        if (pick == 0) 
                return("quit")
        switch(pick, print.coda.options(stats = T), {
                mssg <- "Do you want to combine all chains when calculating summary statistics"
                change.tfoption(mssg, "combine.stats")
        }, {
                mssg <- paste("Enter quantiles required, separated by commas\n(Default =", paste(coda.options("quantiles"), collapse=", "))
                repeat {
                        cat("\n", mssg, "\n")
                        ans <- as.numeric(scan(what = character(), 
                                sep = ",", quiet = T, nlines = 1))
                        if (any(is.na(ans))) 
                                mssg <- "You must enter numeric values"
                        else if (any(ans >= 1) || any(ans <= 
                                0)) 
                                mssg <- "You must enter values between 0 and 1"
                        else break
                }
                if (length(ans) > 0) 
                        coda.options(quantiles = sort(ans))
        }, {
                mssg <- "Enter number of significant digits to be printed"
                ans <- read.and.check(mssg, what = integer(), 
                        lower = 0, default=coda.options("digits"))
                coda.options(digits = ans)
        }, {
                next.menu <- "codamenu.options"
        })
        return(next.menu)
}
