"codamenu.options.plot.kernel" <-
function () 
{
        if (!coda.options("densplot")) {
                cat("\nNo density plots requested - this option is irrelevant\n")
        }
        else {
                cat("\nSelect kernel bandwidth function required:\n")
                kernel.menu <- c("Smooth (0.25 * sample range)", 
                        "Coarse (Silverman 1986 eqn. 3.28 & 3.30)", 
                        "User-defined function", "Return to Plotting Options Menu")
                pick1 <- menu(kernel.menu)
                if (pick1 == 0) 
                        return("quit")
                switch(pick1, {
                        bw <- function(y) {
                                (max(y) - min(y))/4
                        }
                        coda.options(bandwidth = bw)
                }, {
                        bw <- function(x) {
                                1.06 * min(sd(x), IQR(x)/1.34) * 
                                 length(x)^-0.2
                        }
                        coda.options(bandwidth = bw)
                }, {
                        #
                        # Allow user to enter their own bandwidth function.
                        # This is read in as a series of character strings
                        # which are then collapsed into a single string with 
                        # no white space, before parsing and evaluating
                        # 
                        cat("DANGER! DANGER WILL ROBINSON!\n")
                        cat("If you make a mistake here you will crash\n")
                        cat("the codamenu session. Sorry, but there is\n")
                        cat("no way round this at the moment (R 0.61)\n")
                        cat("Do you want to try? (y/N)\n")
                        ans <- readline()
                        if (ans != "y" && ans != "Y") 
                                return()
                        func.OK <- F
                        while (!func.OK) {
                                cat("Enter bandwidth as a function of y, the sampled values, e.g. \n(max(y) - min(y)) / 4\n")
                                ans <- scan(what = character())
                                if (length(ans) > 0) {
                                 bw <- "function(y){"
                                 for (i in 1:length(ans)) {
                                  bw <- paste(bw, ans[i], sep = "")
                                 }
                                 bw <- paste(bw, "}", sep = "")
                                 #
                                 bw <- eval(parse(text = bw))
                                 # Carry out simple test to check whether the
                                 # function entered makes sense
                                 #
                                 func.OK <- test.bandwidth()
                                }
                        }
                        coda.options(bandwidth = bw)
                }, NULL)
        }
        return("codamenu.options.plot")
}
