"codamenu.diags.geweke" <-
function () 
{
        this.menu <- next.menu <- "codamenu.diags.geweke"
        codamenu.output.header("GEWEKE CONVERGENCE DIAGNOSTIC (Z-score)")
        print(geweke.diag(work.dat, frac1 = coda.options("frac1"), 
                frac2 = coda.options("frac2")), digits = coda.options("digits"))
        cat("\nGeweke Plots Menu\n")
        cat("*****************\n")
        choices <- c("Change window size", "Plot Z-scores", "Change bin size for plot", 
                "Return to Diagnostics Menu")
        action.list <- c("ChangeWindow", "Plot", "ChangeBin", 
                "Return")
        while (next.menu == "codamenu.diags.geweke") {
                pick <- menu(choices)
                if (pick == 0) 
                        return("quit")
                switch(action.list[pick], ChangeWindow = {
                        next.menu <- codamenu.options.geweke.win(this.menu)
                        codamenu.output.header("")
                        print(geweke.diag(work.dat, frac1 = coda.options("frac1"), 
                                frac2 = coda.options("frac2")), 
                                digits = coda.options("digits"))
                }, Plot = {
                        if ((is.numeric(coda.options("geweke.bin")) && 
                                nrow(work.dat) < 50 + coda.options("geweke.bin")) || 
                                (is.numeric(coda.options("geweke.max")) && 
                                 nrow(work.dat) < 50 + coda.options("geweke.max"))) {
                                cat("\n******* Error: *******")
                                cat("\nNot enough iterations available for plot\n")
                        }
                        else {
                                frac1 <- coda.options("frac1")
                                frac2 <- coda.options("frac2")
                                max.bins <- coda.options("geweke.max")
                                bin.width <- coda.options("geweke.bin")
                                auto <- !coda.options("user.layout")
                                if (max.bins != 0 & bin.width != 
                                 0) 
                                 geweke.plot(work.dat, frac1 = frac1, 
                                  frac2 = frac2, max.bins = max.bins, 
                                  bin.width = bin.width, auto.layout = auto)
                                else if (max.bins != 0) 
                                 geweke.plot(work.dat, frac1 = frac1, 
                                  frac2 = frac2, max.bins = max.bins, 
                                  auto.layout = auto)
                                else if (bin.width != 0) 
                                 geweke.plot(work.dat, frac1 = frac1, 
                                  frac2 = frac2, bin.width = bin.width, 
                                  auto.layout = auto)
                                else geweke.plot(work.dat, frac1 = frac1, 
                                 frac2 = frac2, auto.layout = auto)
                                mpause3()
                        }
                }, ChangeBin = {
                        next.menu <- codamenu.options.geweke.bin(this.menu)
                }, Return = {
                        next.menu <- "codamenu.diags"
                })
        }
        return(next.menu)
}
