% $Id: coef.pdIdent.Rd,v 1.5 1998/04/02 18:53:10 pinheiro Exp $
\name{coef.pdIdent}
\title{pdIdent Object Coefficients}
\usage{
coef(object, unconstrained)
}
\alias{coef.pdDiag}
\arguments{
 \item{object}{an object inheriting from class \code{pdIdent},
   representing a multiple of the identity positive-definite matrix.}
 \item{unconstrained}{a logical value. If \code{TRUE} the logarithm of
   the standard deviation corresponding to the variance-covariance
   matrix represented by \code{object} is returned. If \code{FALSE} the
   standard deviation is returned. Defaults to \code{TRUE}.} 
}
\description{
  This method function extracts the coefficients associated with the
  positive-definite matrix represented by \code{object}. 
}
\value{
  a vector with the coefficients corresponding to \code{object}.
}
\author{Jose Pinheiro and Douglas Bates }

\seealso{\code{\link{coef.pdMat}}, \code{\link{pdMat}}}

\examples{
library(lme)
coef(pdIdent(diag(3)))
}
\keyword{models}
