#include "ooglutil.h"
#include "geom.h"
#include "polylistP.h"
#include "pointlistP.h"

void *polylist_PointList_get(int sel, Geom *geom, va_list args);
void *polylist_PointList_fillin(int sel, Geom *geom, va_list args);
void *polylist_PointList_set(int sel, Geom *geom, va_list args);
void *polylist_PointList_length(int sel, Geom *geom, va_list args);

#define MAX_METHODS 4

static SpecFunc methods[] = {
  "PointList_get", polylist_PointList_get,
  "PointList_fillin", polylist_PointList_fillin,
  "PointList_set", polylist_PointList_set,
  "PointList_length", polylist_PointList_length
  };

static char msg[] = "ptlPolylist.c";

ptlPolylist_init() {
  pointlist_initspec(methods, MAX_METHODS, GeomClassLookup("polylist"));
}


void *polylist_PointList_get(int sel, Geom *geom, va_list args) {
  PolyList *p = (PolyList *)geom;
  HPoint3 *plist;
  TransformPtr t;
  
  plist = OOGLNewNE(HPoint3, p->n_verts, msg);
  t = va_arg(args, TransformPtr);
  return GeomCall(GeomMethodSel("PointList_fillin"), geom, t, 0, plist);
}


void *polylist_PointList_fillin(int sel, Geom *geom, va_list args) {
  int i;
  PolyList *p = (PolyList *)geom;
  TransformPtr t;
  HPoint3 *plist;

  t = va_arg(args, TransformPtr);
  va_arg(args, int);
  plist = va_arg(args, HPoint3 *);

  for (i = 0; i < p->n_verts; i++)
    HPt3Transform(t, &p->vl[i].pt, &plist[i]);

  return((void *)plist);
}

void *polylist_PointList_set(int sel, Geom *geom, va_list args) {
  int i;
  PolyList *p = (PolyList *)geom;
  HPoint3 *plist;

  va_arg(args, int);
  plist = va_arg(args, HPoint3 *);
  for (i = 0; i < p->n_verts; i++) HPt3Copy(&plist[i], &p->vl[i].pt);
  return((void *)p);
}


void *polylist_PointList_length(int sel, Geom *geom, va_list args) {
  PolyList *p = (PolyList *)geom;
  return((void *)p->n_verts);
}
