/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "quadP.h"

Quad *
QuadFSave(register Quad *q, FILE *f, char *fname)
{
	register int i, k;
	HPoint3 *p;
	Point3 *p3, *n;
	ColorA *c;

	if(q == NULL || f == NULL)
		return(NULL);
	if(q->flag & QUAD_C) fputc('C', f);
	if(q->flag & QUAD_N) fputc('N', f);
	if(q->geomflags & VERT_4D) fputc('4', f);
	fprintf(f, "QUAD\n");
	p = &q->p[0][0];
	n = (q->flag & QUAD_N) ? &q->n[0][0] : NULL;
	c = (q->flag & QUAD_C) ? &q->c[0][0] : NULL;
	for(i = 4 * q->maxquad; --i >= 0 && !ferror(f); ) {
	    if (q->geomflags & VERT_4D) fprintf(f, "%g %g %g %g",
			p->x, p->y, p->z, p->w);
	    else  fprintf(f, "%g %g %g",
			p->x, p->y, p->z);
	    p++;
	    if(n) {
		fprintf(f, "  %g %g %g",
			n->x, n->y, n->z);
		n++;
	    }
	    if(c) {
		fprintf(f, "  %.3g %.3g %.3g %.3g",
			c->r, c->g, c->b, c->a);
		c++;
	    }
	    fputc('\n', f);
	    if((i & 3) == 0)
		fputc('\n', f);
	}
	return(ferror(f) ? NULL : q);
}
