/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "mgpick.h"

typedef struct mgpickcontext {
  struct mgcontext mgctx;	/* The mgcontext */
  struct pick pick;

#ifdef notdef
  Point3 got;

  float thresh;

  int want;               /* Fields wanted */
  int  found;             /* Fields found */

  vvec gcur;              /* Path to the current primitive - 
			     used for recursion */
  vvec gpath;             /* Path to picked primitive */
  Geom *gprim;            /* Picked primitive */

  HPoint3 v;              /* picked vertex, if any */
  int vi;                 /* index of picked vertex */

  HPoint3 e[2];           /* endpoints of picked edge, if any */
  int ei[2];              /* indices of endpoints of picked edge */

  Transform Tprim;
  Transform Tmirp;
  Transform Tw;
  Transform Tself;

  HPoint3 *f;             /* array of vertices of picked face, if any */
  int fn;                 /* number of vertices in array f */
  int fi;                 /* index of picked face */
#endif

} mgpickcontext;


/* We save the current W2C/C2W xforms on each call to mgopengl_worldbegin()
 * because the ModelView matrix stack actually stores both our object
 * xform and the view matrix:
 *
 *   ModelView = [ obj xform ] * [ W2C ]
 *
 * Since we use the GL ModelView stack to keep track of our object xform,
 * instead of using the actual stack in the mgcontext struct, having
 * ModelView = W2C corresponds to [ obj xform ] = identity.  We save W2C
 * and C2W on each mgopengl_worldbegin() because _mgc->cam might change
 * during the course of the frame, but isn't supposed to be reinterpreted
 * until the next mgopengl_worldbegin().
 */

#define _mgpickc		((mgpickcontext*)_mgc)
