#ifndef BASICFNS_H
#define BASICFNS_H

#include "hpointn.h"
#include "hpoint3.h"

/*Find the standard inner product of two n-dimensional vectors*/
float InnerProductN(float *a, float *b, int dim);

/*Find the Euclidean norm of an n-dimensional vector*/
float NormN(float *a, int dim);

/*Turn an HPoint3 into an HPointN.  assumes space has already been allocated in
destination*/
HPointN *extract(HPoint3 *source, HPointN *destination, int dimsource);

HPoint3 *place(HPointN *source, HPoint3 *destination);

#endif
