/*
 * Copyright (c) 1997,1998 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Mon Sep 28 17:19:41 EDT 1998 */

#include <fftw-int.h>
#include <fftw.h>

/* Generated by: ./genfft -magic-alignment-check -magic-twiddle-load-all -magic-variables 4 -magic-loopi -hc2hc-backward 5 */

/*
 * This function contains 85 FP additions, 55 FP multiplications,
 * (or, 57 additions, 27 multiplications, 28 fused multiply/add),
 * 27 stack variables, and 40 memory accesses
 */
static const fftw_real K250000000 = FFTW_KONST(+0.250000000000000000000000000000000000000000000);
static const fftw_real K559016994 = FFTW_KONST(+0.559016994374947424102293417182819058860154590);
static const fftw_real K951056516 = FFTW_KONST(+0.951056516295153572116439333379382143405698634);
static const fftw_real K587785252 = FFTW_KONST(+0.587785252292473129168705954639072768597652438);
static const fftw_real K2_000000000 = FFTW_KONST(+2.000000000000000000000000000000000000000000000);
static const fftw_real K1_118033988 = FFTW_KONST(+1.118033988749894848204586834365638117720309180);
static const fftw_real K500000000 = FFTW_KONST(+0.500000000000000000000000000000000000000000000);
static const fftw_real K1_902113032 = FFTW_KONST(+1.902113032590307144232878666758764286811397268);
static const fftw_real K1_175570504 = FFTW_KONST(+1.175570504584946258337411909278145537195304875);

/*
 * Generator Id's : 
 * $Id: exprdag.ml,v 1.35 1998/09/25 19:14:16 athena Exp $
 * $Id: fft.ml,v 1.40 1998/09/14 14:43:06 fftw Exp $
 * $Id: to_c.ml,v 1.23 1998/09/14 14:43:08 fftw Exp $
 */

void fftw_hc2hc_backward_5(fftw_real *A, const fftw_complex *W, int iostride, int m, int dist)
{
     int i;
     fftw_real *X;
     fftw_real *Y;
     X = A;
     Y = A + (5 * iostride);
     {
	  fftw_real tmp90;
	  fftw_real tmp92;
	  fftw_real tmp81;
	  fftw_real tmp84;
	  fftw_real tmp85;
	  fftw_real tmp86;
	  fftw_real tmp91;
	  fftw_real tmp87;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp88;
	       fftw_real tmp89;
	       fftw_real tmp82;
	       fftw_real tmp83;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp88 = Y[-iostride];
	       tmp89 = Y[-2 * iostride];
	       tmp90 = (K1_175570504 * tmp88) - (K1_902113032 * tmp89);
	       tmp92 = (K1_902113032 * tmp88) + (K1_175570504 * tmp89);
	       tmp81 = X[0];
	       tmp82 = X[iostride];
	       tmp83 = X[2 * iostride];
	       tmp84 = tmp82 + tmp83;
	       tmp85 = tmp81 - (K500000000 * tmp84);
	       tmp86 = K1_118033988 * (tmp83 - tmp82);
	  }
	  X[0] = tmp81 + (K2_000000000 * tmp84);
	  tmp91 = tmp85 - tmp86;
	  X[iostride] = tmp91 - tmp92;
	  X[4 * iostride] = tmp91 + tmp92;
	  tmp87 = tmp85 + tmp86;
	  X[2 * iostride] = tmp87 - tmp90;
	  X[3 * iostride] = tmp87 + tmp90;
     }
     X = X + dist;
     Y = Y - dist;
     for (i = 2; i < m; i = i + 2, X = X + dist, Y = Y - dist, W = W + 4) {
	  fftw_real tmp33;
	  fftw_real tmp52;
	  fftw_real tmp70;
	  fftw_real tmp59;
	  fftw_real tmp40;
	  fftw_real tmp58;
	  fftw_real tmp41;
	  fftw_real tmp54;
	  fftw_real tmp48;
	  fftw_real tmp53;
	  fftw_real tmp63;
	  fftw_real tmp75;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp39;
	       fftw_real tmp51;
	       fftw_real tmp36;
	       fftw_real tmp50;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp33 = X[0];
	       {
		    fftw_real tmp37;
		    fftw_real tmp38;
		    fftw_real tmp34;
		    fftw_real tmp35;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp37 = X[2 * iostride];
		    tmp38 = Y[-3 * iostride];
		    tmp39 = tmp37 + tmp38;
		    tmp51 = tmp37 - tmp38;
		    tmp34 = X[iostride];
		    tmp35 = Y[-4 * iostride];
		    tmp36 = tmp34 + tmp35;
		    tmp50 = tmp34 - tmp35;
	       }
	       tmp52 = (K587785252 * tmp50) - (K951056516 * tmp51);
	       tmp70 = (K951056516 * tmp50) + (K587785252 * tmp51);
	       tmp59 = K559016994 * (tmp36 - tmp39);
	       tmp40 = tmp36 + tmp39;
	       tmp58 = tmp33 - (K250000000 * tmp40);
	  }
	  {
	       fftw_real tmp47;
	       fftw_real tmp62;
	       fftw_real tmp44;
	       fftw_real tmp61;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp41 = Y[0];
	       {
		    fftw_real tmp45;
		    fftw_real tmp46;
		    fftw_real tmp42;
		    fftw_real tmp43;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp45 = Y[-2 * iostride];
		    tmp46 = X[3 * iostride];
		    tmp47 = tmp45 - tmp46;
		    tmp62 = tmp45 + tmp46;
		    tmp42 = Y[-iostride];
		    tmp43 = X[4 * iostride];
		    tmp44 = tmp42 - tmp43;
		    tmp61 = tmp42 + tmp43;
	       }
	       tmp54 = K559016994 * (tmp44 - tmp47);
	       tmp48 = tmp44 + tmp47;
	       tmp53 = tmp41 - (K250000000 * tmp48);
	       tmp63 = (K587785252 * tmp61) - (K951056516 * tmp62);
	       tmp75 = (K951056516 * tmp61) + (K587785252 * tmp62);
	  }
	  X[0] = tmp33 + tmp40;
	  {
	       fftw_real tmp72;
	       fftw_real tmp78;
	       fftw_real tmp76;
	       fftw_real tmp80;
	       fftw_real tmp71;
	       fftw_real tmp74;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp71 = tmp54 + tmp53;
	       tmp72 = tmp70 + tmp71;
	       tmp78 = tmp71 - tmp70;
	       tmp74 = tmp59 + tmp58;
	       tmp76 = tmp74 - tmp75;
	       tmp80 = tmp74 + tmp75;
	       {
		    fftw_real tmp69;
		    fftw_real tmp73;
		    fftw_real tmp77;
		    fftw_real tmp79;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp69 = c_re(W[0]);
		    tmp73 = c_im(W[0]);
		    Y[-3 * iostride] = (tmp69 * tmp72) - (tmp73 * tmp76);
		    X[iostride] = (tmp73 * tmp72) + (tmp69 * tmp76);
		    tmp77 = c_re(W[3]);
		    tmp79 = c_im(W[3]);
		    Y[0] = (tmp77 * tmp78) - (tmp79 * tmp80);
		    X[4 * iostride] = (tmp79 * tmp78) + (tmp77 * tmp80);
	       }
	  }
	  Y[-4 * iostride] = tmp41 + tmp48;
	  {
	       fftw_real tmp56;
	       fftw_real tmp66;
	       fftw_real tmp64;
	       fftw_real tmp68;
	       fftw_real tmp55;
	       fftw_real tmp60;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp55 = tmp53 - tmp54;
	       tmp56 = tmp52 + tmp55;
	       tmp66 = tmp55 - tmp52;
	       tmp60 = tmp58 - tmp59;
	       tmp64 = tmp60 - tmp63;
	       tmp68 = tmp60 + tmp63;
	       {
		    fftw_real tmp49;
		    fftw_real tmp57;
		    fftw_real tmp65;
		    fftw_real tmp67;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp49 = c_re(W[1]);
		    tmp57 = c_im(W[1]);
		    Y[-2 * iostride] = (tmp49 * tmp56) - (tmp57 * tmp64);
		    X[2 * iostride] = (tmp57 * tmp56) + (tmp49 * tmp64);
		    tmp65 = c_re(W[2]);
		    tmp67 = c_im(W[2]);
		    Y[-iostride] = (tmp65 * tmp66) - (tmp67 * tmp68);
		    X[3 * iostride] = (tmp67 * tmp66) + (tmp65 * tmp68);
	       }
	  }
     }
     if (i == m) {
	  fftw_real tmp11;
	  fftw_real tmp13;
	  fftw_real tmp20;
	  fftw_real tmp21;
	  fftw_real tmp1;
	  fftw_real tmp6;
	  fftw_real tmp8;
	  fftw_real tmp16;
	  fftw_real tmp17;
	  fftw_real tmp12;
	  fftw_real tmp19;
	  ASSERT_ALIGNED_DOUBLE();
	  tmp11 = Y[-iostride];
	  tmp12 = Y[0];
	  tmp19 = tmp11 - tmp12;
	  tmp13 = tmp11 + tmp12;
	  tmp20 = K559016994 * (tmp11 + tmp19);
	  tmp21 = tmp12 - (K250000000 * (tmp19 - tmp11));
	  {
	       fftw_real tmp4;
	       fftw_real tmp2;
	       fftw_real tmp3;
	       fftw_real tmp5;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp1 = X[0];
	       tmp4 = X[2 * iostride];
	       tmp2 = X[iostride];
	       tmp3 = tmp1 + tmp2;
	       tmp5 = tmp2 + tmp4;
	       tmp6 = tmp3 + tmp5;
	       tmp8 = K559016994 * (tmp3 - tmp5);
	       tmp16 = tmp2 - tmp1;
	       tmp17 = tmp4 - tmp2;
	  }
	  X[0] = tmp1 + tmp6;
	  {
	       fftw_real tmp14;
	       fftw_real tmp27;
	       fftw_real tmp10;
	       fftw_real tmp26;
	       fftw_real tmp30;
	       fftw_real tmp22;
	       fftw_real tmp29;
	       fftw_real tmp18;
	       fftw_real tmp9;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp14 = (K587785252 * tmp11) + (K951056516 * tmp13);
	       tmp27 = (K587785252 * tmp13) - (K951056516 * tmp11);
	       tmp9 = tmp1 - (K250000000 * tmp6);
	       tmp10 = tmp8 + tmp9;
	       tmp26 = tmp9 - tmp8;
	       tmp30 = tmp21 - tmp20;
	       tmp22 = tmp20 + tmp21;
	       tmp29 = (K587785252 * tmp16) - (K951056516 * tmp17);
	       tmp18 = (K951056516 * tmp16) + (K587785252 * tmp17);
	       {
		    fftw_real tmp7;
		    fftw_real tmp15;
		    fftw_real tmp23;
		    fftw_real tmp24;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp7 = c_re(W[0]);
		    tmp15 = c_im(W[0]);
		    X[iostride] = (tmp7 * (tmp10 - tmp14)) + (tmp15 * (tmp18 + tmp22));
		    tmp23 = c_re(W[3]);
		    tmp24 = c_im(W[3]);
		    X[4 * iostride] = (tmp23 * (tmp10 + tmp14)) + (tmp24 * (tmp22 - tmp18));
	       }
	       {
		    fftw_real tmp25;
		    fftw_real tmp28;
		    fftw_real tmp31;
		    fftw_real tmp32;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp25 = c_re(W[1]);
		    tmp28 = c_im(W[1]);
		    X[2 * iostride] = (tmp25 * (tmp26 - tmp27)) + (tmp28 * (tmp29 + tmp30));
		    tmp31 = c_re(W[2]);
		    tmp32 = c_im(W[2]);
		    X[3 * iostride] = (tmp31 * (tmp26 + tmp27)) + (tmp32 * (tmp30 - tmp29));
	       }
	  }
     }
}

static const int twiddle_order[] =
{1, 2, 3, 4};
fftw_codelet_desc fftw_hc2hc_backward_5_desc =
{
     "fftw_hc2hc_backward_5",
     (void (*)()) fftw_hc2hc_backward_5,
     5,
     FFTW_BACKWARD,
     FFTW_HC2HC,
     91,
     4,
     twiddle_order,
};
