;;; ----------------------------------------------------------------------
;;;
;;; BIND-CLN: Generate a Talk binding for CLN
;;;
;;; ----------------------------------------------------------------------
;;;
;;; Created by Bruno Haible on Fri Nov 22 23:37:28 1996
;;;

;; Instructions:
;; 1. Set the environment variables CLN_DIR and CLN_TARGETDIR, e.g.
;;    export CLN_DIR="$HOME/cln"
;;    export CLN_TARGETDIR="$HOME/cln/linuxelf"
;; 2. Run italk,
;;    (pushf (workspace-path) #f"$CLN_DIR/italk-interface")
;;    (in-workspaces '(icln))
;;    (load-program-unit 'bind-cln)
;;    (bind-cln)

(defun bind-cln ()
  (let ((bind-dir (make-filename (.cln-binddir))))
    (unless (and (access bind-dir) (eq (file-type bind-dir) 'S_ISDIR))
      (mkdir bind-dir)))
  (bind-cpp-api
    (list (make-filename (catenate (.cln-dir) "/include/cln.h")))
    (make-filename (catenate (.cln-binddir) "/icln"))
    cpp-options: (list
                  (list 'other
                        (catenate "-I" (.cln-targetdir) "/include")
                        (catenate "-I" (.cln-dir) "/include")))
    cppparse-options: (list
                       (list '|i86_linux1.2_gnu2.7|
                             "-D__GNUC_MINOR__=6")) ; problem in <_G_config.h>
    filter: #'.filter
    sgi_5_2_3-compatibility-p: ()
    boolean-types: '(cl_boolean)
    cpp-types-exporters: '(libiltcplibm)
    user-execution: '(libiltcplibe)
    description: "Talk/CLN binding"
    link-options: (list
                   (list '|i86_linux1.2_gnu2.7|
                         ; "-Wl,--sort-constructors" ; I have hacked my copy of GNU ld
                         (list 'executable
                           (catenate (.cln-targetdir) "/src/libcln.a")))
                   (list 'other
                         (list 'executable
                           (catenate (.cln-targetdir) "/src/libcln.a"))))
    libraryp: t
    executablep: t
    buildp: t
) )

(defglobal .removed-entities
  '("cl_R_div_t::cl_R_div_t"   ; constructor nonexistent
    "cl_R_fdiv_t::cl_R_fdiv_t" ; constructor nonexistent
    "cl_null_ring::cl_null_ring" ; constructor nonexistent
    "cl_number::_as_cl_private_thing" ; ??
    "TheBignum"            ; inline elsewhere, not global
    "TheFfloat"            ; inline elsewhere, not global
    "TheDfloat"            ; inline elsewhere, not global
    "TheLfloat"            ; inline elsewhere, not global
    "TheRatio"             ; inline elsewhere, not global
    "TheComplex"           ; inline elsewhere, not global
    "eq"                   ; inline elsewhere, not global
    "cl_SF_p"              ; inline elsewhere, not global
    "cl_FF_p"              ; inline elsewhere, not global
    "cl_DF_p"              ; inline elsewhere, not global
    "cl_LF_p"              ; inline elsewhere, not global
    "cl_F_p"               ; inline elsewhere, not global
    "cl_I_p"               ; inline elsewhere, not global
    "cl_RA_p"              ; inline elsewhere, not global
    "cl_R_p"               ; inline elsewhere, not global
    "cl_N_p"               ; inline elsewhere, not global
    "realp"                ; inline elsewhere, not global
    "complexp"             ; inline elsewhere, not global
    "FN_to_L"              ; inline elsewhere, not global
    "FN_to_UL"             ; inline elsewhere, not global
    "cl_FN_word"           ; inline elsewhere, not global
    "SF_uexp"              ; inline elsewhere, not global
    "SF_sign"              ; inline elsewhere, not global
    "SF_mant"              ; inline elsewhere, not global
    "allocate_ratio"       ; inline elsewhere, not global
    "allocate_complex"     ; inline elsewhere, not global
    "cl_SF::cl_SF(cl_sfloat *, cl_uint)" ; inline elsewhere, not global
    "cl_FF::cl_FF(cl_heap_ffloat *)"     ; inline elsewhere, not global
    "cl_DF::cl_DF(cl_heap_dfloat *)"     ; inline elsewhere, not global
    "cl_LF::cl_LF(cl_heap_lfloat *)"     ; inline elsewhere, not global
    "cl_I::cl_I(cl_fixnum *, cl_uint)"   ; inline elsewhere, not global
    "cl_I::cl_I(cl_heap_bignum *)"       ; inline elsewhere, not global
    "cl_RA::cl_RA(cl_heap_ratio *)"      ; inline elsewhere, not global
    "cl_N::cl_N(cl_heap_complex *)"      ; inline elsewhere, not global
    "cl_symbol::cl_symbol(hashuniq *, const cl_string &)" ; dito
    "cl_heap_GV::maxbits"  ; actually only cl_heap_GV<_cl_MI>::maxbits
    "abs" "min" "max" "equal" "copy" ; clash with Talk functions
    "gcd" "lcm"                      ; clash with Talk functions
)  )

(defun .filter (file name name+args)
  (if (and (regexp-match "^cl_" (string (basename file)))
           (not (or (member name .removed-entities #'string=)
                    (member name+args .removed-entities #'string=))))
    (progn
      (printf "Binding %s\n" name+args)
      'always)
    'never
) )

(defun .cln-dir ()
  ;(or (getenv "CLN_DIR") "$HOME/cln")
  "$CLN_DIR"
)

(defun .cln-targetdir ()
  ;(or (getenv "CLN_TARGETDIR") "$HOME/cln/linuxelf")
  "$CLN_TARGETDIR"
)

(defun .cln-binddir ()
  ;; This should match the `root-directory'/`directories' in `iclnws.td'.
  ;(catenate (.cln-targetdir) "/italk-interface")
  (catenate (.cln-dir) "/italk-interface")
)
