// General vectors of rational numbers.

#ifndef _CL_GV_RATIONAL_H
#define _CL_GV_RATIONAL_H

#include "cl_number.h"
#include "cl_GV_real.h"
#include "cl_io.h"

// A vector of rational numbers is just a normal vector of real numbers.

typedef cl_heap_GV<cl_RA> cl_heap_GV_RA;

struct cl_GV_RA : public cl_GV<cl_RA,cl_GV_R> {
public:
	// Constructors.
	cl_GV_RA ();
	cl_GV_RA (const cl_GV_RA&);
	cl_GV_RA (uintL len);
	// Assignment operators.
	cl_GV_RA& operator= (const cl_GV_RA&);
	// Private pointer manipulations.
	cl_GV_RA (cl_heap_GV_RA* p) : cl_GV<cl_RA,cl_GV_R> (p) {}
	cl_GV_RA (cl_private_thing p) : cl_GV<cl_RA,cl_GV_R> (p) {}
};
inline cl_GV_RA::cl_GV_RA (const cl_GV_RA& x) : cl_GV<cl_RA,cl_GV_R> (as_cl_private_thing(x)) {}
CL_DEFINE_ASSIGNMENT_OPERATOR(cl_GV_RA,cl_GV_RA)
inline cl_GV_RA::cl_GV_RA (uintL len)
	: cl_GV<cl_RA,cl_GV_R> ((cl_heap_GV_RA*) cl_make_heap_GV_N(len)) {}
inline cl_GV_RA::cl_GV_RA ()
	: cl_GV<cl_RA,cl_GV_R> ((cl_heap_GV_RA*) (cl_heap_GV_N*) cl_null_GV_N) {}

// Copy a vector.
inline cl_GV_RA copy (const cl_GV_RA& vector)
{
	return The(cl_GV_RA) (copy((const cl_GV_R&) vector));
}

// Output.
inline void fprint (cl_ostream stream, const cl_GV_RA& x)
{
	extern cl_print_flags cl_default_print_flags;
	extern void print_vector (cl_ostream stream, const cl_print_flags& flags, void (* fun) (cl_ostream, const cl_print_flags&, const cl_number&), const cl_GV_N& vector);
	extern void print_rational (cl_ostream stream, const cl_print_flags& flags, const cl_RA& z);
	print_vector(stream, cl_default_print_flags,
	             (void (*) (cl_ostream, const cl_print_flags&, const cl_number&))
	             (void (*) (cl_ostream, const cl_print_flags&, const cl_RA&))
	             &print_rational,
	             x);
}
CL_DEFINE_PRINT_OPERATOR(cl_GV_RA)

#endif /* _CL_GV_RAATIONAL_H */
