// $Id: xxl_sum.cc,v 1.3 1997/01/07 00:28:26 aml Exp $

#include "xxl_funcs.hh"
#include "sheet.hh"


Stack_elem *Sum::eval(Stack_elem *p,Sheet *sheet, short col, short row) {
    Range_iter r(p->contents.rg_val);
    Ref ref;
    Stack_elem *s;

    sheet->propagate_error(p,se);
    switch(p->type) {
      case FORM_FP:
      case FORM_INT:
      case FORM_REF:
      case FORM_STRING:
        sum += sheet->stack_value(p);
        se->type = FORM_FP;
        se->contents.fp_val = sum;
        return(se);
      case FORM_RANGE:
        short i,j;

        for(r.first(ref); !r.last();  r.next(ref)){
            i = cell_address(ref.col,col);
            j = cell_address(ref.row,row);
            s = sheet->cellRef(i,j);
            if (!sheet->propagate_error(s,se))
                sum += sheet->stack_value(s);
        }
        se->type = FORM_FP;
        se->contents.fp_val = sum;
        return(se);
      default:
        internal_error();
    }
}

Sum::Sum() {
    sum = 0;
    se = new Stack_elem;
}

Sum::~Sum() {
    delete se;
}

// $Log: xxl_sum.cc,v $
// Revision 1.3  1997/01/07  00:28:26  aml
// Error propagation
//
// Revision 1.2  1996/12/11 21:39:51  aml
// Sumif implemented.
// Diverse time functions implemented.
// Fixed needtoscroll2 to avoid out of control scroll.
//
// Revision 1.1  1996/03/08 12:48:22  aml
// Initial revision
//
