/* DSTART                                                                    */
/*                                                                           */
/*           maildrop - mail delivery agent with filtering abilities         */
/*                                                                           */
/*  Copyright 1998, Double Precision Inc.                                    */
/*                                                                           */
/*  This program is distributed under the terms of the GNU General Public    */
/*  License. See COPYING for additional information.                         */
/* DEND                                                                      */
#include	<stdio.h>
#include	<stdlib.h>
#include	"autoconf.h"
#include	"config.h"
#include	"setgroupid.h"
#if HAVE_UNISTD_H
#include        <unistd.h>
#endif
#if HAVE_FCNTL_H
#include	<fcntl.h>
#endif
#if HAVE_SYS_STAT_H
#include	<sys/stat.h>
#endif

static const char rcsid[]="$Id: maildirmake.c 1.1 1998/04/16 23:53:22 mrsam Exp $";

int main(int argc, char *argv[])
{
	if (argc < 2)	exit(0);
#if	RESET_GID
	setgroupid(getgid());
#endif
	setuid(getuid());	// Drop any setuid privileges.

	if (mkdir(argv[1], 0700) < 0 ||
		chdir(argv[1]) < 0 ||
		mkdir("tmp", 0700) < 0 ||
		mkdir("new", 0700) < 0 ||
		mkdir("cur", 0700) < 0)
	{
		perror("maildirmake");
		exit(1);
	}
	exit(0);
	return (0);
}
