/* Just enough from the newer ttyio.h and ttyio.c of ifcico-3.0.cm.alpha-4.0
 * to make hydra.c compile
 */
#include <errno.h>
#include <time.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <termios.h>

#include "ttyio.h"

extern char *xtodos(char*);

extern int hanged_up;

#ifndef NUMTIMERS
#define NUMTIMERS 3
#endif
static time_t timer[NUMTIMERS];

#define RESETTIMER(x) tty_resettimer(x)
#define RESETTIMERS() tty_resettimers()
#define SETTIMER(x,y) tty_settimer(x,y)
#define EXPIRED(x) tty_expired(x)
#define RUNNING(x) tty_running(x)

#define WAITPUTGET(x) tty_waitputget(x)
#define FLUSHOUT() tty_flushout()
#define FLUSHIN() tty_flushin()

extern int tty_waitputget(int);
extern void tty_flushout(void);
extern void tty_flushin(void);
extern int tty_resettimer(int tno);
extern void tty_resettimers(void);
extern int tty_settimer(int,int);
extern int tty_expired(int);
extern int tty_running(int);

int tty_resettimer(int tno)
{
       if (tno >= NUMTIMERS)
       {
               errno=EINVAL;
               logerr("$invalid timer No for resettimer()");
               return -1;
       }
       debug(18,"resettimer(%d)", tno);
       timer[tno] = (time_t) 0;
       return 0;
}

void tty_resettimers(void)
{
	int i;

       debug(18,"resettimers");
       for (i=0;i<NUMTIMERS;i++) timer[i]=(time_t)0;
}

int tty_settimer(tno,interval)
int tno;
int interval;
{
       if (tno >= NUMTIMERS)
       {
               errno=EINVAL;
               logerr("$invalid timer No for settimer()");
               return -1;
       }
       debug(18,"settimer(%d,%d)",tno,interval);
       timer[tno]=time((time_t*)NULL)+interval;
       return 0;
}

int tty_expired(tno)
int tno;
 {
       time_t now;

       /* check if timer is running */
       if (timer[tno] == (time_t) 0)
         return 0;

       (void)time(&now);
       if (tno >= NUMTIMERS)
       {
               errno=EINVAL;
               logerr("$invalid timer No for expired()");
               return -1;
        }
       debug(19,"expired(%d) now=%lu,timer=%lu,return %s",
               tno,now,timer[tno],(now >= timer[tno])?"yes":"no");
       return (now >= timer[tno]);
}

int tty_running(tno)
int tno;
{
  /* check if timer is running */
  if (timer[tno] == (time_t) 0)
    return 0;
  else
    return 1;
}

int tty_waitputget(int tot)
{
  int i, rc;
  time_t timeout, now;

#ifdef HAS_SELECT
  fd_set readfds, writefds, exceptfds;
  struct timeval seltimer;
#else
#error unimplemented non-select()-based i/o
#endif
  tty_status=0;
  (void)time(&now);
  timeout=(time_t)300; /* maximum of 5 minutes */

  for (i=0; i<NUMTIMERS; i++)
  {
    if (timer[i])
    {
      if (now >= timer[i])
      {
       tty_status=STAT_TIMEOUT;
       debug(18,"timer %d already expired, return",i);
        return -tty_status;
      }
      else
      {
       if (timeout > (timer[i]-now))
         timeout=timer[i]-now;
      }
    }
  }
  if ((tot != -1) && (timeout > tot))
    timeout=tot;
  debug(18,"tty_waitputget timeout=%d",timeout);

#ifdef HAS_SELECT
  /* Initialize the file descriptor set.  */
  FD_ZERO(&readfds);
  FD_ZERO(&writefds);
  FD_ZERO(&exceptfds);

  FD_SET(0, &readfds);
  FD_SET(1, &writefds);
  FD_SET(0, &exceptfds);
  FD_SET(1, &exceptfds);

  /* Initialize the timeout data structure.  */
  seltimer.tv_sec = timeout;
  seltimer.tv_usec = 0;

  /* `select' returns 0 if timeout, 1 if input available, -1 if error.  */
  rc = select(FD_SETSIZE, &readfds, &writefds, &exceptfds, &seltimer);

  if (rc < 0)
  {
    if (hanged_up)
    {
      tty_status=STAT_HANGUP;
    }
    else
    {
      logerr("$select for putget failed");
      tty_status=STAT_ERROR;
    }
  }
  else if (rc == 0)
  {
    tty_status=STAT_TIMEOUT;
  }
  else /* rc > 0 */
  {
    if ((FD_ISSET(0,&exceptfds)) || (FD_ISSET(1,&exceptfds)))
      tty_status=STAT_ERROR;
  }

  if (tty_status)
  {
    debug(18,"returning after select with status %d",tty_status);
    return -tty_status;
  }

  rc = 0;

  if (FD_ISSET(0,&readfds))
  {
    rc |= 1;
  }

  if (FD_ISSET(1,&writefds))
  {
    rc |= 2;
  }
#else
#endif

  return rc;
}


void tty_flushin(void)
{
#ifdef HAS_SGTTY_H
       int     fd;
       fd = FREAD;
       ioctl(fdout, TIOCFLUSH, &fd);
#else
   tcflush(0, TCIFLUSH);
#endif
}

void tty_flushout(void)
{
#ifdef HAS_SGTTY_H
       int     fd;
       fd = FWRITE;
       ioctl(fdout, TIOCFLUSH, &fd);
#else
  tcflush(1, TCOFLUSH);
#endif
}


