#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <utime.h>

#include "defs.h"
#include "mail.h"

bool is_From_line( char* line ) {
  if( !strncmp( line, "From", 4 ) )
    return true;
  return false;
}

bool is_blank_line( char* line ) {
  while( *line ) {
    if( *line != ' ' && *line != '\n' && *line != '\t' && *line != '\r' )
      return false;
    line++;
  }
  return true;
}

char* cfg_file() {
  static char buff[1024];
  sprintf(buff, "%s/.glbiffrc", getenv("HOME"));
  return buff;
}

/*
 * returns number of messages found in folder
 */
int count_messages( char* filename ) {
  struct stat st;
  if( stat( filename, &st ) ) {
    fprintf( stderr, "Unable to stat %s\n", filename );
    return -1;
  }

  FILE* fl = fopen( filename, "r" );
  if( !fl ) {
    fprintf( stderr, "Unable to open %s\n", filename );
    return -1;
  }

  char line[1024];
  int messages = 0;
  bool looking_for_header = true;
  bool in_header = false;
  bool last_line_blank = true;

  fgets( line, 1024, fl );

  while( !feof( fl ) ) {
    if( looking_for_header && is_From_line( line ) && last_line_blank ) {
      in_header = true;
      looking_for_header = false;
      messages++;
    } else if( in_header && is_blank_line( line ) ) {
      in_header = false;
      looking_for_header = true;
    }

    last_line_blank = is_blank_line( line );

    fgets( line, 1024, fl );
  }
  fclose(fl);

  // here just restore the modify and access times to what they were
  struct utimbuf buf;
  buf.actime = st.st_atime;
  buf.modtime = st.st_mtime;
  utime( filename, &buf );

  return messages;
}

/*
 * returns the file size of the mailbox
 */
ulong check_mailbox( char *filename, bool& anymail, bool& unreadmail ) {
  struct stat st;
  off_t  size;

  if( stat( filename, &st ) ) {
#ifdef DEBUG
    printf("!!!--Couldn't stat file %s .\n",filename);
#endif
    anymail    = false;
    unreadmail = false;
    size = 0;
  } else {
    size = st.st_size;

    anymail = (size>0)? true: false;
    unreadmail = (st.st_mtime > st.st_atime && size>0) ? true: false;
#ifdef DEBUG
    printf( "unreadmail = %c\n", (unreadmail)?'y':'n' );
#endif
  }
  return size;
}


/*
 * returns total number of messages 
 */
int check_all_mailboxes( bool& anymail, bool& unreadmail, bool& newmail ) {
  static ulong oldsize = 0;
  ulong newsize = 0;
  int messages = 0;
  bool a, u;

  anymail= false;
  unreadmail= false;
  newmail= false;

  FILE* fl = fopen(cfg_file(),"r");
  if( !fl ) {
    printf("error opening file %s.\nPlease verify that you have one.",\
	   cfg_file());
    return -1;
  }

#ifdef DEBUG
  printf("read configuration file %s.\n",cfg_file());
#endif

  char buff[1024];
  fgets( buff, 1024, fl );

  while( !feof( fl ) ) {
    if( buff[strlen(buff)-1] == '\n' )
      buff[strlen(buff)-1] = 0;		// kill off the trailing '\n'

    // allow some different forms of mailbox spec. lines
    char* mbox_name=buff+1;
    if( *mbox_name==' ' || *mbox_name=='\t' )
      mbox_name++;
    
#ifdef DEBUG
    printf("checking mailbox: %s\n", mbox_name );
#endif
    ulong size = check_mailbox( mbox_name, a, u );

    anymail = (a)? true: anymail;
    unreadmail = (u)? true: unreadmail;

    newsize += size;
    if( size && (buff[0]=='y' || buff[0]=='Y') )
      messages += count_messages( mbox_name );

    fgets( buff, 1024, fl );	// get the next mailbox name
  }

  if( newsize > oldsize && unreadmail )
    newmail = true;

  oldsize = newsize;

#ifdef DEBUG
  printf( "Messages in mailboxes : %d (new = %c)\n", messages, (unreadmail)?'y':'n' );
#endif

  fclose(fl);

  return messages;
}

