/*************************************************
*     Exim - an Internet mail transport agent    *
*************************************************/

/* Copyright (c) University of Cambridge 1995 - 1998 */
/* See the file NOTICE for conditions of use and distribution. */

#include "../exim.h"
#include "dnsdb.h"

/* Compile these functions only if LOOKUP_DNSDB is defined. However, some
compilers don't like compiling empty modules, so keep them happy with a
dummy when skipping the rest. */

#ifndef LOOKUP_DNSDB
static void dummy(void) { dummy(); }
#else


/* Ancient systems (e.g. SunOS4) don't appear to have T_TXT defined in their
header files. */

#ifndef T_TXT
#define T_TXT 16
#endif



/*************************************************
*              Open entry point                  *
*************************************************/

/* See local README for interface description. */

void *
dnsdb_open(char *filename, char **errmsg)
{
return (void *)(-1);   /* Any non-0 value */
}



/*************************************************
*           Find entry point for dnsdb           *
*************************************************/

/* See local README for interface description. */

int
dnsdb_find(void *handle, char *filename, char *keystring, int length,
  char **result, char **errmsg)
{
int rc;
dns_record *rr;
char buffer[256];

dns_init(FALSE, FALSE);    /* In case first time resolver is used. */

rc = dns_lookup(keystring, T_TXT, NULL);

if (rc == DNS_NOMATCH) return FAIL;
if (rc != DNS_SUCCEED) return DEFER;

for (rr = dns_next_rr(RESET_ANSWERS); rr != NULL;
     rr = dns_next_rr(RESET_NEXT))
  {
  if (rr->type == T_TXT)
    {
    int len = (rr->data)[0];
    *result = string_copyn((char *)(rr->data+1), len);
    break;
    }
  }

return OK;
}

#endif  /* LOOKUP_DNSDB */

/* End of lookups/dnsdb.c */
