/*								-*- C++ -*-
 * $Id: UTL_net.cpp,v 1.1 1996-09-25 11:31:59+02 mho Exp $
 *
 * Purpose: host and user net info
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#include "wx_setup.h"
#include "wx.h"

#include <netdb.h>
#include <pwd.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#ifdef SVR4
#include <sys/systeminfo.h>
#endif

Bool wxGetHostName(char *buf, int sz)
{
    *buf = '\0';
#if defined(SVR4) && !defined(__sgi)
    return (sysinfo(SI_HOSTNAME, buf, sz) != -1);
#else /* BSD Sockets */
    char name[255];
    struct hostent *h;
    // Get hostname
    if (gethostname(name, sizeof(name)/sizeof(char)-1) == -1)
	return FALSE;
    // Get official full name of host
    strncpy(buf, (h=gethostbyname(name))!=NULL ? h->h_name : name, sz-1);
    return TRUE;
#endif
}

Bool wxGetEmailAddress(char *address, int maxSize)
{
    char host[65];
    char user[65];

    *address = '\0';
    if (wxGetHostName(host, 64) == FALSE)
	return FALSE;
    if (wxGetUserId(user, 64) == FALSE)
	return FALSE;

    char tmp[130];
    strcpy(tmp, user);
    strcat(tmp, "@");
    strcat(tmp, host);
    strncpy(address, tmp, maxSize - 1);
    address[maxSize-1] = '\0';
    return TRUE;
}

Bool wxGetUserId(char *buf, int sz)
{
    struct passwd *who;

    *buf = '\0';
    if ((who = getpwuid(getuid ())) != NULL) {
	strncpy (buf, who->pw_name, sz-1);
	return TRUE;
    }
    return FALSE;
}

Bool wxGetUserName(char *buf, int sz)
{
    struct passwd *who;

    *buf = '\0';
    if ((who = getpwuid (getuid ())) != NULL) {
	strncpy (buf, who->pw_gecos, sz - 1);
	return TRUE;
    }
    return FALSE;
}
