/*
 * VF_Comp.c
 *
 *  Programmmed by Hirotsugu Kakugawa, Hiroshima University
 *  E-Mail:  h.kakugawa@computer.org
 *
 *  Edition History
 *   5 Nov 1993  
 *  20 Jan 1994  Added GetOutline2().
 *   8 Mar 1994  Fixed small bugs and removed dead code
 */


/* This file is part of VFlib
 *
 * Copyright (C) 1993-1998 Hirotsugu KAKUGAWA.   All rights reserved.
 *
 * This file is part of the VFlib Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


/*
  Capabilities interpretable by compound font objects::
  "kn"  (str)  --  Kana Font Entry
  "kj"  (str)  --  Kanji Font Entry
  "sy"  (str)  --  Symbol Font Entry
 */

#include  <stdio.h> 
#include  <stdlib.h> 
#include  "config.h"
#include  "defs.h"
#include  "_VF.h"
#include  "VF.h"
#include  "VFcap.h"

struct s_font {
  int     fd; 
  char   *Kana;         /* kn */
  char   *Kanji;        /* kj */
  char   *Symbol;       /* sy */
  int    FDKana;
  int    FDKanji;
  int    FDSymbol;
};
typedef struct s_font  Font;


Private int    OpenFont();
Private int    CloseFont();
Private int    GetBitmap();
Private long*  GetOutline();
Private long*  GetOutline2();
Private int    DrawOutline();
Private int    FreeOutline();
Private int    Link();
Private int    Unlink();

Private  int ReadCapa();



Public FontObj*
CreateFont_Comp(ent)
  char *ent;
{
  Font    *font;
  FontObj *fobj;

  if ((font = (Font*) malloc(sizeof(Font))) == NULL)
    return NULL;  /* ERR: malloc err */
  font->fd = -1;
  if (ReadCapa(font, ent) < 0)
    return NULL;

  fobj = (FontObj*) malloc(sizeof(FontObj));
  fobj->ClassID     = VF_FONT_COMPOUND;
  fobj->Self        = fobj;
  fobj->LinkCount   = 0;
  fobj->OpenFont    = OpenFont;
  fobj->CloseFont   = CloseFont;
  fobj->GetBitmap   = GetBitmap;
  fobj->GetOutline  = GetOutline;
  fobj->GetOutline2 = GetOutline2;
  fobj->DrawOutline = DrawOutline;
  fobj->FreeOutline = FreeOutline;
  fobj->GetCharSet  = NULL;
  fobj->GetEnc      = NULL;
  fobj->Link        = Link;
  fobj->Unlink      = Unlink;
  fobj->Locals      = (long) font;
  return fobj;
}
       

Private int
OpenFont(obj)
  FontObj* obj;
{
  Font  *font;

  font = (Font*) obj->Locals;
  if (font->Kana != NULL)
    font->FDKana   = VF_OpenFont(font->Kana);
  if (font->Kanji != NULL)
    font->FDKanji  = VF_OpenFont(font->Kanji);
  if (font->Symbol != NULL)
    font->FDSymbol = VF_OpenFont(font->Symbol);
  return 0;
}


Private int
CloseFont(obj, fid)
  FontObj  *obj;
  int      fid;
{
  Font  *font;

  font = (Font*) obj->Locals;
  if (font->Kana != NULL)
    VF_CloseFont(font->FDKana);
  if (font->Kanji != NULL)
    VF_CloseFont(font->FDKanji);
  if (font->Symbol != NULL)
    VF_CloseFont(font->FDSymbol);
  return 0;
}

Private int
GetBitmap(obj, jiscode, w, h, bw, bo, bm_buf)
  FontObj  *obj;
  int   jiscode;
  int   w;
  int   h;
  int   bw;
  int   bo;
  char  *bm_buf;
{
  int   val = -1;
  Font  *font;
  
  font = (Font*) obj->Locals;
  if ((0x2420 <= jiscode) && (jiscode <= 0x257f)){
    if (font->Kana != NULL)
      val = VF_GetBitmap(jiscode, font->FDKana, w, h, bw, bo, bm_buf);
  } else if ((0x3020 <= jiscode) && (jiscode <= 0x742f)){ 
    if (font->Kanji != NULL)
      val = VF_GetBitmap(jiscode, font->FDKanji, w, h, bw, bo, bm_buf);
  } else {
    if (font->Symbol != NULL)
      val = VF_GetBitmap(jiscode, font->FDSymbol, w, h, bw, bo, bm_buf);
  }
  return val;
}


Private long*
GetOutline(obj, jiscode)
  FontObj  *obj;
  int      jiscode;
{
  long  *outline = NULL;
  Font  *font;
  
  font = (Font*) obj->Locals;
  if ((0x2420 <= jiscode) && (jiscode <= 0x257f)){
    if (font->Kana != NULL)
      outline = VF_GetOutline(jiscode, font->FDKana);
  } else if ((0x3020 <= jiscode) && (jiscode <= 0x742f)){ 
    if (font->Kanji != NULL)
      outline = VF_GetOutline(jiscode, font->FDKanji);
  } else {
    if (font->Symbol != NULL)
      outline = VF_GetOutline(jiscode, font->FDSymbol);
  }
  return outline;
}


Private long*
GetOutline2(obj, jiscode)
  FontObj  *obj;
  int      jiscode;
{
  long  *outline = NULL;
  Font  *font;
  
  font = (Font*) obj->Locals;
  if ((0x2420 <= jiscode) && (jiscode <= 0x257f)){
    if (font->Kana != NULL)
      outline = VF_GetOutline2(jiscode, font->FDKana);
  } else if ((0x3020 <= jiscode) && (jiscode <= 0x742f)){ 
    if (font->Kanji != NULL)
      outline = VF_GetOutline2(jiscode, font->FDKanji);
  } else {
    if (font->Symbol != NULL)
      outline = VF_GetOutline2(jiscode, font->FDSymbol);
  }
  return outline;
}


Private int
DrawOutline(obj, vfdata, w, h, bw, bo, bm_buf)
  FontObj  *obj;
  long     *vfdata;
  int   w;
  int   h;
  int   bw;
  int   bo;
  char  *bm_buf;
{
  int   jiscode;
  Font  *font;
  int   val = -1;
  
  font = (Font*) obj->Locals;
  jiscode = vfdata[0];
  if ((0x2420 <= jiscode) && (jiscode <= 0x257f)){
    if (font->Kana != NULL)
      val = VF_DrawOutline(vfdata, font->FDKana, w, h, bw, bo, bm_buf);
  } else if ((0x3020 <= jiscode) && (jiscode <= 0x742f)){ 
    if (font->Kanji != NULL)
      val = VF_DrawOutline(vfdata, font->FDKanji, w, h, bw, bo, bm_buf);
  } else {
    if (font->Symbol != NULL)
      val = VF_DrawOutline(vfdata, font->FDSymbol, w, h, bw, bo, bm_buf);
  }
  return val;
}


Private int
FreeOutline(obj, vfdata)
  FontObj  *obj;
  long*    vfdata;
{
  Font  *font;
  int   val = -1;

  font = (Font*) obj->Locals;
  if ((0x2420 <= vfdata[0]) && (vfdata[0] <= 0x257f)){
    if (font->Kana != NULL)
      val = VF_FreeOutline(vfdata, font->FDKana);
  } else if ((0x3020 <= vfdata[0]) && (vfdata[0] <= 0x742f)){ 
    if (font->Kanji != NULL)
      val = VF_FreeOutline(vfdata, font->FDKanji);
  } else {
    if (font->Symbol != NULL)
      val = VF_FreeOutline(vfdata, font->FDSymbol);
  }
  return val;
}



Private int
Link(obj)
  FontObj  *obj;
{
  obj->LinkCount = obj->LinkCount + 1;
  return obj->LinkCount;
}

Private int
Unlink(obj)
  FontObj  *obj;
{
  obj->LinkCount = obj->LinkCount - 1;
  return obj->LinkCount;
}


static int
ReadCapa(font, ent)
  Font *font;
  char *ent;
{
  char *p;

  VFC_GetEntry(ent);

  if ((p = VFC_GetString(VFCE_KANA)) == NULL)
    font->Kana = NULL;
  else {
    if ((font->Kana = malloc(strlen(p)+1)) == NULL)
      return -1;  /* ERR: malloc err */
    strcpy(font->Kana, p);
  }
  if ((p = VFC_GetString(VFCE_KANJI)) == NULL)
    font->Kanji = NULL;
  else {
    if ((font->Kanji = malloc(strlen(p)+1)) == NULL)
      return -1;  /* ERR: malloc err */
    strcpy(font->Kanji, p);
  }
  if ((p = VFC_GetString(VFCE_SYMBOL)) == NULL)
    font->Symbol = NULL;
  else {
    if ((font->Symbol = malloc(strlen(p)+1)) == NULL)
      return -1;  /* ERR: malloc err */
    strcpy(font->Symbol, p);
  }
  return 0;
}
