//=======================================================================
//	videapp.cpp:	Source for videApp class
//=======================================================================

#include "videapp.h"		// Header file
#include <v/vos.h>	// <v/vos.h>

//=========================>>> videApp::videApp <<<==========================
  videApp::videApp(char* name, int sdi, int h, int w) : vApp(name, sdi, h, w)
  {
    // Constructor

     _videCmdWin = 0;
     _videMkFile[0] = 0;
#ifdef DEVEL
     _emulation = See;
#else
     _emulation = Generic;
#endif
  }

//=========================>>> videApp::videApp <<<==========================
  videApp::~videApp()
  {
    // Desstructor
//   if (_videCmdWin)
//	delete _videCmdWin;
  }

//=====================>>> videApp::NewAppWin <<<==========================
  vWindow* videApp::NewAppWin(vWindow* win, char* name,
    int w, int h, vAppWinInfo* winInfo)
  {
    vAppWinInfo* awinfo = winInfo;
    char *appname = name;

    if (!*name)
      {
	 appname = "V Text Editor";		// Default name
      }
	
    UserDebug1(Build,"videApp::NewAppWin(%s)\n",appname);

    // Create the first window using provided CmdWindow if passed

    vWindow* cw = win;	// Pointer to instance of passed window

    if (cw != 0 && _videCmdWin == 0)
        _videCmdWin = (videCmdWindow*) cw;		// remember this first window

    if (!cw)
      {
	cw = new videCmdWindow(appname, w, h);
      }

    if (!awinfo)
	awinfo = new vAppWinInfo(appname);

    vWindow* rv = vApp::NewAppWin(cw, appname, w, h, awinfo);
    return rv;
  }

//============================>>> videApp::Exit <<<===========================
  void videApp::Exit(void)
  {
    // This is called to close all windows.

    UserDebug(Build,"videApp::Exit()\n");

    vApp::Exit();		// Default behavior
  }

//============================>>> videApp::SetMkFile <<<===========================
  void videApp::SetMkFile(char* mkf)
  {
    // update our global variable CWD and update any open windows
    vOS vos;
    if (strlen(mkf) < maxFileNameSize)
        strcpy(_videMkFile, mkf);
    else
        strcpy(_videMkFile,"Makefile");

    char temp[maxFileNameSize + 2];

    strcpy(temp,_videMkFile);
    int ix = strlen(temp);		// strip Makefile part
    while (ix > 0)
      {
        if (temp[ix] == '/' || temp[ix] == '\\')
          {
            temp[ix] = 0;
            break;
          }
        --ix;
      }

    vos.vChDir(temp);			// we will work out of that directory
    theApp->SendWindowCommandAll(m_updateMkFile, 0, C_Button);
  }

//======================>>> videApp::CloseAppWin <<<===========================
  int videApp::CloseAppWin(vWindow* win)
  {
    // This will be called BEFORE a window has been unregistered or
    // closed.  Default behavior: unregister and close the window.

    videCmdWindow* cw = (videCmdWindow*)win;
    if (cw->CheckClose())
        return vApp::CloseAppWin(win);
    else
        return 0;
  }

//=====================>>> videApp::AppCommand <<<==============================
  void videApp::AppCommand(vWindow* win, ItemVal id, ItemVal val, CmdType cType)
  {
    // Commands not processed by the window will be passed here

    UserDebug1(Build,"videApp::AppCmd(ID: %d)\n",id);
    vApp::AppCommand(win, id, val, cType);
  }

//=========================>>> videApp::KeyIn <<<==============================
  void videApp::KeyIn(vWindow* win, vKey key, unsigned int shift)
  {
    // Key strokes not processed by the window will be passed here

    vApp::KeyIn(win, key, shift);
  }

//###########################################################################

  static videApp vide_App("The V IDE for GNU g++");	// The instance of the app

//============================>>> AppMain <<<==============================
  int AppMain(int argc, char** argv)
  {
    // Use AppMain to create the main window
    videCmdWindow* cw = new videCmdWindow("No Makefile Specified", 80, 12);
    (void) theApp->NewAppWin((vWindow*) cw,
                "No Makefile Specified", 80, 12, 0);

    (((videApp*)theApp)->GetMsgWindow())->SetTitle("No Makefile Specified");
    (((videApp*)theApp)->GetMsgWindow())->AddLine("------------ V IDE ------------");
    (((videApp*)theApp)->GetMsgWindow())->SetRdOnly(1);

    if (strstr(argv[0],"vsee") != 0)
	((videApp*)theApp)->SetEmulation(See);

    if (argc > 1)
      {
 	theApp->CheckEvents();	// make sure window up
        for (int ix = 1 ; ix < argc ; ++ix)
          {
              if (argv[ix][0] == '-' || argv[ix][0] == '/')	// switch
                {
                  switch (argv[ix][1])
                    {
                      case 'e':
                      case 'E':
                        {
                          switch (argv[ix][2])
                            {
                              case 's':
                              case 'S':
                                {
                                  ((videApp*)theApp)->SetEmulation(See);
                                  break;
                                }
                              default:
                                  break;
                            }
			  break;
                        }

                      default:
                          break;
                    }
                }
              else	// a file name: project or source
                {
                }
          }
 	// cw->OpenFile(argv[1]);	// open a file in first window
      }
    else
      {

      }

    return 0;
  }
