//===============================================================
// V Shell App Generator
//
// Copyright (c) 1995,1996  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// v/srcx/vapp.cxx for more complete information about license terms.
//===============================================================

// This file has the code that generates the required files

#include "vgcode.h"

#include <string.h>
#include <fstream.h>
#include <v/vutil.h>

//=========================>>> GeneratedBy <<<==========================
  static void GeneratedBy(ofstream& of, char* comment)
  {
    char buff[40];
    char date[20];
    vGetLocalTime(buff);
    vGetLocalDate(date);
    strcat(buff," ");
    strcat(buff,date);

of << comment << "=======================================================================\n";
of << comment << "@V@:Note: This file generated by vgen V" << VGEN_VERS << " ";
of << "(" << buff << ").\n";
  }

//=========================>>> genApp <<<==========================
  int genApp(vgOptions& op)
  {
    char *bn = &op.appName[0];
    char *fn = &op.fileName[0];

    char cppName[100], hName[100];

//*****************************************************************
// Generate the app .cpp file

    strcpy(cppName,fn); strcat(cppName,"app.cpp");

    ofstream of(cppName);

    if (!of)
	return 0;

GeneratedBy(of, "//");	//=========================================================

of << "//	" << fn << "app.cpp:	Source for " << bn << "App class\n";
of << "//=======================================================================\n";
of << "\n";
of << "#include \"" << fn << "app.h\"		// Header file\n";
of << "\n";
of << "//=========================>>> " << bn << "App::" << bn << "App <<<==========================\n";
    of << "  " << bn << "App::" << bn << "App(char* name, int sdi, int h, int w) : vApp(name, sdi, h, w)\n";
of << "  {\n";
of << "    // Constructor\n";
of << "\n";
of << "   _" << bn << "CmdWin = 0;\n";
of << "  }\n";
of << "\n";
of << "//=========================>>> " << bn << "App::" << bn << "App <<<==========================\n";
of << "  " << bn << "App::~" << bn << "App()\n";
of << "  {\n";
of << "    // Destructor\n";
of << "  }\n";
of << "\n";
of << "//=====================>>> " << bn << "App::NewAppWin <<<==========================\n";
of << "  vWindow* " << bn << "App::NewAppWin(vWindow* win, char* name,\n";
of << "    int w, int h, vAppWinInfo* winInfo)\n";
of << "  {\n";
of << "    vAppWinInfo* awinfo = winInfo;\n";
of << "    char *appname = name;\n";
of << "\n";
of << "    if (!*name)\n";
of << "      {\n";
of << "	 appname = \"" << op.title << "\";		// Default name\n";
of << "      }\n";
of << "	\n";
of << "    UserDebug1(Build,\"" << bn << "App::NewAppWin(%s)\\n\",appname);\n";
of << "\n";
of << "    // Create the first window using provided CmdWindow\n";
of << "\n";
of << "    _" << bn << "CmdWin = (" << bn << "CmdWindow*) win;\n";
of << "    if (!_" << bn << "CmdWin)\n";
of << "      {\n";
of << "	_" << bn << "CmdWin = new " << bn << "CmdWindow(appname, w, h);\n";
of << "      }\n";
of << "\n";
of << "    if (!awinfo)\n";
of << "	awinfo = new vAppWinInfo(appname);\n";
of << "\n";
of << "    return vApp::NewAppWin(_" << bn << "CmdWin, appname, w, h, awinfo);\n";
of << "  }\n";
of << "\n";
of << "//============================>>> " << bn << "App::Exit <<<===========================\n";
of << "  void " << bn << "App::Exit(void)\n";
of << "  {\n";
of << "    // This is called to close all windows.\n";
of << "\n";
of << "    UserDebug(Build,\"" << bn << "App::Exit()\\n\");\n";
of << "\n";
of << "    vApp::Exit();		// Default behavior\n";
of << "  }\n";
of << "\n";
of << "//======================>>> " << bn << "App::CloseAppWin <<<===========================\n";
of << "  int " << bn << "App::CloseAppWin(vWindow* win)\n";
of << "  {\n";
of << "    // This will be called BEFORE a window has been unregistered or\n";
of << "    // closed.  Default behavior: unregister and close the window.\n";
of << "\n";
of << "    UserDebug(Build,\"" << bn << "App::CloseAppWin()\\n\");\n";
of << "\n";
of << "    return vApp::CloseAppWin(win);\n";
of << "  }\n";
of << "\n";
of << "//=====================>>> " << bn << "App::AppCommand <<<==============================\n";
of << "  void " << bn << "App::AppCommand(vWindow* win, ItemVal id, ItemVal val, CmdType cType)\n";
of << "  {\n";
of << "    // Commands not processed by the window will be passed here\n";
of << "\n";
of << "    UserDebug1(Build,\"" << bn << "App::AppCmd(ID: %d)\\n\",id);\n";
of << "    vApp::AppCommand(win, id, val, cType);\n";
of << "  }\n";
of << "\n";
of << "//=========================>>> " << bn << "App::KeyIn <<<==============================\n";
of << "  void " << bn << "App::KeyIn(vWindow* win, vKey key, unsigned int shift)\n";
of << "  {\n";
of << "    // Key strokes not processed by the window will be passed here\n";
of << "\n";
of << "    vApp::KeyIn(win, key, shift);\n";
of << "  }\n";
of << "\n";
of << "//###########################################################################\n";
of << "\n";
if (op.canvasType == NoCanvas)
    of << "  static " << bn << "App " << bn << "_App(\"" << op.title << "\",1,70,150);	// The instance of the app\n";
else if (op.winSDI)
    of << "  static " << bn << "App " << bn << "_App(\"" << op.title << "\",1);	// The instance of the app\n";
else
    of << "  static " << bn << "App " << bn << "_App(\"" << op.title << "\");	// The instance of the app\n";
of << "\n";
of << "//============================>>> AppMain <<<==============================\n";
of << "  int AppMain(int argc, char** argv)\n";
of << "  {\n";
of << "    // Use AppMain to create the main window\n";
of << "\n";
if (op.canvasType == NoCanvas)
    of << "    (void) theApp->NewAppWin(0, \"" << op.title << "\", 0, 0);\n";
else
    of << "    (void) theApp->NewAppWin(0, \"" << op.title << "\", 450, 250);\n";
of << "\n";
of << "    return 0;\n";
of << "  }\n";
     of.close();

//*****************************************************************
// Generate the app .h file

    strcpy(hName,fn); strcat(hName,"app.h");

    ofstream hf(hName);

    if (!hf)
	return 0;

GeneratedBy(of, "//");	//=========================================================
hf << "//	" << fn << "app.h:	Header for " << bn << "App class\n";
hf << "//=======================================================================\n";
hf << "\n";
hf << "#ifndef " << bn << "APP_H\n";
hf << "#define " << bn << "APP_H\n";
hf << "\n";
hf << "// Include standard V files as needed\n";
hf << "\n";
hf << "#ifdef vDEBUG\n";
hf << "#include <v/vdebug.h>\n";
hf << "#endif\n";
hf << "\n";
hf << "#include <v/vapp.h>\n";
hf << "#include <v/vawinfo.h>\n";
hf << "\n";
hf << "#include \"" << fn << "cmdw.h\"	// we use " << bn << "CommandWindow\n";
hf << "\n";
hf << "    class " << bn << "App : public vApp\n";
hf << "      {\n";
hf << "	friend int AppMain(int, char**);	// allow AppMain access\n";
hf << "\n";
hf << "      public:		//---------------------------------------- public\n";
hf << "\n";
hf << "	" << bn << "App(char* name, int sdi = 0, int h = 0, int w = 0);\n";
hf << "	virtual ~" << bn << "App();\n";
hf << "\n";
hf << "	// Routines from vApp that are normally overridden\n";
hf << "\n";
hf << "	virtual vWindow* NewAppWin(vWindow* win, char* name, int w, int h,\n";
hf << "		vAppWinInfo* winInfo);\n";
hf << "\n";
hf << "	virtual void Exit(void);\n";
hf << "\n";
hf << "	virtual int CloseAppWin(vWindow*);\n";
hf << "\n";
hf << "	virtual void AppCommand(vWindow* win, ItemVal id, ItemVal val, CmdType cType);\n";
hf << "\n";
hf << "	virtual void KeyIn(vWindow*, vKey, unsigned int);\n";
hf << "\n";
hf << "	// New routines for this particular app\n";
hf << "\n";
hf << "      protected:	//--------------------------------------- protected\n";
hf << "\n";
hf << "      private:		//--------------------------------------- private\n";
hf << "\n";
hf << "	" << bn << "CmdWindow* _" << bn << "CmdWin;		// Pointer to instance of first window\n";
hf << "\n";
hf << "      };\n";
hf << "#endif\n";
    hf.close();
    return 1;

  }

//=========================>>> genCmdw <<<==========================
  int genCmdw(vgOptions& op)
  {
    char *bn = &op.appName[0];
    char *fn = &op.fileName[0];
    char cppName[100], hName[100];

//*****************************************************************
// Generate the app .cpp file

    strcpy(cppName,fn); strcat(cppName,"cmdw.cpp");

    ofstream of(cppName);

    if (!of)
	return 0;

GeneratedBy(of, "//");	//=========================================================
of << "//	" << fn << "cmdw.cpp:	Source for " << bn << "CmdWindow class\n";
of << "//=======================================================================\n";
of << "\n";
of << "#include <v/vnotice.h>	// for vNoticeDialog\n";
of << "#include <v/vkeys.h>	// to map keys\n";
of << "\n";
of << "#include \"" << fn << "cmdw.h\"	// our header\n";
of << "\n";
of << "//	Start defines for the main window with 100\n";
of << "\n";
of << "//@V@:BeginIDs\n";
of << "    enum {\n";
of << "	m_FirstCmd = 100, // Dummy Command\n";
if (op.addDialog || op.addModal)
    of << "	m_TestDialog,	// TestDialog menu\n";
if (op.addDialog)
    of << "	m_Dialog,	// TestDialog menu\n";
if (op.addModal)
    of << "	m_ModalDialog,	// TestDialog menu\n";
if (op.addToolBar)
    of << "	btnTestTool,	// Tool Bar test\n";
if (op.addStatus)
    of << "	lblTestStat,	// Status Bar test\n";
if (op.addDate)
    of << "	lblCurTime,	// Date/Time field\n";
if (op.addTimer)
    of << "	cmdAuxTimer,	// AuxTimer\n";
of << "	blkLast		// Last item\n";
of << "      };\n";
of << "//@V@:EndIDs\n";
of << "\n";
if (op.addMenu)
  {
of << "//@V@:BeginPulldownMenu FileMenu\n";
of << "    static vMenu FileMenu[] =\n";
of << "      {\n";
of << "	{\"&New\", M_New, isSens, notChk, noKeyLbl, noKey, noSub},\n";
of << "	{\"&Open...\", M_Open, isSens, notChk, noKeyLbl, noKey, noSub},\n";
of << "	{\"&Save\", M_Save, isSens, notChk, noKeyLbl, noKey, noSub},\n";
of << "	{\"Save &as...\", M_SaveAs, isSens, notChk, noKeyLbl, noKey, noSub},\n";
of << "	{\"&Close...\", M_CloseFile, isSens, notChk, noKeyLbl, noKey, noSub},\n";
of << "	{\"-\", M_Line, notSens, notChk, noKeyLbl, noKey, noSub},\n";
of << "	{\"E&xit\", M_Exit, isSens, notChk, noKeyLbl, noKey, noSub},\n";
of << "	{NULL}\n";
of << "      };\n";
of << "//@V@:EndPulldownMenu\n";
of << "\n";
of << "//@V@:BeginPulldownMenu EditMenu\n";
of << "    static vMenu EditMenu[] =\n";
of << "      {\n";
of << "	{\"Cut  \", M_Cut, isSens, notChk, \"Ctrl-X\", 'X'-'@', noSub},\n";
of << "	{\"Copy \", M_Copy, isSens, notChk, \"Ctrl-C\", 'C'-'@', noSub},\n";
of << "	{\"Paste\", M_Paste, isSens, notChk, \"Ctrl-V\", 'V'-'@', noSub},\n";
of << "	{NULL}\n";
of << "      };\n";
of << "//@V@:EndPulldownMenu\n";
of << "\n";
if (op.addModal || op.addDialog)
  {
    of << "//@V@:BeginPulldownMenu TestDialog\n";
    of << "    static vMenu TestDialog[] =\n";
    of << "      {\n";
    if (op.addDialog)
	of << "	{\"Dialog\", m_Dialog, isSens, notChk, noKeyLbl, noKey, noSub},\n";
    if (op.addModal)
	of << "	{\"Modal Dialog\", m_ModalDialog, isSens, notChk, noKeyLbl, noKey, noSub},\n";
    of << "        {NULL}\n";
    of << "      };\n";
    of << "//@V@:EndPulldownMenu\n";
    of << "\n";
  }
of << "//@V@:BeginMenu StandardMenu\n";
of << "    static vMenu StandardMenu[] =\n";
of << "      {\n";
of << "	{\"&File\", M_File, isSens, notUsed, notUsed, noKey, &FileMenu[0]},\n";
of << "	{\"&Edit\", M_Edit, isSens, notUsed, notUsed, noKey, &EditMenu[0]},\n";
if (op.addDialog || op.addModal)
    of << "	{\"&TestDialog\", m_TestDialog, isSens, notUsed, notUsed, noKey, &TestDialog[0]},\n";
of << "	{NULL}\n";
of << "      };\n";
of << "//@V@:EndMenu\n\n";
  }
if (op.addToolBar)
  {
    of << "//@V@:BeginCmdPane ToolBar\n";
    of << "    static CommandObject ToolBar[] =\n";
    of << "      {\n";
    if (!op.addMenu)
        of << "	{C_Button,M_Exit,0,\"Exit\",NoList,CA_None,isSens,NoFrame,0,0},\n";
    of << "	{C_Button,btnTestTool,0,\"Test\",NoList,CA_None,isSens,NoFrame,0,0},\n";
    of << "	{C_EndOfList,0,0,0,0,CA_None,0,0,0}\n";
    of << "      };\n";
    of << "//@V@:EndCmdPane\n\n";
  }
if (op.addStatus)
  {
    of << "//@V@:BeginStatPane StatBar\n";
    of << "    static vStatus StatBar[] =\n";
    of << "      {\n";
    of << "	{\"" << op.title << "\", lblTestStat, CA_NoBorder, isSens, 0},\n";
    if (op.addDate)
	of << "	{\" 00:00:00 AM  dd mmm yyyy \",lblCurTime, CA_None, isSens, 0},\n";
    of << "	{0,0,0,0,0}\n";
    of << "      };\n";
    of << "//@V@:EndStatPane\n\n";
  }
if (op.addDate)
  {
    of << "//====================>>> " << bn <<"Timer::TimerTick <<<====================\n";
    of << "  void " << bn << "Timer::TimerTick()\n";
    of << "  {\n";
    of << "	cmdw->WindowCommand(lblCurTime, lblCurTime, C_Button); // update clock\n";
    of << "  }\n\n";
  }
if (op.addTimer)
  {
    of << "//====================>>> " << bn <<"AuxTimer::TimerTick <<<====================\n";
    of << "  void " << bn << "AuxTimer::TimerTick()\n";
    of << "  {\n";
    of << "	cmdw->WindowCommand(cmdAuxTimer, cmdAuxTimer, C_Button); // update clock\n";
    of << "  }\n\n";
  }
of << "//====================>>> " << bn << "CmdWindow::" << bn << "CmdWindow <<<====================\n";
of << "  " << bn << "CmdWindow::" << bn << "CmdWindow(char* name, int width, int height) :\n";
of << "    vCmdWindow(name, width, height)\n";
of << "  {\n";
of << "    UserDebug1(Constructor,\"" << bn << "CmdWindow::" << bn << "CmdWindow(%s) Constructor\\n\",name)\n";
of << "\n";
if (op.addMenu)
  {
    of << "    // The Menu Bar\n";
    of << "    " << bn << "Menu = new vMenuPane(StandardMenu);\n";
    of << "    AddPane(" << bn << "Menu);\n\n";
  }
if (op.addToolBar)
  {
    of << "    // The Command Pane\n";
    of << "    " << bn << "CmdPane = new vCommandPane(ToolBar);\n";
    of << "    AddPane(" << bn << "CmdPane);\n";
    of << "\n";
  }
of << "    // The Canvas\n";

if (op.canvasType != NoCanvas)
  {
    if (op.canvasType == Canvas)
	of << "    " << bn << "Canvas = new " << bn << "CanvasPane;\n";
    else if (op.canvasType == Text)
	of << "    " << bn << "Canvas = new " << bn << "TextCanvasPane;\n";
    else if (op.canvasType == OpenGL)
	of << "    " << bn << "Canvas = new " << bn << "OGLCanvasPane;\n";
    of << "    AddPane(" << bn << "Canvas);\n\n";
  }

if (op.addStatus)
  {
    of << "    // The Status Bar\n";
    of << "    " << bn << "Status = new vStatusPane(StatBar);\n";
    of << "    AddPane(" << bn << "Status);\n\n";
  }
if (op.addDate)
  {
    of << "    _timer = new " << bn << "Timer(this);		// create timer\n";
    of << "    _timer->TimerSet(1000);		// 1 second intervals\n";
  }
if (op.addTimer)
  {
    of << "    _auxTimer = new " << bn << "AuxTimer(this);	// create aux timer\n";
    of << "    _auxTimer->TimerSet(500);		// 1/2 second intervals\n";
  }
of << "    // Associated dialogs\n";
of << "\n";
if (op.addDialog)
    of << "    " << bn << "Dlg = new " << bn << "Dialog(this,name);\n";
if (op.addModal)
    of << "    " << bn << "MDlg = new " << bn << "ModalDialog(this,name);\n";
of << "    \n";
of << "    // Show Window\n";
of << "\n";
of << "    ShowWindow();\n";
if (op.addDate)
    of << "    WindowCommand(lblCurTime,lblCurTime,C_Button);	// update clock\n";
if (op.addTimer)
    of << "    WindowCommand(cmdAuxTimer,cmdAuxTimer,C_Button);	// update clock\n";
if (op.vScroll)
    of << "    " << bn << "Canvas->ShowVScroll(1);	// Show Vert Scroll\n";
if (op.hScroll)
    of << "    " << bn << "Canvas->ShowHScroll(1);	// Show Horiz Scroll\n";
of << "  }\n";
of << "\n";
of << "//====================>>> " << bn << "CmdWindow::~" << bn << "CmdWindow <<<====================\n";
of << "  " << bn << "CmdWindow::~" << bn << "CmdWindow()\n";
of << "  {\n";
of << "    UserDebug(Destructor,\"" << bn << "CmdWindow::~" << bn << "CmdWindow() destructor\\n\")\n";
of << "\n";
of << "    // Now put a delete for each new in the constructor.\n";
of << "\n";
if (op.addMenu)
  {
    of << "    delete " << bn << "Menu;\n";
  }
if (op.canvasType != NoCanvas)
  {
    of << "    delete " << bn << "Canvas;\n";
  }
if (op.addToolBar)
    of << "    delete " << bn << "CmdPane;\n";
if (op.addStatus)
    of << "    delete " << bn << "Status;\n";
if (op.addDate)
  {
    of << "    _timer->TimerStop();	// end it\n";
    of << "    delete _timer;		// free it\n";
  }
if (op.addTimer)
  {
    of << "    _auxTimer->TimerStop();	// end it\n";
    of << "    delete _auxTimer;	// free it\n";
  }
if (op.addDialog)
    of << "    delete " << bn << "Dlg;\n";
if (op.addModal)
    of << "    delete " << bn << "MDlg;\n";
of << "  }\n";
of << "\n";
of << "//====================>>> " << bn << "CmdWindow::KeyIn <<<====================\n";
of << "  void " << bn << "CmdWindow::KeyIn(vKey keysym, unsigned int shift)\n";
of << "  {\n";
of << "    vCmdWindow::KeyIn(keysym, shift);\n";
of << "  }\n";
of << "\n";
of << "//====================>>> " << bn << "CmdWindow::WindowCommand <<<====================\n";
of << "  void " << bn << "CmdWindow::WindowCommand(ItemVal id, ItemVal val, CmdType cType)\n";
of << "  {\n";
of << "    // Default: route menu and toolbar commands here\n";
of << "\n";
of << "\n";
of << "    UserDebug1(CmdEvents,\"" << bn << "CmdWindow:WindowCommand(%d)\\n\",id)\n";
of << "\n";
of << "    switch (id)\n";
of << "      {\n";
if (op.addMenu)
{
of << "	//@V@:Case M_New\n";
of << "	case M_New:\n";
of << "	  {\n";
of << "	    vNoticeDialog note(this);\n";
of << "	    note.Notice(\"New\");\n";
of << "	    break;\n";
of << "	  }	//@V@:EndCase\n";
of << "\n";
of << "	//@V@:Case M_Open\n";
of << "	case M_Open:\n";
of << "	  {\n";
of << "	    vNoticeDialog note(this);\n";
of << "	    note.Notice(\"Open\");\n";
of << "	    break;\n";
of << "	  }	//@V@:EndCase\n";
of << "\n";
of << "	//@V@:Case M_Save\n";
of << "	case M_Save:\n";
of << "	  {\n";
of << "	    vNoticeDialog note(this);\n";
of << "	    note.Notice(\"Save\");\n";
of << "	    break;\n";
of << "	  }	//@V@:EndCase\n";
of << "\n";
of << "	//@V@:Case M_SaveAs\n";
of << "	case M_SaveAs:\n";
of << "	  {\n";
of << "	    vNoticeDialog note(this);\n";
of << "	    note.Notice(\"Save As\");\n";
of << "	    break;\n";
of << "	  }	//@V@:EndCase\n";
of << "\n";
of << "	//@V@:Case M_CloseFile\n";
of << "	case M_CloseFile:\n";
of << "	  {\n";
of << "	    vNoticeDialog note(this);\n";
of << "	    note.Notice(\"Close File\");\n";
of << "	    break;\n";
of << "	  }	//@V@:EndCase\n";
of << "\n";
}
of << "	//@V@:Case M_Exit\n";
of << "	case M_Exit:\n";
of << "	  {\n";
of << "	    theApp->Exit();\n";
of << "	    break;\n";
of << "	  }	//@V@:EndCase\n";
of << "\n";
if (op.addMenu)
{
of << "	//@V@:Case M_Cut\n";
of << "	case M_Cut:\n";
of << "	  {\n";
of << "	    vNoticeDialog note(this);\n";
of << "	    note.Notice(\"Cut\");\n";
of << "	    break;\n";
of << "	  }	//@V@:EndCase\n";
of << "\n";
of << "	//@V@:Case M_Copy\n";
of << "	case M_Copy:\n";
of << "	  {\n";
of << "	    vNoticeDialog note(this);\n";
of << "	    note.Notice(\"Copy\");\n";
of << "	    break;\n";
of << "	  }	//@V@:EndCase\n";
of << "\n";
of << "	//@V@:Case M_Paste\n";
of << "	case M_Paste:\n";
of << "	  {\n";
of << "	    vNoticeDialog note(this);\n";
of << "	    note.Notice(\"Paste\");\n";
of << "	    break;\n";
of << "	  }	//@V@:EndCase\n\n";
}
if (op.addDialog)
  {
    of << "	//@V@:Case m_Dialog\n";
    of << "	case m_Dialog:\n";
    of << "	  {\n";
    of << "	    if (!" << bn << "Dlg->IsDisplayed())\n";
    of << "		" << bn << "Dlg->ShowDialog(\"Sample Modeless Dialog\");\n";
    of << "	    break;\n";
    of << "	  }	//@V@:EndCase\n";
    of << "\n\n";
    }
if (op.addModal)
  {
    of << "	//@V@:Case m_ModalDialog\n";
    of << "	case m_ModalDialog:\n";
    of << "	  {\n";
    of << "	    ItemVal rval = " << bn << "MDlg->" << bn << "Action(\"Sample Modal Dialog\");\n";
    of << "	    break;\n";
    of << "	  }	//@V@:EndCase\n";
    of << "\n\n";
  }
if (op.addToolBar)
  {
    of << "	//@V@:Case btnTestTool\n";
    of << "	case btnTestTool:\n";
    of << "	  {\n";
    of << "	    vNoticeDialog note(this);\n";
    of << "	    note.Notice(\"Tool Bar Test\");\n";
    of << "	    break;\n";
    of << "	  }	//@V@:EndCase\n";
    of << "\n\n";
  }
if (op.addTimer)
  {
    of << "	//@V@:Case auxTimer\n";
    of << "	case cmdAuxTimer:	// Event from aux timer\n";
    of << "	  {\n";
if (op.canvasType == OpenGL)
	of << "	    " << bn << "Canvas->TimerAnimate();\n";
    of << "	    break;\n";
    of << "	  }	//@V@:EndCase\n";
  }
if (op.addDate)
  {
    of << "	case lblCurTime:	// Update time on status bar\n";
    of << "          {\n";
    of << "            char buff[40];\n";
    of << "            char date[20];\n";
    of << "            vGetLocalTime(buff);\n";
    of << "	    vGetLocalDate(date);\n";
    of << "	    strcat(buff,\"  \");\n";
    of << "            strcat(buff,date);\n";
    of << "	    SetString(lblCurTime,buff);\n";
    of << "          }\n\n";
  }
of << "	default:		// route unhandled commands up\n";
of << "	  {\n";
of << "	    vCmdWindow::WindowCommand(id, val, cType);\n";
of << "	    break;\n";
of << "	  }\n";
of << "      }\n";
of << "  }\n";
   of.close();

//*****************************************************************
// Generate the cmdw .h file

    strcpy(hName,fn); strcat(hName,"cmdw.h");

    ofstream hf(hName);

    if (!hf)
	return 0;

GeneratedBy(of, "//");	//=========================================================
hf << "//	" << fn << "cmdw.h:	Header for " << bn << "cmdw class\n";
hf << "//=======================================================================\n";
hf << "\n";
hf << "#ifndef " << bn << "CMDW_H\n";
hf << "#define " << bn << "CMDW_H\n";
hf << "\n";
hf << "#include <v/vcmdwin.h>	// So we can use vCmdWindow\n";
if (op.addMenu)
    hf << "#include <v/vmenu.h>	// For the menu pane\n";
hf << "#include <v/vutil.h>	// For V Utilities\n";
if (op.addToolBar)
    hf << "#include <v/vcmdpane.h> // command pane\n";
if (op.addStatus)
    hf << "#include <v/vstatusp.h>	// For the status pane\n";
if (op.addDate || op.addTimer)
    hf << "#include <v/vtimer.h>	// Timer\n";
hf << "\n";
hf << "#ifdef vDEBUG\n";
hf << "#include <v/vdebug.h>\n";
hf << "#endif\n";
hf << "\n";
if (op.canvasType == Canvas)
     hf << "#include \"" << fn << "cnv.h\"	// " << bn << "CanvasPane\n";
else if (op.canvasType == Text)
     hf << "#include \"" << fn << "cnv.h\"	// " << bn << "TextCanvasPane\n";
else if (op.canvasType == OpenGL)
     hf << "#include \"" << fn << "cnv.h\"	// " << bn << "OGLCanvasPane\n";
if (op.addDialog)
    hf << "#include \"" << fn << "dlg.h\"	// " << bn << "Dialog\n";
if (op.addModal)
    hf << "#include \"" << fn << "mdlg.h\"	// " << bn << "ModalDialog\n";
if (op.addDate || op.addTimer)		// using timers
hf << "\n    class " << bn << "CmdWindow;\n";
if (op.addDate)			// Add a time/date to status bar
  {
hf << "\n    class " << bn << "Timer : public vTimer\n";
hf << "      {\n";
hf << "      public:		//---------------------------------------- public\n";
hf << "	" << bn << "Timer(" << bn << "CmdWindow* cw) { cmdw = cw; }\n";
hf << "	~" << bn << "Timer() {}\n";
hf << "	virtual void TimerTick();\n";
hf << "      private:		//--------------------------------------- private\n";
hf << "	" << bn << "CmdWindow* cmdw;\n";
hf << "      };\n";
  }
if (op.addTimer)		// add aux timer
  {
hf << "\n    class " << bn << "AuxTimer : public vTimer\n";
hf << "      {\n";
hf << "      public:		//---------------------------------------- public\n";
hf << "	" << bn << "AuxTimer(" << bn << "CmdWindow* cw) { cmdw = cw; }\n";
hf << "	~" << bn << "AuxTimer() {}\n";
hf << "	virtual void TimerTick();\n";
hf << "      private:		//--------------------------------------- private\n";
hf << "	" << bn << "CmdWindow* cmdw;\n";
hf << "      };\n";
  }
hf << "\n    class " << bn << "CmdWindow : public vCmdWindow\n";
hf << "      {\n";
hf << "	friend int AppMain(int, char**);	// allow AppMain access\n";
hf << "\n";
hf << "      public:		//---------------------------------------- public\n";
hf << "	" << bn << "CmdWindow(char*, int, int);\n";
hf << "	virtual ~" << bn << "CmdWindow();\n";
hf << "	virtual void WindowCommand(ItemVal id, ItemVal val, CmdType cType);\n";
hf << "	virtual void KeyIn(vKey keysym, unsigned int shift);\n";
if (op.addTimer)			// Add aux timer
    hf << "	" << bn << "AuxTimer* Get" << bn 
       << "AuxTimer() {return _auxTimer;}// Aux Timer\n";
hf << "\n";
hf << "      protected:	//--------------------------------------- protected\n";
hf << "\n";
hf << "      private:		//--------------------------------------- private\n";
hf << "\n";
hf << "	// Standard elements\n";
if (op.addMenu)
  {
hf << "	vMenuPane* " << bn << "Menu;		// For the menu bar\n";
  }
if (op.canvasType == Canvas)
    hf << "	" << bn << "CanvasPane* " << bn << "Canvas;		// For the canvas\n";
else if (op.canvasType == Text)
    hf << "	" << bn << "TextCanvasPane* " << bn << "Canvas;		// For the canvas\n";
else if (op.canvasType == OpenGL)
    hf << "	" << bn << "OGLCanvasPane* " << bn << "Canvas;		// For the canvas\n";
if (op.addToolBar)
    hf << "	vCommandPane* " << bn << "CmdPane;	// for the command pane\n";
if (op.addStatus)
    hf << "	vStatusPane* " << bn << "Status;		// For the status bar\n";
if (op.addDate)			// Add a time/date to status bar
    hf << "	" << bn << "Timer* _timer;	// Timer for Date/Time\n";
if (op.addTimer)			// Add aux timer
    hf << "	" << bn << "AuxTimer* _auxTimer;	// Aux Timer\n";
hf << "\n";
hf << "	// Dialogs associated with CmdWindow\n";
hf << "\n";
if (op.addDialog)
    hf << "	" << bn << "Dialog* " << bn << "Dlg;\n";
if (op.addModal)
    hf << "	" << bn << "ModalDialog* " << bn << "MDlg;\n";
hf << "\n";
hf << "      };\n";
hf << "#endif\n";
   hf.close();
   return 1;

  }

//=========================>>> genCnv <<<==========================
  int genCnv(vgOptions& op)
  {
    char *bn = &op.appName[0];
    char *fn = &op.fileName[0];
    char cppName[100], hName[100];

//*****************************************************************
// Generate the canvas .cpp file

    strcpy(cppName,fn); strcat(cppName,"cnv.cpp");

    ofstream of(cppName);

    if (!of)
	return 0;
//---->
GeneratedBy(of, "//");	//=========================================================
of << "//	" << fn << "cnv.cpp:	Source for " << bn << "CanvasPane class\n";
of << "//=======================================================================\n";
of << "\n";
of << "#include \"" << fn << "cnv.h\"\n";
of << "\n";
of << "//===================>>> " << bn << "CanvasPane::" << bn << "CanvasPane <<<====================\n";
of << "  " << bn << "CanvasPane::" << bn << "CanvasPane()\n";
of << "  {\n";
of << "  }\n";
of << "\n";
of << "//===================>>> " << bn << "CanvasPane::~" << bn << "CanvasPane <<<====================\n";
of << "  " << bn << "CanvasPane::~" << bn << "CanvasPane()\n";
of << "  {\n";
of << "  }\n";
of << "\n";
of << "//======================>>> " << bn << "CanvasPane::HPage <<<========================\n";
of << "  void " << bn << "CanvasPane::HPage(int shown, int top)\n";
of << "  {\n";
of << "    vCanvasPane::HPage(shown, top);\n";
of << "  }\n";
of << "\n";
of << "//======================>>> " << bn << "CanvasPane::VPage <<<========================\n";
of << "  void " << bn << "CanvasPane::VPage(int shown, int top)\n";
of << "  {\n";
of << "    vCanvasPane::VPage(shown, top);\n";
of << "  }\n";
of << "\n";
of << "//=======================>>> " << bn << "CanvasPane::HScroll <<<======================\n";
of << "  void " << bn << "CanvasPane::HScroll(int step)\n";
of << "  {\n";
of << "    vCanvasPane::HScroll(step);\n";
of << "  }\n";
of << "\n";
of << "//======================>>> " << bn << "CanvasPane::VScroll <<<======================\n";
of << "  void " << bn << "CanvasPane::VScroll(int step)\n";
of << "  {\n";
of << "    vCanvasPane::VScroll(step);\n";
of << "  }\n";
of << "\n";
of << "//======================>>> " << bn << "CanvasPane::MouseDown <<<======================\n";
of << "  void " << bn << "CanvasPane::MouseDown(int X, int Y, int button)\n";
of << "  {\n";
of << "    vCanvasPane::MouseDown(X,Y,button);\n";
of << "  }\n";
of << "\n";
of << "//========================>>> " << bn << "CanvasPane::MouseUp <<<======================\n";
of << "  void " << bn << "CanvasPane::MouseUp(int X, int Y, int button)\n";
of << "  {\n";
of << "    vCanvasPane::MouseUp(X,Y,button);\n";
of << "  }\n";
of << "\n";
of << "//======================>>> " << bn << "CanvasPane::MouseMove <<<======================\n";
of << "  void " << bn << "CanvasPane::MouseMove(int x, int y, int button)\n";
of << "  {\n";
of << "    vCanvasPane::MouseMove(x,y,button);\n";
of << "  }\n";
of << "\n";
of << "//=========================>>> " << bn << "CanvasPane::Redraw <<<======================\n";
of << "  void " << bn << "CanvasPane::Redraw(int x, int y, int w, int h)\n";
of << "  {\n";
of << "    vCanvasPane::Redraw(x,y,w,h);\n";
of << "  }\n";
of << "\n";
of << "//======================>>> " << bn << "CanvasPane::Resize <<<======================\n";
of << "  void " << bn << "CanvasPane::Resize(int w, int h)\n";
of << "  {\n";
of << "    vCanvasPane::Resize(w,h);\n";
of << "  }\n";
of << "\n";

   of.close();

//*****************************************************************
// Generate the canvas .h file

    strcpy(hName,fn); strcat(hName,"cnv.h");

    ofstream hf(hName);

    if (!hf)
	return 0;

//---->
GeneratedBy(of, "//");	//=========================================================
hf << "//	" << fn << "cnv.h:	Header for " << bn << "CanvasPane class\n";
hf << "//=======================================================================\n";
hf << "\n";
hf << "#ifndef " << bn << "CNV_H\n";
hf << "#define " << bn << "CNV_H\n";
hf << "\n";
hf << "#include <v/vcanvas.h>\n";
hf << "\n";
hf << "    class " << bn << "CanvasPane : public vCanvasPane\n";
hf << "      {\n";
hf << "      public:		//---------------------------------------- public\n";
hf << "	" << bn << "CanvasPane();\n";
hf << "	virtual ~" << bn << "CanvasPane();\n";
hf << "\n";
hf << "	// Scrolling\n";
hf << "	virtual void HPage(int shown, int top);\n";
hf << "	virtual void VPage(int shown, int top);\n";
hf << "\n";
hf << "	virtual void HScroll(int step);\n";
hf << "	virtual void VScroll(int step);\n";
hf << "\n";
hf << "	// Events\n";
hf << "	virtual void MouseDown(int x, int y, int button);\n";
hf << "	virtual void MouseUp(int x, int y, int button);\n";
hf << "	virtual void MouseMove(int x, int y, int button);\n";
hf << "\n";
hf << "	virtual void Redraw(int x, int y, int width, int height);\n";
hf << "	virtual void Resize(int newW, int newH);\n";
hf << "\n";
hf << "      protected:	//--------------------------------------- protected\n";
hf << "\n";
hf << "      private:		//--------------------------------------- private\n";
hf << "      };\n";
hf << "#endif\n";

   hf.close();
   return 1;

  }

//=========================>>> genOGLCnv <<<==========================
  int genOGLCnv(vgOptions& op)
  {
    char *bn = &op.appName[0];
    char *fn = &op.fileName[0];
    char cppName[100], hName[100];

//*****************************************************************
// Generate the canvas .cpp file

    strcpy(cppName,fn); strcat(cppName,"cnv.cpp");

    ofstream of(cppName);

    if (!of)
	return 0;
//---->
GeneratedBy(of, "//");	//=========================================================
of << "//	" << fn << "cnv.cpp:	Source for " << bn << "OGLCanvasPane class\n";
of << "//=======================================================================\n";
of << "\n";
of << "#include \"" << fn << "cnv.h\"\n";
of << "\n";
of << "//===================>>> " << bn << "OGLCanvasPane::" << bn << "OGLCanvasPane <<<====================\n";
of << "  " << bn << "OGLCanvasPane::" << bn <<
       "OGLCanvasPane(unsigned int vGLmode, PaneType pt)\n";
of << "  {\n";
of << "    initDone = 0;\n";
of << "  }\n";
of << "\n";
of << "//===================>>> " << bn << "OGLCanvasPane::~" << bn << "OGLCanvasPane <<<====================\n";
of << "  " << bn << "OGLCanvasPane::~" << bn << "OGLCanvasPane()\n";
of << "  {\n";
of << "  }\n";
of << "\n";
if (op.addTimer)
  {
of << "//======================>>> " << bn << "OGLCanvasPane::TimerAnimate <<<========================\n";
of << "  void " << bn << "OGLCanvasPane::TimerAnimate(void)\n";
of << "  {\n";
of << "    // **** Called by CmdWindow AuxTimer for animation.\n\n";
of << "  }\n";
  }
of << "//======================>>> " << bn << "OGLCanvasPane::graphicsInit <<<========================\n";
of << "  void " << bn << "OGLCanvasPane::graphicsInit(void)\n";
of << "  {\n";
of << "    vBaseGLCanvasPane::graphicsInit();	// Always call the superclass first!\n\n";
of << "    // **** Your OpenGL initialization code goes here!\n\n";
of << "    initDone = 1;\n";
of << "  }\n";
of << "//======================>>> " << bn << "OGLCanvasPane::HPage <<<========================\n";
of << "  void " << bn << "OGLCanvasPane::HPage(int shown, int top)\n";
of << "  {\n";
of << "    vBaseGLCanvasPane::HPage(shown, top);\n";
of << "  }\n";
of << "\n";
of << "//======================>>> " << bn << "OGLCanvasPane::VPage <<<========================\n";
of << "  void " << bn << "OGLCanvasPane::VPage(int shown, int top)\n";
of << "  {\n";
of << "    vBaseGLCanvasPane::VPage(shown, top);\n";
of << "  }\n";
of << "\n";
of << "//=======================>>> " << bn << "OGLCanvasPane::HScroll <<<======================\n";
of << "  void " << bn << "OGLCanvasPane::HScroll(int step)\n";
of << "  {\n";
of << "    vBaseGLCanvasPane::HScroll(step);\n";
of << "  }\n";
of << "\n";
of << "//======================>>> " << bn << "OGLCanvasPane::VScroll <<<======================\n";
of << "  void " << bn << "OGLCanvasPane::VScroll(int step)\n";
of << "  {\n";
of << "    vBaseGLCanvasPane::VScroll(step);\n";
of << "  }\n";
of << "\n";
of << "//======================>>> " << bn << "OGLCanvasPane::MouseDown <<<======================\n";
of << "  void " << bn << "OGLCanvasPane::MouseDown(int X, int Y, int button)\n";
of << "  {\n";
of << "    vBaseGLCanvasPane::MouseDown(X,Y,button);\n";
of << "  }\n";
of << "\n";
of << "//========================>>> " << bn << "OGLCanvasPane::MouseUp <<<======================\n";
of << "  void " << bn << "OGLCanvasPane::MouseUp(int X, int Y, int button)\n";
of << "  {\n";
of << "    vBaseGLCanvasPane::MouseUp(X,Y,button);\n";
of << "  }\n";
of << "\n";
of << "//======================>>> " << bn << "CanvasPane::MouseMove <<<======================\n";
of << "  void " << bn << "OGLCanvasPane::MouseMove(int x, int y, int button)\n";
of << "  {\n";
of << "    vBaseGLCanvasPane::MouseMove(x,y,button);\n";
of << "  }\n";
of << "\n";
of << "//=========================>>> " << bn << "OGLCanvasPane::Redraw <<<======================\n";
of << "  void " << bn << "OGLCanvasPane::Redraw(int x, int y, int w, int h)\n";
of << "  {\n    static int inRedraw = 0;\n\n";
of << "    if (inRedraw || !initDone)  // Don't draw until initialized\n";
of << "        return;\n\n";
of << "    inRedraw = 1;  // Don't allow recursive redraws.\n\n";
of << "    vglMakeCurrent();  // Typically done here\n\n";
of << "    // *** Your drawing code typically goes here. You may\n";
of << "    // insert it here, or just call a drawing routine.\n\n";
of << "    vglFlush();  // After you draw, typically flush\n\n";
of << "    inRedraw = 0;  // Out of Redraw\n\n";
of << "  }\n";
of << "\n";
of << "//======================>>> " << bn << "OGLCanvasPane::Resize <<<======================\n";
of << "  void " << bn << "OGLCanvasPane::Resize(int w, int h)\n";
of << "  {\n";
of << "    vBaseGLCanvasPane::Resize(w,h);\n";
of << "  }\n";
of << "\n";

   of.close();

//*****************************************************************
// Generate the canvas .h file

    strcpy(hName,fn); strcat(hName,"cnv.h");

    ofstream hf(hName);

    if (!hf)
	return 0;

//---->
GeneratedBy(of, "//");	//=========================================================
hf << "//	" << fn << "cnv.h:	Header for " << bn << "OGLCanvasPane class\n";
hf << "//=======================================================================\n";
hf << "\n";
hf << "#ifndef " << bn << "CNV_H\n";
hf << "#define " << bn << "CNV_H\n";
hf << "\n";
hf << "#include <v/vbglcnv.h>\n";
hf << "\n";
hf << "    class " << bn << "OGLCanvasPane : public vBaseGLCanvasPane\n";
hf << "      {\n";
hf << "      public:		//---------------------------------------- public\n";
hf << "	" << bn << "OGLCanvasPane(unsigned int vGLmode = vGL_Default, PaneType pt = P_Canvas);\n";
hf << "	virtual ~" << bn << "OGLCanvasPane();\n";
hf << "\n";
hf << "	virtual void graphicsInit(void);\n\n";
if (op.addTimer)
hf << "  void TimerAnimate(void);	// for AuxTimer animation\n";
hf << "	// Scrolling\n";
hf << "	virtual void HPage(int shown, int top);\n";
hf << "	virtual void VPage(int shown, int top);\n";
hf << "\n";
hf << "	virtual void HScroll(int step);\n";
hf << "	virtual void VScroll(int step);\n";
hf << "\n";
hf << "	// Events\n";
hf << "	virtual void MouseDown(int x, int y, int button);\n";
hf << "	virtual void MouseUp(int x, int y, int button);\n";
hf << "	virtual void MouseMove(int x, int y, int button);\n";
hf << "\n";
hf << "	virtual void Redraw(int x, int y, int width, int height);\n";
hf << "	virtual void Resize(int newW, int newH);\n";
hf << "\n";
hf << "      protected:	//--------------------------------------- protected\n";
hf << "\n";
hf << "      private:		//--------------------------------------- private\n";
hf << "        int initDone;\n";
hf << "      };\n";
hf << "#endif\n";

   hf.close();
   return 1;

  }

//=========================>>> genTextCnv <<<==========================
  int genTextCnv(vgOptions& op)
  {
    char *bn = &op.appName[0];
    char *fn = &op.fileName[0];
    char cppName[100], hName[100];

//*****************************************************************
// Generate the canvas .cpp file

    strcpy(cppName,fn); strcat(cppName,"cnv.cpp");

    ofstream of(cppName);

    if (!of)
	return 0;
//---->
GeneratedBy(of, "//");	//=========================================================
of << "//	" << fn << "cnv.cpp:	Source for " << bn << "TextCanvasPane class\n";
of << "//=======================================================================\n";
of << "\n";
of << "#include \"" << fn << "cnv.h\"\n";
of << "\n";
of << "//=================>>> " << bn << "TextCanvasPane::" << bn << "TextCanvasPane <<<================\n";
of << "  " << bn << "TextCanvasPane::" << bn << "TextCanvasPane()\n";
of << "  {\n";
of << "  }\n";
of << "\n";
of << "//=================>>> " << bn << "TextCanvasPane::~" << bn << "TextCanvasPane <<<================\n";
of << "  " << bn << "TextCanvasPane::~" << bn << "TextCanvasPane()\n";
of << "  {\n";
of << "  }\n";
of << "\n";
of << "//=====================>>> " << bn << "TextCanvasPane::HPage <<<========================\n";
of << "  void " << bn << "TextCanvasPane::HPage(int shown, int top)\n";
of << "  {\n";
of << "    vTextCanvasPane::HPage(shown, top);\n";
of << "  }\n";
of << "\n";
of << "//=====================>>> " << bn << "TextCanvasPane::VPage <<<========================\n";
of << "  void " << bn << "TextCanvasPane::VPage(int shown, int top)\n";
of << "  {\n";
of << "    vTextCanvasPane::VPage(shown, top);\n";
of << "  }\n";
of << "\n";
of << "//====================>>> " << bn << "TextCanvasPane::HScroll <<<======================\n";
of << "  void " << bn << "TextCanvasPane::HScroll(int step)\n";
of << "  {\n";
of << "    vTextCanvasPane::HScroll(step);\n";
of << "  }\n";
of << "\n";
of << "//====================>>> " << bn << "TextCanvasPane::VScroll <<<======================\n";
of << "  void " << bn << "TextCanvasPane::VScroll(int step)\n";
of << "  {\n";
of << "    vTextCanvasPane::VScroll(step);\n";
of << "  }\n";
of << "\n";
of << "//===================>>> " << bn << "TextCanvasPane::FontChanged <<<==================\n";
of << "  void " << bn << "TextCanvasPane::FontChanged(vFont& newFont)\n";
of << "  {\n";
of << "    vTextCanvasPane::FontChanged(newFont);\n";
of << "  }\n";
of << "\n";
of << "//===================>>> " << bn << "TextCanvasPane::TextMouseDown <<<==================\n";
of << "  void " << bn << "TextCanvasPane::TextMouseDown(int row, int col, int button)\n";
of << "  {\n";
of << "    vTextCanvasPane::TextMouseDown(row,col,button);\n";
of << "  }\n";
of << "\n";
of << "//======================>>> " << bn << "TextCanvasPane::TextMouseUp <<<==================\n";
of << "  void " << bn << "TextCanvasPane::TextMouseUp(int row, int col, int button)\n";
of << "  {\n";
of << "    vTextCanvasPane::TextMouseUp(row,col,button);\n";
of << "  }\n";
of << "\n";
of << "//======================>>> " << bn << "TextCanvasPane::TextMouseMove <<<=================\n";
of << "  void " << bn << "TextCanvasPane::TextMouseMove(int row, int col, int button)\n";
of << "  {\n";
of << "    vTextCanvasPane::TextMouseMove(row,col,button);\n";
of << "  }\n";
of << "\n";
of << "//=========================>>> " << bn << "TextCanvasPane::Redraw <<<======================\n";
of << "  void " << bn << "TextCanvasPane::Redraw(int x, int y, int w, int h)\n";
of << "  {\n";
of << "    vTextCanvasPane::Redraw(x,y,w,h);\n";
of << "  }\n";
of << "\n";
of << "//======================>>> " << bn << "TextCanvasPane::ResizeText <<<======================\n";
of << "  void " << bn << "TextCanvasPane::ResizeText(const int rows, const int cols)\n";
of << "  {\n";
of << "    static int first = 1;\n";
of << "    if (first)\n";
of << "      {\n";
of << "	first = 0; DrawText(\"This is a Text Canvas\\n\");\n";
of << "      }\n";
of << "    vTextCanvasPane::ResizeText(rows,cols);\n";
of << "  }\n";
of << "\n";
   of.close();

//*****************************************************************
// Generate the canvas .h file

    strcpy(hName,fn); strcat(hName,"cnv.h");

    ofstream hf(hName);

    if (!hf)
	return 0;

//---->
GeneratedBy(of, "//");	//=========================================================
hf << "//	" << fn << "cnv.h:	Header for " << bn << "TextCanvasPane class\n";
hf << "//=======================================================================\n";
hf << "#ifndef " << bn << "TCNV_H\n";
hf << "#define " << bn << "TCNV_H\n";
hf << "\n";
hf << "#include <v/vtextcnv.h>\n";
hf << "\n";
hf << "    class " << bn << "TextCanvasPane : public vTextCanvasPane\n";
hf << "      {\n";
hf << "      public:		//---------------------------------------- public\n";
hf << "	" << bn << "TextCanvasPane();\n";
hf << "	virtual ~" << bn << "TextCanvasPane();\n";
hf << "\n";
hf << "	// Scrolling\n";
hf << "	virtual void HPage(int, int);\n";
hf << "	virtual void VPage(int, int);\n";
hf << "\n";
hf << "	virtual void HScroll(int);\n";
hf << "	virtual void VScroll(int);\n";
hf << "\n";
hf << "	// Events\n";
hf << "	virtual void FontChanged(vFont& newFont);\n";
hf << "	virtual void ResizeText(const int rows, const int cols);\n";
hf << "	virtual void Redraw(int x, int y, int w , int h);\n";
hf << "	virtual void TextMouseDown(int row, int col, int button);\n";
hf << "	virtual void TextMouseUp(int row, int col, int button);\n";
hf << "	virtual void TextMouseMove(int row, int col, int button);\n";
hf << "\n";
hf << "      protected:	//--------------------------------------- protected\n";
hf << "      private:		//--------------------------------------- private\n";
hf << "      };\n";
hf << "#endif\n";
hf << "\n";
   hf.close();
   return 1;

  }

//=========================>>> genDlg <<<==========================
  int genDlg(vgOptions& op)
  {
    char *bn = &op.appName[0];
    char *fn = &op.fileName[0];
    char cppName[100], hName[100];

//*****************************************************************
// Generate the dialog .cpp file

    strcpy(cppName,fn); strcat(cppName,"dlg.cpp");

    ofstream of(cppName);

    if (!of)
	return 0;

//---->
GeneratedBy(of, "//");	//=========================================================
of << "//	" << fn << "dlg.cpp:	Source for " << bn << "Dialog class\n";
of << "//=======================================================================\n";
of << "\n";
of << "#include \"" << fn << "dlg.h\"\n";
if (!op.extraDialog)
    of << "#include \"" << fn << "cmdw.h\"\n";
of << "#include <v/vnotice.h>\n";
of << "\n";
of << "//@V@:BeginIDs\n";
of << "    enum {\n";
of << "    lblMainMsg = 1000,\n";
of << "    btnTestDlg		// add your id's here\n";
of << "  };\n";
of << "//@V@:EndIds\n";
of << "\n";
of << "//@V@:BeginDialogCmd DefaultCmds\n";
of << "    static DialogCmd DefaultCmds[] =\n";
of << "      {\n";
of << "	{C_Label, lblMainMsg, 0,\"X\",NoList,CA_MainMsg,isSens,NoFrame, 0, 0},\n";
of << "\n";
of << "	{C_Button, M_Cancel, 0, \" Cancel \",NoList,CA_None,\n";
of << "	    isSens,NoFrame,0, lblMainMsg},\n";
of << "	{C_Button, M_OK, 0, \" OK \", NoList, CA_DefaultButton,\n";
of << "	    isSens, NoFrame, M_Cancel, lblMainMsg},\n";
of << "\n";
of << "	{C_Button, btnTestDlg, 0, \" Test \", NoList, CA_None,\n";
of << "	    isSens, NoFrame, M_OK, lblMainMsg},\n";
of << "\n";
of << "	{C_EndOfList,0,0,0,0,CA_None,0,0,0}\n";
of << "    };\n";
of << "//@V@:EndDialogCmd\n";
of << "\n";
of << "\n";
of << "//=========================>>> " << bn << "Dialog::" << bn << "Dialog <<<====================\n";
of << "  " << bn << "Dialog::" << bn << "Dialog(vBaseWindow* bw, char* title) :\n";
of << "    vDialog(bw, 0, title)\n";
of << "  {\n";
of << "      UserDebug(Constructor,\"" << bn << "Dialog::" << bn << "Dialog()\\n\")\n";
of << "\n";
if (!op.extraDialog)
    of << "    _myCmdWin = (" << bn << "CmdWindow*) bw;\n";
of << "    AddDialogCmds(DefaultCmds);		// add the predefined commands\n";
of << "  }\n";
of << "\n";
of << "//========================>>> " << bn << "Dialog::~" << bn << "Dialog <<<====================\n";
of << "  " << bn << "Dialog::~" << bn << "Dialog()\n";
of << "  {\n";
of << "    UserDebug(Destructor,\"" << bn << "Dialog::~" << bn << "Dialog() destructor\\n\")\n";
of << "  }\n";
of << "\n";
of << "//====================>>> " << bn << "Dialog::DialogCommand <<<=======================\n";
of << "  void " << bn << "Dialog::DialogCommand(ItemVal id, ItemVal retval, CmdType ctype)\n";
of << "  {\n";
of << "    // Dialog commands to here\n";
of << "\n";
of << "    UserDebug2(CmdEvents,\"" << bn << "Dialog::DialogCommand(id:%d, val:%d)\\n\",id, retval)\n";
of << "\n";
of << "    switch (id)		// We will do some things depending on value\n";
of << "      {\n";
of << "	//@V@:Case: btnTestDlg\n";
of << "	case btnTestDlg:\n";
of << "	  {\n";
of << "	    vNoticeDialog note(this);\n";
of << "	    note.Notice(\"Test Dialog\");\n";
of << "	    break;\n";
of << "	  }	//@V@:EndCase\n";
of << "\n";
of << "      }\n";
of << "\n";
of << "    vDialog::DialogCommand(id,retval,ctype);\n";
of << "  }\n";
of << "\n";

   of.close();

//*****************************************************************
// Generate the dialog .h file

    strcpy(hName,fn); strcat(hName,"dlg.h");

    ofstream hf(hName);

    if (!hf)
	return 0;

//---->

GeneratedBy(of, "//");	//=========================================================
hf << "//	" << fn << "dlg.h:	Header for " << bn << "Dialog class\n";
hf << "//=======================================================================\n";
hf << "\n";
hf << "#ifndef " << bn << "DIALOG_H\n";
hf << "#define " << bn << "DIALOG_H\n";
hf << "#include <v/vdialog.h>\n";
hf << "\n";
if (!op.extraDialog)
    hf << "    class "<< bn << "CmdWindow;\n\n";
hf << "    class " << bn << "Dialog : public vDialog\n";
hf << "      {\n";
hf << "      public:		//---------------------------------------- public\n";
hf << "	" << bn << "Dialog(vBaseWindow* bw, char* title = \"" << op.title << "\");\n";
hf << "	virtual ~" << bn << "Dialog();		// Destructor\n";
hf << "	virtual void DialogCommand(ItemVal,ItemVal,CmdType); // action selected\n";
hf << "	void AddDefaultCmds();		// to add the defined commands\n";
hf << "\n";
hf << "      protected:	//--------------------------------------- protected\n";
hf << "\n";
hf << "      private:		//--------------------------------------- private\n";
hf << "\n";
if (!op.extraDialog)
    hf << "	" << bn << "CmdWindow* _myCmdWin;\n";
hf << "      };\n";
hf << "#endif\n";
   hf.close();
   return 1;

  }

//=========================>>> genMdlg <<<==========================
  int genMDlg(vgOptions& op)
  {
    char *bn = &op.appName[0];
    char *fn = &op.fileName[0];
    char cppName[100], hName[100];

//*****************************************************************
// Generate the modal dialog .cpp file

    strcpy(cppName,fn); strcat(cppName,"mdlg.cpp");

    ofstream of(cppName);

    if (!of)
	return 0;

//---->
GeneratedBy(of, "//");	//=========================================================
of << "//	" << fn << "mdlg.cpp:	Source for " << bn << "ModalDialog class\n";
of << "//=======================================================================\n";
of << "\n";
of << "#include \"" << fn << "mdlg.h\"\n";
if (!op.extraDialog)
    of << "#include \"" << fn << "cmdw.h\"\n";
of << "#include <v/vnotice.h>\n";
of << "\n";
of << "//@V@:BeginIDs\n";
of << "    enum {\n";
of << "    lblMainMsg = 1000,\n";
of << "    btnTestMDlg		// add your id's here\n";
of << "  };\n";
of << "//@V@:EndIds\n";
of << "\n";
of << "//@V@:BeginDialogCmd DefaultCmds\n";
of << "    static DialogCmd DefaultCmds[] =\n";
of << "      {\n";
of << "	{C_Label, lblMainMsg, 0,\"X\",NoList,CA_MainMsg,isSens,NoFrame, 0, 0},\n";
of << "\n";
of << "	{C_Button, M_Cancel, 0, \" Cancel \",NoList,CA_None,\n";
of << "	    isSens,NoFrame,0, lblMainMsg},\n";
of << "	{C_Button, M_OK, 0, \" OK \", NoList, CA_DefaultButton,\n";
of << "	    isSens, NoFrame, M_Cancel, lblMainMsg},\n";
of << "\n";
of << "	{C_Button, btnTestMDlg, 0, \" Test \", NoList, CA_None,\n";
of << "	    isSens, NoFrame, M_OK, lblMainMsg},\n";
of << "\n";
of << "	{C_EndOfList,0,0,0,0,CA_None,0,0,0}\n";
of << "    };\n";
of << "//@V@:EndDialogCmd\n";
of << "\n";
of << "\n";
of << "//======================>>> " << bn << "ModalDialog::" << bn << "ModalDialog <<<==================\n";
of << "  " << bn << "ModalDialog::" << bn << "ModalDialog(vBaseWindow* bw, char* title) :\n";
of << "    vModalDialog(bw, title)\n";
of << "  {\n";
of << "    UserDebug(Constructor,\"" << bn << "ModalDialog::" << bn << "ModalDialog()\\n\")\n";
if (!op.extraDialog)
    of << "    _myCmdWin = (" << bn << "CmdWindow*) bw;\n";
of << "    AddDialogCmds(DefaultCmds);		// add the predefined commands\n";
of << "  }\n";
of << "\n";
of << "//===================>>> " << bn << "ModalDialog::~" << bn << "ModalDialog <<<====================\n";
of << "  " << bn << "ModalDialog::~" << bn << "ModalDialog()\n";
of << "  {\n";
of << "    UserDebug(Destructor,\"" << bn << "ModalDialog::~" << bn << "ModalDialog() destructor\\n\")\n";
of << "  }\n";
of << "\n";
of << "//====================>>> " << bn << "ModalDialog::" << bn << "Action <<<====================\n";
of << "  int " << bn << "ModalDialog::" << bn << "Action(char* msg)\n";
of << "  {\n";
of << "    ItemVal ans,rval;\n";
of << "\n";
of << "    ans = ShowModalDialog(msg,rval);\n";
of << "    if (ans == M_Cancel)\n";
of << "	return 0;\n";
of << "\n";
of << "    // *** Add code to process dialog values here\n";
of << "\n";
of << "    return ans == M_OK;\n";
of << "  }\n";
of << "\n";
of << "//====================>>> " << bn << "ModalDialog::DialogCommand <<<====================\n";
of << "  void " << bn << "ModalDialog::DialogCommand(ItemVal id, ItemVal retval, CmdType ctype)\n";
of << "  {\n";
of << "    UserDebug2(CmdEvents,\"" << bn << "ModalDialog::DialogCommand(id:%d, val:%d)\\n\",id, retval)\n";
of << "\n";
of << "    switch (id)		// We will do some things depending on value\n";
of << "      {\n";
of << "	//@V@:Case: btnTestMDlg\n";
of << "	case btnTestMDlg:\n";
of << "	  {\n";
of << "	    vNoticeDialog note(this);\n";
of << "	    note.Notice(\"Test Dialog\");\n";
of << "	    break;\n";
of << "	  }	//@V@:EndCase\n";
of << "      }\n";
of << "\n";
of << "    vModalDialog::DialogCommand(id,retval,ctype);\n";
of << "  }\n";
of << "\n";

   of.close();

//*****************************************************************
// Generate the modal dialog .h file

    strcpy(hName,fn); strcat(hName,"mdlg.h");

    ofstream hf(hName);

    if (!hf)
	return 0;

//---->
GeneratedBy(of, "//");	//=========================================================
hf << "//	" << fn << "mdlg.h:	Header for " << bn << "ModalDialog class\n";
hf << "//=======================================================================\n";
hf << "\n";
hf << "#ifndef " << bn << "MDLG_H\n";
hf << "#define " << bn << "MDLG_H\n";
hf << "\n";
hf << "#include <v/vmodald.h>\n";
hf << "\n";
if (!op.extraDialog)
    hf << "    class "<< bn << "CmdWindow;\n\n";
hf << "    class " << bn << "ModalDialog : public vModalDialog\n";
hf << "      {\n";
hf << "      public:		//---------------------------------------- public\n";
hf << "	" << bn << "ModalDialog(vBaseWindow* bw, char* title = \"" << op.title << "\");\n";
hf << "	virtual ~" << bn << "ModalDialog();		// Destructor\n";
hf << "	virtual void DialogCommand(ItemVal,ItemVal,CmdType); // action selected\n";
hf << "	virtual int " << bn << "Action(char* msg);\n";
hf << "\n";
hf << "      protected:	//--------------------------------------- protected\n";
hf << "\n";
hf << "      private:		//--------------------------------------- private\n";
hf << "\n";
if (!op.extraDialog)
    hf << "	" << bn << "CmdWindow* _myCmdWin;\n";
hf << "      };\n";
hf << "#endif\n";
hf << "\n";

   hf.close();
   return 1;

  }

//=========================>>> genMake <<<==========================
  int genMake(vgOptions& op)
  {
    char *bn = &op.appName[0];
    char *fn = &op.fileName[0];
    char name[100];

//*****************************************************************
// Generate the g++ Make file 

    strcpy(name,"makefile."); strcat(name,fn);

    ofstream of(name);

    if (!of)
	return 0;

//------>

GeneratedBy(of, "#");	//=========================================================
of << "#=======================================================================\n";
of << "\n";
of << "CC	=	g++\n";
of << "\n";
of << "HOMEV	=	" << op.home << "\n";
#ifdef V_VersionX
of << "X11INC	=	/usr/X11/include\n";
of << "X11LIB	=	/usr/X11R6/lib\n";
#endif
if (op.canvasType == OpenGL)
of << "LIBS	=	" << OGLDEF_LIBS << "\n";
else
of << "LIBS	=	" << DEF_LIBS << "\n";
of << "VLibDir	=	$(HOMEV)/lib\n";
of << "oDir	=	.\n";
of << "Bin	=	.\n";
of << "\n";
of << "VPATH	=	$(HOMEV)" << DEF_VPATH << "\n";
of << "\n";
of << "#--------------------------------------------------------------\n";
of << "# Architecture dependent\n";
of << "\n";
of << "# Flags for includes and libraries\n";
of << "\n";
#ifdef V_VersionX
of << "CFLAGS	=	-O -I$(X11INC) -I$(HOMEV)" << DEF_VPATH << "\n";
of << "\n";
of << "LFLAGS	=	-O -L$(X11LIB) -L$(VLibDir)\n";
of << "\n";
#else
of << "CFLAGS	=	-O -I$(HOMEV)" << DEF_VPATH << "\n";
of << "\n";
of << "LFLAGS	=	-O -L$(VLibDir)\n";
of << "\n";
#endif
of << "EXOBJS	=	$(oDir)/" << fn  << "app.o \\\n";
if (op.addDialog)
    of << "		$(oDir)/" << fn << "dlg.o \\\n";
if (op.addModal)
    of << "		$(oDir)/" << fn << "mdlg.o \\\n";
if (op.canvasType != NoCanvas)
    of << "		$(oDir)/" << fn << "cnv.o \\\n";
of << "		$(oDir)/" << fn << "cmdw.o\n";
of << "\n";
#ifdef V_VersionX
of << "all:	$(Bin)/" << bn << "\n";
#else
of << "all:	$(Bin)/" << bn << ".exe\n";
#endif
of << "\n";
of << "objs:	$(EXOBJS)\n";
of << "\n";
of << "clean:\n";
of << "	rm $(EXOBJS)\n";
of << "\n";
//
// BEW: 4/6/98 Changed so that same makefile will work with either
//	libV.a or libV.so. Probably should put a dependency on
//	v_defs.h in the code files, but that will have complications
//	of its own. We will assume that V is constant for now.
//
#ifdef REQUIRE_LIBV
#ifdef V_VersionX
of << "$(Bin)/" << bn <<":	$(EXOBJS) $(VLibDir)/libV.a\n";
#else
of << "$(Bin)/" << bn <<".exe:	$(EXOBJS) $(VLibDir)/libV.a\n";
#endif

#else

#ifdef V_VersionX
of << "$(Bin)/" << bn <<":	$(EXOBJS)\n";	// so don't require libV.a
#else
of << "$(Bin)/" << bn <<".exe:	$(EXOBJS)\n";	// so don't require libV.a
#endif
#endif
of << "	$(CC) -o $@ $(LFLAGS) $(EXOBJS) $(LIBS)\n";
of << "\n";
if (op.canvasType != NoCanvas)
  {
    of << "$(oDir)/" << fn << "cnv.o:	" << fn << "cnv.cpp  " << fn << "cnv.h\n";
    of << "	$(CC) -c $(CFLAGS) -o $@ $<\n";
    of << "\n";
  }
if (op.addDialog)
{
    of << "$(oDir)/" << fn << "dlg.o:	" << fn << "dlg.cpp  " << fn << "dlg.h\n";
    of << "	$(CC) -c $(CFLAGS) -o $@ $<\n";
    of << "\n";
}
if (op.addModal)
{
    of << "$(oDir)/" << fn << "mdlg.o:	" << fn << "mdlg.cpp " << fn << "mdlg.h\n";
    of << "	$(CC) -c $(CFLAGS) -o $@ $<\n";
    of << "\n";
}
of << "$(oDir)/" << fn << "cmdw.o:	" << fn << "cmdw.cpp " << fn << "cmdw.h\n";
of << "	$(CC) -c $(CFLAGS) -o $@ $<\n";
of << "\n";

//***** Handle different dependencies for dialogs

if (op.addDialog && op.addModal)
{
of << "$(oDir)/" << fn << "app.o:	" << fn << "app.cpp " << fn << "dlg.h " << fn << "mdlg.h \\\n";
of << "	" << fn << "app.h " << fn << "cmdw.h\n";
of << "	$(CC) -c $(CFLAGS) -o $@ $<\n";
}
else if (op.addDialog)
{
of << "$(oDir)/" << fn << "app.o:	" << fn << "app.cpp " << fn << "dlg.h \\\n";
of << "	" << fn << "app.h " << fn << "cmdw.h\n";
of << "	$(CC) -c $(CFLAGS) -o $@ $<\n";
}
else if (op.addModal)
{
of << "$(oDir)/" << fn << "app.o:	" << fn << "app.cpp " << fn << "mdlg.h \\\n";
of << "	" << fn << "app.h " << fn << "cmdw.h\n";
of << "	$(CC) -c $(CFLAGS) -o $@ $<\n";
}
else
{
of << "$(oDir)/" << fn << "app.o:	" << fn << "app.cpp \\\n";
of << "	" << fn << "app.h " << fn << "cmdw.h\n";
of << "	$(CC) -c $(CFLAGS) -o $@ $<\n";
}

    of.close();
    return 1;
  }
