*DECK QCDRC
      SUBROUTINE QCDRC (LUN, KPRINT, IPASS)
C***BEGIN PROLOGUE  QCDRC
C***PURPOSE  Quick check for DRC.
C***LIBRARY   SLATEC
C***KEYWORDS  QUICK CHECK
C***AUTHOR  Pexton, R. L., (LLNL)
C***DESCRIPTION
C
C            QUICK TEST FOR CARLSON INTEGRAL DRC
C
C***ROUTINES CALLED  D1MACH, DRC, NUMXER, XERCLR, XGETF, XSETF
C***REVISION HISTORY  (YYMMDD)
C   790801  DATE WRITTEN
C   890618  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   910708  Minor modifications in use of KPRINT.  (WRB)
C***END PROLOGUE  QCDRC
      INTEGER KPRINT, IPASS, CONTRL, KONTRL, LUN, IER
      INTEGER IPASS1, IPASS2, IPASS3, IPASS4, NUMXER
      DOUBLE PRECISION PI, TRC, DRC, DIF, D1MACH
      EXTERNAL D1MACH, DRC, NUMXER, XERCLR, XGETF, XSETF
C***FIRST EXECUTABLE STATEMENT  QCDRC
      CALL XERCLR
      CALL XGETF(CONTRL)
      IF ( KPRINT .GE. 3 ) THEN
         KONTRL = +1
      ELSE
         KONTRL = 0
      ENDIF
      CALL XSETF(KONTRL)
C
C  FORCE ERROR 1
C
      IF ( KPRINT .GE. 3 ) WRITE (LUN,101)
  101 FORMAT(' DRC - FORCE ERROR 1 TO OCCUR')
      TRC = DRC(-1.0D0,-1.0D0,IER)
      IER = NUMXER(IER)
      IF ( IER .EQ. 1 ) THEN
         IPASS1 = 1
      ELSE
         IPASS1 = 0
      ENDIF
      CALL XERCLR
C
C  FORCE ERROR 2
C
      IF ( KPRINT .GE. 3 ) WRITE (LUN,102)
  102 FORMAT(' DRC - FORCE ERROR 2 TO OCCUR')
      TRC = DRC(D1MACH(1),D1MACH(1),IER)
      IER = NUMXER(IER)
      IF ( IER .EQ. 2 ) THEN
         IPASS2 = 1
      ELSE
         IPASS2 = 0
      ENDIF
      CALL XERCLR
C
C  FORCE ERROR 3
C
      IF ( KPRINT .GE. 3 ) WRITE (LUN,103)
  103 FORMAT(' DRC - FORCE ERROR 3 TO OCCUR')
      TRC = DRC(D1MACH(2),D1MACH(2),IER)
      IER = NUMXER(IER)
      IF ( IER .EQ. 3 ) THEN
         IPASS3 = 1
      ELSE
         IPASS3 = 0
      ENDIF
      CALL XERCLR
C
C  ARGUMENTS IN RANGE
C
      PI  = 3.141592653589793238462643383279D0
      TRC = DRC(0.0D0,0.25D0,IER)
      CALL XERCLR
      DIF = TRC - PI
      IF ( (ABS(DIF/PI).LT.1000.0D0*D1MACH(4)) .AND. (IER.EQ.0) ) THEN
         IPASS4 = 1
      ELSE
         IPASS4 = 0
      ENDIF
      IPASS = MIN(IPASS1,IPASS2,IPASS3,IPASS4)
      IF ( KPRINT .LE. 0 ) THEN
         GO TO 999
      ELSEIF ( KPRINT .EQ. 1 ) THEN
         IF ( IPASS .EQ. 1 ) THEN
            GO TO 999
         ELSE
            WRITE (LUN,104)
  104       FORMAT(' DRC - FAILED')
            GO TO 999
         ENDIF
      ELSE
         IF ( IPASS .EQ. 1 ) THEN
            WRITE (LUN,105)
  105       FORMAT(' DRC - PASSED')
            GO TO 999
         ELSE
            WRITE (LUN,104)
            IF ( IPASS4 .EQ. 0 ) WRITE (LUN,106) PI, TRC, DIF
  106       FORMAT(' CORRECT ANSWER =', 1PD20.14 /
     *             'COMPUTED ANSWER =',   D20.14 /
     *             '     DIFFERENCE =',   D20.14 )
            GO TO 999
         ENDIF
      ENDIF
  999 CONTINUE
      CALL XSETF(CONTRL)
      RETURN
      END
