#ifndef _URKPTPF__
#define _URKPTPF__

#include <objres.h>
#include <objseq.h>
#include <objsset.h>

#ifdef __cplusplus
extern "C" {
#endif

#define MAXMATCH     1024
#define MAXPATSIZE   4096
#define MAXPROFSIZE  128
#define MAXCHUNKSIZE 32768

typedef struct compilepattern
{
  Char    name[256];
  Int4    min;
  Int4    max;
  Char    res[32];
  Boolean flagPalindrome;
  Boolean flagNTerm, flagCTerm;
  struct  compilepattern PNTR prev;
  struct  compilepattern PNTR next;
  struct  compilepattern PNTR prevpattern;
  struct  compilepattern PNTR nextpattern;
} ComPat, PNTR ComPatPtr;

typedef struct compileprofile
{
  Char    name[256];
  FloatHi score[32];
  struct  compileprofile PNTR prev;
  struct  compileprofile PNTR next;
  struct  compileprofile PNTR prevprofile;
  struct  compileprofile PNTR nextprofile;
} ComProf, PNTR ComProfPtr;

/* patterns and profiles */

extern SeqAlignPtr MeldStrands (SeqAlignPtr sap);
extern SeqAlignPtr SeparateStrands (SeqAlignPtr sap);

/* patterns */

extern ValNodePtr ReadPatternNames (CharPtr filename);
extern ComPatPtr ReadRENPattern (CharPtr filename, Boolean flagNeedCutPos,
                                 ValNodePtr namelist);
extern ComPatPtr ReadPrositePattern (CharPtr filename, Boolean flagStringent,
                                     Int4 cutoff, CharPtr taxon,
                                     ValNodePtr namelist);
extern Boolean IsProsite (CharPtr inbuff);
extern CharPtr PrositeToGBPattern (CharPtr pspat);

extern CharPtr ReadPattern (CharPtr filename);
extern void urkCleanPattern (CharPtr inbuff);

extern ComPatPtr ComPatNew (ComPatPtr currcpp);
extern ComPatPtr urkComPatFree (ComPatPtr headcpp);
extern ComPatPtr ComPatDup (ComPatPtr cppold);

extern ComPatPtr urkCompilePattern (CharPtr pattern, Int2 moltype);
extern ComPatPtr urkInvertPattern (ComPatPtr cppold);
extern void PalindromeCheck (ComPatPtr cpph);

extern SeqAlignPtr PatternMatch (Uint1Ptr seq, Int4 seqpos, Uint1 strand,
                                 SeqIdPtr sip, ComPatPtr cpp,
                                 Int4 mismatch, Int2 topology,
                                 Boolean flagFindAllMatches);
extern SeqAlignPtr PatternMatchBioseq (BioseqPtr bsp, ComPatPtr cpp,
                                       Int4 mismatch);

/* profiles */

extern ComProfPtr ReadProfile (CharPtr filename);

extern ComProfPtr ComProfNew (ComProfPtr currppp);
extern ComProfPtr ComProfFree (ComProfPtr headppp);

extern ComProfPtr InvertProfile (ComProfPtr ppp);
extern FloatHi ProfScoreMax (ComProfPtr ppp);

extern SeqAlignPtr ProfileMatch (Uint1Ptr seq, Int4 seqpos, FloatHi cutoff,
                                 Uint1 strand, SeqIdPtr sip, ComProfPtr ppp,
                                 Int2 topology, Boolean flagFindAllMatches);
extern SeqAlignPtr ProfileMatchBioseq (BioseqPtr bsp, ComProfPtr ppp,
                                       FloatHi cutoff);

/* SeqAligns SeqLocs */

extern SeqLocPtr MatchSa2Sl (SeqAlignPtr PNTR saph);
extern void EmbedFragLengthInfo (SeqAlignPtr saph, Int4 length);
extern void EmbedMolecularWeightInfo (SeqAlignPtr saph, BioseqPtr bsp);
extern void SeqAlignSortByStart (SeqAlignPtr PNTR sap);
extern void SeqAlignSortByLength (SeqAlignPtr PNTR sap);
extern void SeqAlignSortByMolWt (SeqAlignPtr PNTR sap);

#ifdef __cplusplus
}
#endif

#endif
