/*   cn3dalgn.c
* ===========================================================================
*
*                            PUBLIC DOMAIN NOTICE
*            National Center for Biotechnology Information (NCBI)
*
*  This software/database is a "United States Government Work" under the
*  terms of the United States Copyright Act.  It was written as part of
*  the author's official duties as a United States Government employee and
*  thus cannot be copyrighted.  This software/database is freely available
*  to the public for use. The National Library of Medicine and the U.S.
*  Government do not place any restriction on its use or reproduction.
*  We would, however, appreciate having the NCBI and the author cited in
*  any work or product based on this material
*
*  Although all reasonable efforts have been taken to ensure the accuracy
*  and reliability of the software and data, the NLM and the U.S.
*  Government do not and cannot warrant the performance or results that
*  may be obtained by using this software or data. The NLM and the U.S.
*  Government disclaim all warranties, express or implied, including
*  warranties of performance, merchantability or fitness for any particular
*  purpose.
*
* ===========================================================================
*
* File Name:  cn3dalgn.c
*
* Author:  Lewis Geer and Qui-Wei Xu
*
* Version Creation Date:
*
* File Description: routines to return vast alignments
*
* ==========================================================================
*/


/* no idea why so many headers.  These should be sorted out at some point.  lyg */

#include <ncbi.h>  /* the NCBI SDK header */
#include <asn.h>   /* the ASN.1 header */
#include <mmdbapi.h>   /* the MMDB-API header */
#include <sequtil.h>
#include <objsset.h>
#include <mmdbdata.h>
#include <mmdblocl.h>
#include <vastlocl.h>
#include <string.h>
#include <accentr.h>
#include <saledit.h>
#include <lsqfetch.h>
#include <cn3dalgn.h>
#include <objall.h>
#include <accentr.h>
#include <mmdbapi.h>
#include <mmdblocl.h>
#include <objmmdb1.h>
#include <objmmdb2.h>
#include <objmmdb3.h>
#include <sequtil.h>
#include <vibrant.h>


#define Local_max 200


/* fetch all alignments for the given domain of the master structure */

Nlm_Int2 LIBCALL Cn3D_fnMasterList(PMSD pmsdMaster, PopuP master_list)

{
  
  BiostrucAnnotSetPtr pbsa = NULL;
  BiostrucFeatureSetPtr pbsfs= NULL;
  BiostrucFeaturePtr pbsf= NULL;
  Char   tmp_str[Local_max];
  Int2 master_counter;
  
  
  Reset(master_list);
  
  /* start VAST*/
  if (IsVASTData(pmsdMaster->iMMDBid) == TRUE)
  {
    
       pbsa = VASTBsAnnotSetGet(pmsdMaster->iMMDBid);  
       if (!pbsa)
       {
         /* printf("vast is hosed\n"); */
         ErrPostEx (SEV_ERROR, 0, 0, "vast is hosed\n");
         return -1;
       }
       pbsfs = pbsa -> features;
       DValNodeAddPointer (&(pmsdMaster->pdnsfsHead), Feature_type_alignment, pbsfs);
    
       
       /* Find out alignment ID's and populate the list */
       

       /* add to the pmsd.  */
       
       master_counter=0;
       while(pbsfs)
       {
         master_counter++;
         
         tmp_str[0]='\0';
         sprintf(tmp_str,"%s\n", 
           pbsfs->descr->data.ptrvalue);
         tmp_str[6]='\0';   /* blow away the extra character.  fix this */
         PopupItem(master_list, tmp_str);
         
         pbsfs = pbsfs -> next;
       }/*while pbsfs*/
       
     }
     
	 
  return master_counter;
  
}





/* fetch slave structures for the selected alignments */

BiostrucFeaturePtr LIBCALL Cn3d_fnSlaveList(PMSD pmsdMaster,  LisT slave_list,
                                            Nlm_Int4 imaster_domain)
{
  AlignStatsPtr pasp=NULL;
  BiostrucAnnotSetPtr pbsa = NULL;
  BiostrucIdPtr pbsid =  NULL;
  BiostrucIdPtr pbsid2 =  NULL;
  BiostrucFeatureSetPtr pbsfs= NULL;
  BiostrucFeaturePtr pbsf= NULL, pbsfHead;
  ChemGraphAlignmentPtr pcga = NULL;
  Char slave_str[Local_max];
  Char  tmp_str[Local_max];
  ValNodePtr pvn = NULL;
  FloatLo f;
  Int4 ID_feature_set;
  Int2 iSort=0; /*as stored*/
  Int4 j; 
  Int4 slave_counter=0;
  
  
  
  Reset(slave_list);
  
       
       pbsfs = (BiostrucFeatureSetPtr)DValNodeFindNext(pmsdMaster->pdnsfsHead, NULL, Feature_type_alignment);  /* this needs to be done more intelligently */
       pbsfs = (BiostrucFeatureSetPtr)((ValNode *)pbsfs)->data.ptrvalue;      
       for (j=1; j<imaster_domain; j++)
       {
         pbsfs=pbsfs->next;
       }
       /*sort the vast table*/
       /*   VastTableSort(pbsfs, iSort);  don't worry about this yet */
       
       pbsid = ValNodeFindNext(pbsfs->descr, NULL, BiostrucFeatureSetDescr_name);
       
       if(pbsid)
       {
         ID_feature_set = (Int4) (pbsfs->id);
         
         pbsf = pbsfs -> features;
         
         pbsfHead = pbsf;
         
         /*start with individual slave*/
         slave_counter =0;
         
         while(pbsf)
         {
           
           /* find the alignment for the particular slave */

           slave_str[0]=pbsf->name[7];
           slave_str[1]=pbsf->name[8];
           slave_str[2]=pbsf->name[9];
           slave_str[3]=pbsf->name[10];
           slave_str[4]=pbsf->name[11];  /*chain*/
           slave_str[5]=pbsf->name[12];  /*domain*/
           slave_str[6]=' ';
           slave_str[7]='\0';
           
           pvn = ValNodeFindNext(pbsf->Location_location,NULL,
             Location_location_alignment);
           
           pcga =
             (ChemGraphAlignmentPtr)pvn->data.ptrvalue;
           
           
             /*  pbsid2 = ValNodeFindNext(pcga->biostruc_ids, NULL,
             BiostrucId_mmdb_id);
             if (pbsid2->next)
             ID_slave = (long) pbsid2->next->data.intvalue;
             
           /*skip master-self as a slave*/
           /*		      if((long)ID_slave == (long)ID_master) goto skipmaster;*/
           
           

           /* calculate the various scores */

           pasp=pcga->aligndata;
           if(pasp->vast_score)
           {
             f= (float) pasp->vast_score;
             f = f/(float) (pasp->scale_factor);
           }
           
           tmp_str[0]='\0';   
           sprintf(tmp_str,"%f ",f);
           StringCat(slave_str, tmp_str);
           
           if(pasp->vast_mlogp)
           {
             f= (float) pasp->vast_mlogp;
             f = f/(float) (pasp->scale_factor);
           }
           
           tmp_str[0]='\0';
           sprintf(tmp_str,"%f ",f);
           
           StringCat(slave_str, tmp_str);
           
           if(pasp->rmsd)
           {
             f= (float) pasp->rmsd;
             f = f/(float) (pasp->scale_factor);
           }
           
           
           tmp_str[0]='\0';
           sprintf(tmp_str,"%f ",f);
           
           StringCat(slave_str, tmp_str);
           
           if(pasp->align_res)
           {
             f= (float) pasp->align_res;
             /*f = f/(float) (pasp->scale_factor);*/
           }
           
           tmp_str[0]='\0';
           sprintf(tmp_str,"%f ",f);
           
           StringCat(slave_str, tmp_str);
           
           if(pasp->other_score)
           {
             f= (float) pasp->other_score;
             f = f/(float) (pasp->scale_factor);
           }
           tmp_str[0]='\0';
           sprintf(tmp_str,"%f ",f);
           
           StringCat(slave_str, tmp_str);
           
           ListItem(slave_list, slave_str);
           slave_counter++;
           
skipmaster:   
           pbsf = pbsf -> next;
           
         } 
         
    }/*if pbsf*/
    
          
          return pbsfHead;
          
}



