/*
   libffm	- Free, pretty fast replacement for some math (libm) routines 
			on Linux/AXP, optimized for the 21164

   Copyright (C) 1998  Joachim Wesner <joachim.wesner@frankfurt.netsurf.de>
                  and  Kazushige Goto <goto@statabo.rim.or.jp>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library (see file COPYING.LIB); if not, write 
   to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
   MA 02139, USA.
*/
/*
   Fast tan/cotan approximation including range reduction by Joachim Wesner,
   <joachim.wesner@frankfurt.netsurf.de>, see also mc 8/1991 p. 78-93.
   Done in June/July 1998.

   No special handling of illegal arguments or NANs, yet !!
*/

/* improved and modified by Kazushige Goto <goto@statabo.rim.or.jp> */


	.set noreorder
	.set noat

#ifdef __ELF__
	.section .rodata
#else
	.rdata
#endif
	.align 5
K:
	.t_floating  6.36619772367581382433e-1
	.t_floating  5.00000000000000000000e-1
	.t_floating  1.57079601287841796875e0
	.t_floating  3.13916416416759602726e-7
	.t_floating  6.22337217189661338378e-14
	.t_floating  0.00000000000000000000e0		# dummy
	.t_floating  0.00000000000000000000e0		# dummy
	.t_floating  0.00000000000000000000e0		# dummy

/* H&C #4286 rescaled, 19.9 Digits precision */
/*
	.t_floating -3.58528916474714165474e1
	.t_floating -2.67733884797157254070e5
	.t_floating  5.15136992033751957933e4
	.t_floating  6.87460229709782379359e3
	.t_floating  2.00724891117488313466e6
	.t_floating -6.25890950057027453113e2
	.t_floating -9.36816855188785004430e5
	.t_floating  2.00724891117488313466e6
*/
	.t_floating -3.5852891647471419219e+001
        .t_floating -2.6773388479715725433e+005
        .t_floating  5.1513699203375195243e+004
        .t_floating  6.8746022970978239588e+003
        .t_floating  2.0072489111748832058e+006
        .t_floating -6.2589095005702739694e+002
        .t_floating -9.3681685518878501841e+005
	.t_floating  2.0072489111748831926e+006

.text

	.align	5
	.globl	tan
	.ent	tan
tan:
        lda     $30, -16($30)
	ldgp	$29,.-tan($27)
	lda	$1,K
	.frame	$30,16,$26,0

#ifdef PROF
	lda	$28, _mcount
	jsr	$28, ($28), _mcount
	unop
	unop
#endif
	.prologue	1

	ldt	$f18,   0($1)		# K[0]
	ldt	$f19,   8($1)		# K[1]
	ldt	$f22,  32($1)		# K[4]
	ldt	$f23,  64($1)		# K[8]

	mult	$f16, $f18, $f0		# z = x * K[0] 
	ldt	$f27,  96($1)		# K[12]
	mult	$f16, $f16, $f13	# y  = x * x 
	ldt	$f20,  16($1)		# K[2]

	ldt	$f21,  24($1)		# K[3]
	ldt	$f24,  72($1)		# K[9]
	ldt	$f25,  80($1)		# K[10]
	ldt	$f26,  88($1)		# K[11]

	addt	$f0,  $f19, $f10	# r1 = z + K[1]
	ldt	$f28, 104($1)		# K[13]
	subt	$f0,  $f19, $f11	# r2 = z - K[1]
	fblt	$f16, $50		# if x<0. goto $37
	cvttqc	$f10, $f12		# float -> int
	br	$31,  $51
$50:
	cvttqc	$f11, $f12		# float -> int
$51:
	ldt	$f29, 112($1)		# K[14]
	ldt	$f30, 120($1)		# K[15]
	cvtqt	$f12, $f0		# int -> float
	stt	$f12,  0($30)

	fbeq	$f0,  $52

	mult	$f0,  $f20, $f10	# z * K[2]
	mult	$f0,  $f21, $f11	# z * K[3]
	mult	$f0,  $f22, $f12	# z * K[4]
	subt	$f16, $f10, $f10	# x - z*K[2]

	subt	$f10, $f11, $f10	# (x-z*K[2]) - z*K[3]
	subt	$f10, $f12, $f16	# x = (x-z*K[2]) - z*K[3] - z*K[4]
	mult	$f16, $f16, $f13	# y = x * x
	unop
	.align 4

$52:
	mult	$f13, $f13, $f14	# y1 = y * y
	mult	$f23, $f13, $f23	# r1 = K[8]  * y
	mult	$f24, $f13, $f24	# r2 = K[9]  * y
	mult	$f25, $f13, $f25	# r4 = K[10] * y

	mult	$f14, $f13, $f15	# y2 = y1 * y
	addt	$f23, $f26, $f23	# r1 = r1 + K[11]
	addt	$f24, $f27, $f24	# r2 = r2 + K[12]
	addt	$f13, $f28, $f28	# r3 = y + K[13]

	addt	$f25, $f29, $f25	# r4 = r4 + K[14]
	mult	$f23, $f14, $f23	# r1 = r1 * y1
	ldq	$3,  0($30)
	mult	$f28, $f15, $f28	# r3 = r3 * y2
	mult	$f25, $f13, $f25	# r4 = r4 * y

	addt	$f23, $f24, $f23	# r1 = r1 + r2

	blbc	$3, $53
	fneg	$f16, $f16		# x = -x
$53:
	addt	$f28, $f25, $f28	# r3 = r3 + r4
	mult	$f23, $f16, $f23	# r1 = r1 * x
	addt	$f28, $f30, $f28	# r3 = r3 + K[15]

	addq	$30, 16, $30
	blbc	$3,$54
	divt	$f28, $f23, $f0		# return = r3 / r1
	ret	$31,($26),1
$54:
	divt	$f23, $f28, $f0		# return = r1 / r3
	ret	$31,($26),1
	.end	tan


	.align	5
	.globl	cotan
	.ent	cotan
cotan:
        lda     $30, -16($30)
	ldgp	$29,.-cotan($27)
	lda	$1,K
	.frame	$30,16,$26,0

#ifdef PROF
	lda	$28, _mcount
	jsr	$28, ($28), _mcount
	unop
	unop
#endif
	.prologue	1

	ldt	$f18,   0($1)		# K[0]
	ldt	$f19,   8($1)		# K[1]
	ldt	$f22,  32($1)		# K[4]
	ldt	$f23,  64($1)		# K[8]

	mult	$f16, $f18, $f0		# z = x * K[0] 
	ldt	$f27,  96($1)		# K[12]
	mult	$f16, $f16, $f13	# y  = x * x 
	ldt	$f20,  16($1)		# K[2]

	ldt	$f21,  24($1)		# K[3]
	ldt	$f24,  72($1)		# K[9]
	ldt	$f25,  80($1)		# K[10]
	ldt	$f26,  88($1)		# K[11]

	addt	$f0,  $f19, $f10	# r1 = z + K[1]
	ldt	$f28, 104($1)		# K[13]
	subt	$f0,  $f19, $f11	# r2 = z - K[1]
	fblt	$f16, $70		# if x<0. goto $37
	cvttqc	$f10, $f12		# float -> int
	br	$31,  $71
$70:
	cvttqc	$f11, $f12		# float -> int
$71:
	ldt	$f29, 112($1)		# K[14]
	ldt	$f30, 120($1)		# K[15]
	cvtqt	$f12, $f0		# int -> float
	stt	$f12,  -16($30)

	fbeq	$f0,  $72

	mult	$f0,  $f20, $f10	# z * K[2]
	mult	$f0,  $f21, $f11	# z * K[3]
	mult	$f0,  $f22, $f12	# z * K[4]
	subt	$f16, $f10, $f10	# x - z*K[2]

	subt	$f10, $f11, $f10	# (x-z*K[2]) - z*K[3]
	subt	$f10, $f12, $f16	# x = (x-z*K[2]) - z*K[3] - z*K[4]
	mult	$f16, $f16, $f13	# y = x * x
	unop
	.align 4

$72:
	mult	$f13, $f13, $f14	# y1 = y * y
	mult	$f23, $f13, $f23	# r1 = K[8]  * y
	mult	$f24, $f13, $f24	# r2 = K[9]  * y
	mult	$f25, $f13, $f25	# r4 = K[10] * y

	mult	$f14, $f13, $f15	# y2 = y1 * y
	addt	$f23, $f26, $f23	# r1 = r1 + K[11]
	addt	$f24, $f27, $f24	# r2 = r2 + K[12]
	addt	$f13, $f28, $f28	# r3 = y + K[13]

	addt	$f25, $f29, $f25	# r4 = r4 + K[14]
	mult	$f23, $f14, $f23	# r1 = r1 * y1
	ldq	$3,-16($30)
	mult	$f28, $f15, $f28	# r3 = r3 * y2
	mult	$f25, $f13, $f25	# r4 = r4 * y

	addt	$f23, $f24, $f23	# r1 = r1 + r2

	addq	$30, 16, $30
	blbc	$3, $73
	fneg	$f16, $f16		# x = -x
$73:
	addt	$f28, $f25, $f28	# r3 = r3 + r4
	mult	$f23, $f16, $f23	# r1 = r1 * x
	addt	$f28, $f30, $f28	# r3 = r3 + K[15]

	blbs	$3,$74
	divt	$f28, $f23, $f0		# return = r3 / r1
	ret	$31,($26),1
$74:
	divt	$f23, $f28, $f0		# return = r1 / r3
	ret	$31,($26),1
	.end	cotan
