/**
 *
 * $Id: XdbPrintTree.c,v 1.3 1998/06/23 12:36:19 pgw Exp $
 * 
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static char rcsid[] = "$Id: XdbPrintTree.c,v 1.3 1998/06/23 12:36:19 pgw Exp $";

#if 0
#include <LTconfig.h>
#include <XmI/XmI.h>

#include <XmI/DebugUtil.h>
#endif

#include <X11/Xos.h>
#include <Xm/GadgetP.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/Xresource.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <Xm/VendorSEP.h>


static void _XdbPrintTree(Widget w, int level)
{
	int	i;
	CompositeWidget	cw = (CompositeWidget)w;

	if (w == NULL)
		return;

	for (i=0; i<level; i++)
		fprintf(stderr, "\t");
#ifdef  PRINT_ADDRESS
        fprintf(stderr, "%s : %p/%ld", XtName(w), w, XtWindow(w));
#endif
#ifndef PRINT_APPSHELL_NAME
        if(!XtIsApplicationShell(w))
#endif
        fprintf(stderr, "%s", XtName(w));
	fprintf(stderr, "(%s) geo %d %d %d %d",
		w->core.widget_class->core_class.class_name,
		XtX(w), XtY(w), XtWidth(w), XtHeight(w));
#ifdef	PRINT_STATE
	fprintf(stderr, " state: %s %s",
		_XdbState(w), w->core.mapped_when_managed ? "mwm": "");
#endif
	fprintf(stderr, "\n");
	if (XtIsSubclass(w, compositeWidgetClass))
		for (i=0; i<cw->composite.num_children; i++)
			_XdbPrintTree(cw->composite.children[i], level+1);

	for (i=0; i<cw->core.num_popups; i++)
		_XdbPrintTree(cw->core.popup_list[i], level+1);
}

void XdbPrintTree(Widget w)
{
	_XdbPrintTree(w, 0);
}

void XdbPrintCompleteTree(Widget w)
{
	Widget	ww = w;

	while (ww) {
		w = ww;
		ww = XtParent(w);
	}

	_XdbPrintTree(w, 0);
}

void XdbPrintTreeCB(Widget w, XtPointer client, XtPointer call)
{
	XdbPrintTree((Widget)client);
}
