/*    mkdef.cmd                                       */
/*
     $Id:
*/
/*    Tool to generate ***OS2.def                     */
/*    Version 19980809                                */


/*
   Definitions
*/

/* For our purposes they should just be different numbers ... */
TRUE  = 1
FALSE = 0

/* Get the commandline arguments */
Parse Arg Param 

if Words(Param) < 2 then
  do
  say 'mkdef: missing parameters'
  say ' Syntax: mkdef lib_name major_version minor_version'
  exit
  end

/* Build version string */
Parse Var Param lib_name major minor
lib_version = major"."minor

say 'lib_name:'lib_name

/* temporay file to be created which holds all available symbols */
tmplistfile = lib_name"OS2.tmp"

/* new *.def itself */
newlistfile = lib_name"OS2.def"

/* old reference list. We'll keep all (previously) used numbers ! */
reflistfile = lib_name"OS2.def.dist"

/* Command to produce list of available symbols */
genlistcmd  = "emxexp -o -u shared/*.OBJ >> "tmplistfile

/*
  Main 'program'
*/

/* Old temporary symbols file and *.def file will be deleted
   and we look for the reference file */
if Stream(reflistfile, "C", "QUERY EXISTS") = "" then
  do
  say "Can't find "reflistfile". Proceeding ..."
  have_reference = FALSE
  end
else
  have_reference = TRUE

if Stream(tmplistfile, "C", "QUERY EXISTS") <> "" then
  do
  rc = ExecCmd("del "tmplistfile)
  if rc <> 0 then
    do
    say "Can't delete "tmplistfile
    SIGNAL FIN
    end
  end
if Stream(newlistfile, "C", "QUERY EXISTS") <> "" then
  do
  rc = ExecCmd("del "newlistfile)
  if rc <> 0 then
    do
    say "Can't delete "newlistfile
    SIGNAL FIN
    end
  end

/* Generate up-to-date list of all symbols and exit if we fail */
rc = ExecCmd(genlistcmd)
if rc <> 0 then 
  do
  say "Can't create list (rc="rc")"
  SIGNAL FIN
  end
  
/* Read in the new list */
call LineIn tmplistfile,1,0
tmplines = 0
do while Lines(tmplistfile) <> 0
  line = Strip(LineIn(tmplistfile))
  if ((line <> "") & (Left(line,1) <> ";")) then
    do
    tmplines = tmplines + 1 
    Parse Var line symbol "@" number
    tmplist_sym.tmplines = symbol
    tmplist_num.tmplines = number
    end
end /* do while */

tmplist_sym.0 = tmplines
tmplist_num.0 = tmplines
call LineOut tmplistfile
rc = ExecCmd("del "tmplistfile)
say tmplines" entries in tmplist"

maxrefnumber = 0
reflines = 0
reflist_num.0 = 0
/* Read (old) reference list if available */
if have_reference then
  do
  call LineIn reflistfile,1,0
  reflines     = 0
  maxrefnumber = 0
  line = ""
/* 
     We expect a complete valid .def file which also includes
     an 'EXPORT' statement 
*/
  do while ((line <> "EXPORTS") & (Lines(reflistfile) <> 0))
    line = Translate(Strip(LineIn(reflistfile)))
  end
  if Lines(reflistfile) = 0 then
    do
    say "No valid "reflistfile
    SIGNAL FIN
    end
  do while Lines(reflistfile) <> 0
    line = Strip(LineIn(reflistfile))
    if ((line <> "") & (Left(line,1) <> ";")) then
      do
      reflines = reflines + 1 
      Parse Var line symbol "@" number
      reflist_sym.reflines = symbol
      reflist_num.reflines = number
      if number > maxrefnumber then
        maxrefnumber = number
      end
  end /* do while */
  reflist_sym.0 = reflines
  reflist_num.0 = reflines
  call LineOut reflistfile
  say reflines" entries in reflist"
  end

/*
   Now we parse the new symbol list and look for matching
   entries in the reference list. Note that this will take a
   substantial amount of time for the Xm library as we process
   about 1800 symbols here!
*/
newlines   = 0
newsymbols = 0
do i=1 to tmplines
  symbol = tmplist_sym.i
  refnumber = 0
  refsymbol = ""
  if reflist_num.0 > 0 then
    do
    /* Search given symbol */
    j = 1
    do until ( (refsymbol = symbol) | (j > reflines) )
      refsymbol = reflist_sym.j
      refnumber = reflist_num.j
22      j = j + 1
    end /* do until */
    end
  if (refsymbol <> symbol) then
    /* New symbol found (or no reference table at all)!*/
    do
    newsymbols = newsymbols + 1
    newsymbols_sym.newsymbols = symbol
    newsymbols_num.newsymbols = newsymbols
    end
  else
    /* Previously known symbol */
    do
    newlines = newlines + 1
    newlist_sym.newlines = refsymbol
    newlist_num.newlines = refnumber
    end
end /* do i */

/* Finally we write the new *.def */
rc = LineOut(newlistfile,,1)

/* Write header for .def file */
/* We will read this template from an external file in future */
call LineOut newlistfile, "LIBRARY "lib_name" INITINSTANCE TERMINSTANCE"
call LineOut newlistfile, 'DESCRIPTION "X11R6.1 XFree86 'lib_name'.dll for OS/2 EMX VERSION='lib_version'"'
call LineOut newlistfile, "CODE"
call LineOut newlistfile, "	 PRELOAD"
call LineOut newlistfile, "DATA"
call LineOut newlistfile, "	 MULTIPLE NONSHARED"
call LineOut newlistfile, "STACKSIZE 32768"
call LineOut newlistfile, "EXPORTS"

/* Write all previously known symbols */
if reflist_num.0 > 0 then
  do i=1 to newlines
    line = "  "newlist_sym.i" @"newlist_num.i
    call LineOut newlistfile, line
  end /* do i */
  
/* We always write all new symbols with numbers > maxrefnumber ! */
/* Attention: "Many" years from now we should check whether the numbers
   are in the valid range (I don't know the upper limit, is it maxint ?) */
do i=1 to newsymbols
  newnumber = i + maxrefnumber
  line = "  "newsymbols_sym.i" @"newnumber
  call LineOut newlistfile, line
end /* do i */
call LineOut newlistfile

/* All branches of this script should end here */
FIN:
exit

/*
  ***********************************************************************
*/

/*
  Additional procedures/functions
*/

ExecCmd: Procedure
/* Execute a command properly and return it's return value */
Parse Arg cmdstring
Address CMD "@ "cmdstring
return rc
