#include "obgtkAdjustment.h"

@implementation Gtk_Adjustment
- castGtkAdjustment:(GtkAdjustment *)castitem
{
  gtkadjustment = castitem;
  return [super castGtkData:GTK_DATA(gtkadjustment)];
}

- init
{
  return [self initWithAdjustmentInfo:0
	       limitLower:0
	       limitUpper:100
	       incrementStep:1
	       incrementPage:1
	       sizePage:100];
}

- initWithAdjustmentInfo:(gfloat) value
	      limitLower:(gfloat) lower
	      limitUpper:(gfloat) upper
	   incrementStep:(gfloat) step_increment
	   incrementPage:(gfloat) page_increment
		sizePage:(gfloat) page_size
{
  gtkadjustment = GTK_ADJUSTMENT(gtk_adjustment_new(value, lower,
						    upper, step_increment,
						    page_increment, page_size));
  return [super castGtkData:GTK_DATA(gtkadjustment)];
}

- set_value:(gfloat) value
{
  gtk_adjustment_set_value(gtkadjustment, value);
  return self;
}
@end
