// fl_50percent.C

// Code to set the current halftone pattern to do N-percent opacity.
// This is ONLY used by the HAVE_OVERLAY version of Fl_Menu windows.
// Since this is only used by X it does not need to be implemented
// on other systems, and I have removed it from the public interface.

#include <config.h>
#ifdef HAVE_OVERLAY
#include <FL/fl_draw.H>
#include <FL/x.H>

static const unsigned char halftone[9] = {
  0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA
};

void fl_50percent() {
  static Pixmap h1;
  if (!h1) h1 = XCreateBitmapFromData(fl_display, fl_window,
				      (const char*)halftone, 8, 8);
  XSetStipple(fl_display, fl_gc, h1);
  XSetFillStyle(fl_display, fl_gc, FillStippled);
}

void fl_50percent2() {
  static Pixmap h1;
  if (!h1) h1 = XCreateBitmapFromData(fl_display, fl_window,
				      (const char*)halftone+1, 8, 8);
  XSetStipple(fl_display, fl_gc, h1);
  XSetFillStyle(fl_display, fl_gc, FillStippled);
}

void fl_100percent() {
  XSetFillStyle(fl_display, fl_gc, FillSolid);
}

#endif
