// Fl_Window.C

// fltk (Fast Light Tool Kit) version 0.99
// Copyright (C) 1998 Bill Spitzak

// The Fl_Window is a window in the fltk library.
// This is the system-independent portions.  The huge amount of 
// crap you need to do to communicate with X is in Fl_x.C

#include <FL/Fl.H>
#include <FL/Fl_Window.H>

void Fl_Window::_Fl_Window() {
  type(FL_WINDOW);
  box(FL_FLAT_BOX);
  labeltype(FL_NO_LABEL);
  i = 0;
  xclass_ = 0;
  iconlabel_ = 0;
  resizable(0);
  set_flag(FL_BORDER|INVISIBLE);
  size_range_set = 0;
}

Fl_Window::Fl_Window(int X,int Y,int W, int H, const char *l)
: Fl_Group(X, Y, W, H, l) {
  _Fl_Window();
  set_flag(FL_FORCE_POSITION);
}

// fix common user error of a missing end():
static inline int lame() {Fl_Group::current(0); return 0;}
Fl_Window::Fl_Window(int W, int H, const char *l)
  : Fl_Group(lame(), 0, W, H, l) {
  _Fl_Window();
}

Fl_Window *Fl_Widget::window() const {
  for (Fl_Widget *o = parent(); o; o = o->parent())
    if (o->type()>=FL_WINDOW) return (Fl_Window*)o;
  return 0;
}

int Fl_Window::x_root() const {
  Fl_Window *p = window();
  if (p) return p->x_root() + x();
  return x();
}

int Fl_Window::y_root() const {
  Fl_Window *p = window();
  if (p) return p->y_root() + y();
  return y();
}

void Fl_Window::draw() {
  int savex = x(); x(0);
  int savey = y(); y(0);
  Fl_Group::draw();
  y(savey);
  x(savex);
}

// End of Fl_Window.C
