// Fl_Menu.C

// fltk (Fast Light Tool Kit) version 0.99
// Copyright (C) 1998 Bill Spitzak

// Warning: this menu code is quite a mess!

#include <config.h>
#include <FL/Fl.H>
#include <FL/Fl_Menu_Window.H>
#include <FL/Fl_Menu.H>
#include <FL/fl_draw.H>

int Fl_Menu::size() const {
  const Fl_Menu *m;
  for (m=this; m->text; m = m->next());
  return m-this+1;
}

const Fl_Menu *Fl_Menu::next(int n) const {
  if (n < 0) return 0; // this is so selected==-1 returns NULL
  const Fl_Menu *m = this;
  int nest = 0;
  while (n>0) {
    if (!m->text) {
      if (--nest < 0) return m;
    } else if (m->flags&FL_SUBMENU) nest++;
    m++;
    if (!nest && m->visible()) n--;
  }
  return m;
}

uchar Fl_Menu::textsize_ = FL_NORMAL_SIZE;
uchar Fl_Menu::textfont_ = FL_HELVETICA+FL_BOLD+FL_ITALIC;

////////////////////////////////////////////////////////////////

// tiny window for title of menu:
class menutitle : public Fl_Menu_Window {
  void draw();
public:
  const Fl_Menu *menu;
  menutitle(int X, int Y, int W, int H, const Fl_Menu*);
};

// each vertical menu has one of these:
class menuwindow : public Fl_Menu_Window {
  void draw();
  void drawentry(const Fl_Menu *,int i,int erase);
public:
  menutitle *title;
  int handle(int);
  int itemheight;	// zero == menubar
  int numitems;
  int selected;
  int drawn_selected;	// last redraw has this selected
  const Fl_Menu *menu;
  menuwindow(const Fl_Menu* m, int X, int Y, int W, int H,
	     const Fl_Menu* picked, const Fl_Menu* title,
	     int menubar = 0);
  ~menuwindow();
  void set_selected(int);
  int find_selected(int mx, int my);
  int titlex(int);
  void autoscroll(int);
  void position(int x, int y);
};

#define BW	3 // border thickness
#define LEFT	6 // between left edge of item and edge of box
#define RIGHT	8 // between right edge of item and edge of box
#define BOTTOM	4 // between bottom item and bottom of box
#define LEADING 4 // extra vertical leading
#define TOP	5 // between top item and top of box
// old values for shadow were 5,5. shadows only really work with an overlay
#define VSHADOW 0
#define HSHADOW 0

extern char fl_draw_shortcut;
#if HAVE_OVERLAY
extern uchar fl_overlay;
#endif

// width of label, including effect of & characters:
static int measure(const Fl_Menu* m, int* hp = 0) {
  Fl_Label l;
  l.value = m->text;
  l.type = m->labeltype_;
  l.font = m->labelsize_ ? m->labelfont_ : Fl_Menu::textfont();
  l.size = m->labelsize_ ? m->labelsize_ : Fl_Menu::textsize();
  l.color = m->labelcolor_;
  fl_draw_shortcut = 1;
  int w = 0; int h = 0; l.measure(w,h); if (hp) *hp = h;
  fl_draw_shortcut = 0;
  return w;
}

static void draw_menu_label(const Fl_Menu* m, int x, int y, int w, int h) {
  Fl_Label l;
  l.value = m->text;
  l.type = m->labeltype_;
  l.font = m->labelsize_ ? m->labelfont_ : Fl_Menu::textfont();
  l.size = m->labelsize_ ? m->labelsize_ : Fl_Menu::textsize();
  l.color = m->labelcolor_;
#if HAVE_OVERLAY
  if (!fl_overlay)
#endif
    if (!m->active()) l.color = 8;
  fl_draw_shortcut = 1;
  l.draw(x, y, w, h, FL_ALIGN_LEFT);
  fl_draw_shortcut = 0;
}

menutitle::menutitle(int X, int Y, int W, int H, const Fl_Menu* L) :
  Fl_Menu_Window(X,Y,W,H,0) {
  end();
  set_modal();
  clear_border();
  menu = L;
  if (L->labelcolor_) clear_overlay();
  box(0);
}

menuwindow::menuwindow(const Fl_Menu* m, int X, int Y, int Wp, int Hp,
		       const Fl_Menu* picked, const Fl_Menu* t, 
		       int menubar)
  : Fl_Menu_Window(X,Y,Wp,Hp,0)
{
  end();
  set_modal();
  clear_border();
  menu = m;
  drawn_selected = -1;
  box(0);
  selected = -1;
  {int i = 0;
  if (m) for (const Fl_Menu* m1=m; ; m1 = m1->next(), i++) {
    if (picked) {
      if (m1 == picked) {selected = i; picked = 0;}
      else if (m1 > picked) {selected = i-1; picked = 0; Wp = Hp = 0;}
    }
    if (!m1->text) break;
  }
  numitems = i;}

  if (menubar) {
    itemheight = 0;
    title = 0;
    return;
  }

  itemheight = 1;

  int hotKeysw = 0;
  int Wtitle = 0;
  int Htitle = 0;
  if (t) Wtitle = measure(t,&Htitle);
  int W = Wtitle;
  if (m) for (; m->text; m = m->next()) {
    int h; int w1 = measure(m, &h);
    if (h+LEADING>itemheight) itemheight = h+LEADING;
    if (m->submenu()) w1 += 13;
    else if (m->checkbox()) w1 += 14;
    if (w1 > W) W = w1;
    if (m->shortcut_) {
      w1 = int(fl_width(fl_shortcut_label(m->shortcut_))) + 8;
      if (w1 > hotKeysw) hotKeysw = w1;
    }
    if (m->labelcolor_) clear_overlay();
  }
  if (selected >= 0 && !Wp) X -= W/2;
  W += hotKeysw+LEFT+RIGHT; if (Wp > W) W = Wp;

  if (X < 0) X = 0; if (X+W+HSHADOW > Fl::w()) X = Fl::w()-W-HSHADOW;
  x(X); w(W+HSHADOW);
  h((numitems ? itemheight*numitems-LEADING : 0)+TOP+BOTTOM+1+VSHADOW);
  if (selected >= 0)
    Y = Y+(Hp-itemheight)/2-selected*itemheight-2;
  else
    Y = Y+Hp;
  if (m) y(Y-1); else {y(Y-3); w(1); h(1);}

  if (t) {
    int ht = Htitle+TOP+BOTTOM-1;
    title = new menutitle(X, Y-ht-3, Wtitle+HSHADOW+LEFT+RIGHT, ht+VSHADOW, t);
  } else
    title = 0;
}

menuwindow::~menuwindow() {
  delete title;
}

void menuwindow::position(int X, int Y) {
  if (title) {title->position(X, title->y()+Y-y());}
  Fl_Menu_Window::position(X,Y);
  x(X); y(Y); // don't wait for response from X
}

// scroll so item i is visible on screen
void menuwindow::autoscroll(int i) {
  int Y = y()+h()-(VSHADOW + BOTTOM + (numitems-i)*itemheight - LEADING + 1);
  if (Y < 0) Y = -Y+10;
  else {
    Y = Y+itemheight-Fl::h();
    if (Y <= 0) return;
    Y = -Y-10;
  }
  position(x(),y()+Y);
}

////////////////////////////////////////////////////////////////

#if HAVE_OVERLAY
// halftone patterns:
void fl_50percent();
void fl_50percent2();
void fl_100percent();
#endif

static void drawPopupBox(int x,int y,int w,int h) {
#if HSHADOW+VSHADOW > 0
  fl_color(FL_GRAY0); fl_50percent2();
  fl_rectf(x+HSHADOW, y+h, w, VSHADOW);
  fl_rectf(x+w, y+VSHADOW-1, HSHADOW, h+1-VSHADOW);
  fl_100percent();
#endif
#if HAVE_OVERLAY
  if (fl_overlay) {
    fl_color(FL_GRAY);
    fl_rectf(x+2,y+2,w-3,h-3);
    fl_color(FL_GRAY0);
    fl_50percent2();
    fl_rectf(x+2,y+h-3,w-3,2);
    fl_rectf(x+w-3,y+2,2,h-5);
    fl_color(FL_LIGHT3);
    fl_rectf(x+2,y+2,1,h-4);
    fl_rectf(x+3,y+2,w-5,1);
    fl_100percent();
    fl_yxline(x+1, y+h-2, y+1, x+w-2);
    fl_color(FL_GRAY0); fl_rect(x,y,w,h);
    return;
  }
#endif
  fl_draw_box(FL_UP_BOX, x, y, w, h, FL_GRAY);
}

void menuwindow::drawentry(const Fl_Menu *m, int i, int erase) {
  if (!m) return; // this happens if -1 is selected item and redrawn

  int x = LEFT-3;
  int W = this->w()-HSHADOW;
  int w = W-(LEFT+RIGHT-6);
  int y = h()-(VSHADOW + BOTTOM + (numitems-i)*itemheight - LEADING + 1);
  int h = itemheight - LEADING;

  if (i == selected) {
    fl_color(FL_DARK3);
    fl_xyline(BW+2, y+h, W-BW-2, y);
    fl_color(FL_WHITE);
    fl_rectf(BW+1, y-1, W-2*BW-3, h+1);
  } else if (erase) {
    fl_color(FL_GRAY);
    fl_rectf(BW+1, y-1, W-2*BW-2, h+2);
  }

  if (m->flags & FL_MENU_DIVIDER) {
    fl_color(FL_DARK3);
    fl_xyline(BW-1,y+h+1,W-BW);
    fl_color(FL_LIGHT3);
    fl_xyline(BW,y+h+2,W-BW);
  }

  if (m->checkbox()) {
    int y1 = y+(h-14)/2;
    fl_color(FL_DARK3);
    fl_yxline(x+3, y1+11, y1+2, x+12);
    if (i==selected) {fl_color(FL_GRAY); fl_rectf(x+4, y1+3, 9, 9);}
    else {fl_color(FL_LIGHT3); fl_xyline(x+4, y1+12, x+13, y1+3);}
    if (m->value()) {fl_color(FL_BLACK); fl_rectf(x+5, y1+4, 7, 7);}
    x += 14; w -= 14;
  }

  draw_menu_label(m, x+3, y, w-6, h);

  if (m->submenu()) {
    int y1 = y+(h-14)/2;
    fl_polygon(x+w-10, y1+2, x+w-10, y1+2+10, x+w, y1+2+5);
  } else if (m->shortcut_) {
    fl_font(Fl_Menu::textfont(), Fl_Menu::textsize());
    fl_draw(fl_shortcut_label(m->shortcut_), x, y, w-3, h, FL_ALIGN_RIGHT);
  }

#if HAVE_OVERLAY
  if (fl_overlay && !m->active()) {
    fl_color(FL_GRAY); fl_50percent();
    fl_rectf(BW, y-1, W-2*BW, h+2);
    fl_100percent();
  }
#endif
}

void menutitle::draw() {
  drawPopupBox(0, 0, w()-HSHADOW, h()-VSHADOW);
  draw_menu_label(menu, LEFT, 0, w()-HSHADOW, h());
}

void menuwindow::draw() {

  if (damage() != 1) {	// complete redraw
    if (menu) {
      drawPopupBox(0, 0, w()-HSHADOW, h()-VSHADOW);
      const Fl_Menu *m; int i;
      for (m=menu, i=0; m->text; i++, m = m->next()) drawentry(m,i,0);
    }
  } else {
/*
  if (damage() & 2) { // shadow on edge
  clearcolor();
  fl_rectf(w()-HSHADOW, 0, HSHADOW, H+VSHADOW+1);
  fl_color(FL_GRAY0); fl_50percent2();
  fl_rectf(w()-HSHADOW, 0, HSHADOW, H);
  fl_100percent();
  } */
    if (damage() & 1 && selected!=drawn_selected) { // change selection
      drawentry(menu->next(drawn_selected),drawn_selected,1);
      drawentry(menu->next(selected),selected,1);
    }
  }	    
  drawn_selected = selected;
}

void menuwindow::set_selected(int i) {
  if (i != selected) {selected = i; damage(1);}
}

////////////////////////////////////////////////////////////////

#define XBORDER 16 // horizontal spacing for Fl_MenuBar

// Return item in menubar pointed to by (relative) coordinates x,y
// or return -1 if none:
static const Fl_Menu*
find_in_menubar(const Fl_Menu* menu, int mx, int* returni = 0) {
  if (!menu) return 0;
  int x = BW; int i = 0;
  const Fl_Menu* m = menu;
  for (; ; m = m->next(), i++) {
    if (!m->text) return 0;
    x += measure(m) + XBORDER;
    if (x > mx) break;
  }
  if (!m->activevisible()) {i = -1; m = 0;}
  if (returni) *returni = i; return m;
}

int menuwindow::find_selected(int mx, int my) {
  if (!menu || !menu->text) return -1;
  mx -= x();
  my -= y();
  if (my <= 0 || my >= h()) return -1;
  if (!itemheight) {
    int i;
    if (find_in_menubar(menu, mx, &i)) return i;
    return -1;
  }
  if (mx <= 0 || mx >= w()) return -1;
  my -= h()-(VSHADOW + BOTTOM + numitems*itemheight - LEADING + 2);
  if (my <= 0) return -1;
  int i = my/itemheight;
  if (i>=numitems) i = numitems-1;
  if (menu->next(i)->activevisible()) return i;
  return -1;
}

// return horizontal position for item i in a menubar:
int menuwindow::titlex(int i) {
  const Fl_Menu* m;
  int x = BW;
  for (m=menu; i--; m = m->next()) x += measure(m) + XBORDER;
  return x;
}

// match shortcuts & label shortcuts, don't search submenus:
// returns menu item and index
static const Fl_Menu *find_shortcut(const Fl_Menu *menu, int & i) {
  const Fl_Menu *m1 = menu;
  for (int ii = 0; m1 && m1->text; m1 = m1->next(1),ii++) {
    if (m1->activevisible() &&
	(Fl::test_shortcut(m1->shortcut_)
	 || Fl_Widget::test_shortcut(m1->text))) {i = ii; return m1;}
  }
  return 0;
}

////////////////////////////////////////////////////////////////

// Because Fl::grab() is done, all events go to one of the menu windows.
// But the handle method needs to look at all of them to find out
// what item the user is pointing at.  And it needs a whole lot
// of other state variables to determine what is going on with
// the currently displayed menus.
// So the main loop (handlemenu()) puts all the state in a structure
// and puts a pointer to it in a static location, so the handle()
// on menus can refer to it and alter it.  The handle() method
// changes variables in this state to indicate what item is
// picked, but does not actually alter the display, instead the
// main loop does that.  This is because the X mapping and unmapping
// of windows is slow, and we don't want to fall behind the events.

struct menustate {
  int menu; // which menu selected item is in, menu<0 means none
  int item; // which item in that menu
  menuwindow *p[20]; // pointers to menus
  int nummenus;
  int menubar; // if true p[0] is a menubar
  int state; // 0 at first, 1 after push, 2 when done
};
static menustate *p;

static int forward(int menu) { // go to next item in menu menu if possible
  menustate &p = *(::p);
  menuwindow &m = *(p.p[menu]);
  int item = (menu == p.menu) ? p.item : m.selected;
  while (++item < m.numitems) {
    const Fl_Menu* m1 = m.menu->next(item);
    if (m1->activevisible()) {p.item = item; p.menu = menu; return 1;}
  }
  return 0;
}

static int backward(int menu) { // previous item in menu menu if possible
  menustate &p = *(::p);
  menuwindow &m = *(p.p[menu]);
  int item = menu == p.menu ? p.item : m.selected;
  while (--item >= 0) {
    const Fl_Menu* m1 = m.menu->next(item);
    if (m1->activevisible()) {p.item = item; p.menu = menu; return 1;}
  }
  return 0;
}

static const Fl_Menu* current_item() { // return the current menu item
  menustate &p = *(::p);
  return (p.menu >= 0 && p.item >= 0) ? p.p[p.menu]->menu->next(p.item) : 0;
}

int menuwindow::handle(int e) {
  menustate &p = *(::p);
  switch (e) {
  case FL_KEYBOARD:
    switch (Fl::event_key()) {
    case FL_Up:
      if (p.menu < 0) p.menu = 0;
      if (p.menubar && p.menu==0) ;
      else if (backward(p.menu));
      else if (p.menubar && p.menu==1) {p.menu=0; p.item = p.p[0]->selected;}
      break;
    case FL_Down:
      if (p.menu < 0) p.menu = 0;
      if (p.menu || !p.menubar) forward(p.menu);
      else if (p.menu < p.nummenus-1) forward(p.menu+1);
      break;
    case FL_Right:
      if (p.menubar && (p.menu<=0 || p.menu==1 && p.nummenus==2)) forward(0);
      else if (p.menu < p.nummenus-1) forward(p.menu+1);
      break;
    case FL_Left:
      if (p.menubar && p.menu<=1) backward(0);
      else if (p.menu>0) {p.menu--; p.item = p.p[p.menu]->selected;}
      break;
    case FL_Enter:
      p.state = 2;
      break;
    case FL_Escape:
      p.menu = -1;
      p.state = 2;
      break;
    default: { // see if it is a shortcut for currently displayed menus
      for (int menu = p.nummenus; menu--;) {
	int item; const Fl_Menu *m = find_shortcut(p.p[menu]->menu, item);
	if (m) {
	  p.item = item; p.menu = menu;
	  if (!m->submenu()) p.state = 2;
	  return 1;
	}
      }
      } break;
    }
    break;
  case FL_PUSH:
    p.state = 1;
  case FL_MOVE:
  case FL_DRAG: {
    int mx = Fl::event_x_root();
    int my = Fl::event_y_root();
    int item=0; int menu;
    for (menu=p.nummenus-1; menu>=0; menu--) {
      item = p.p[menu]->find_selected(mx,my);
      if (item >= 0) break;
    }
    p.menu = menu; p.item = item;}
    break;
  case FL_RELEASE:
    if (p.state || !Fl::event_is_click() || 
	p.menubar && p.nummenus==1) p.state = 2;
    break;
  default:
    return Fl_Window::handle(e);
  }
  return 1;
}

// This internal version of popup() takes coordinates translated to
// screen space, and extra flags to indicate the menubar:
static const Fl_Menu *popup(
    const Fl_Menu *m, int X, int Y, int W, int H, const Fl_Menu *picked,
    const Fl_Menu *t, int menubar=0) {

  if (!m || !m->text) return 0;

  menuwindow mw(m, X, Y, W, H, picked, t, menubar);
  Fl::grab(mw);
  menustate p; ::p = &p;
  p.p[0] = &mw;
  p.nummenus = 1;
  p.menubar = menubar;
  p.state = 0;

  if (mw.selected >= 0) { // select picked item
    p.menu = 0; p.item = mw.selected;
    if (!current_item()->activevisible()) mw.selected = -1;
  }
  if (mw.selected < 0) {p.menu = -1; p.item = -1; picked = 0;}

  menuwindow *fakemenu = 0; // kludge for buttons in menubar

  if (picked) goto STARTUP;

  // the main loop, runs until p.state goes to 2:
  for (;;) {

    // make sure all the menus are shown:
    {for (int k = menubar; k < p.nummenus; k++)
      if (!p.p[k]->shown()) {
	if (p.p[k]->title) p.p[k]->title->show();
	p.p[k]->show();
      }
    }

    // get events:
    {int oldi = p.item; int oldmenu = p.menu;
    Fl::wait();
    if (p.state == 2) break; // done.
    if (p.item == oldi && p.menu == oldmenu) continue;} // only do rest if item changes:

    delete fakemenu; fakemenu = 0; // turn off "menubar button"

    if (p.menu<0 || p.item<0) { // pointing at nothing
      // turn off selection in deepest menu, but don't erase other menus:
      p.p[p.nummenus-1]->set_selected(-1);
      continue;
    }

    delete fakemenu; fakemenu = 0;
    picked = 0; // stop the startup code
    p.p[p.menu]->autoscroll(p.item);

  STARTUP:
    p.p[p.menu]->set_selected(p.item);
    const Fl_Menu* m = current_item();

    if (m == picked) picked = 0; // stop the startup code if item found
    if (m->submenu()) {
      const Fl_Menu *title = m;
      const Fl_Menu *menutable;
      if (m->flags&FL_SUBMENU) menutable = m+1;
      else menutable = (Fl_Menu*)(m)->user_data_;
      int nX,nY;
      if (!p.menu && p.menubar) {	// menu off a menubar:
	nX = p.p[p.menu]->x() + p.p[p.menu]->titlex(p.item);
	nY = p.p[p.menu]->y() + p.p[p.menu]->h();
	picked = 0;
      } else {
	nX = p.p[p.menu]->x() + p.p[p.menu]->w()-HSHADOW;
	nY = p.p[p.menu]->y() + 1 + p.item*p.p[p.menu]->itemheight;
	title = 0;
      }
      if (picked) { // bring up submenu containing pre-picked item:
	menuwindow *n = new menuwindow(menutable,X,Y,W,H,picked,title);
	p.p[p.nummenus++] = n;
	// move all earlier menus to line up with this new one:
	if (n->selected>=0) {
	  int dy = n->y()-nY;
	  int dx = n->x()-nX;
	  for (int menu = 0; menu <= p.menu; menu++) {
	    menuwindow *t = p.p[menu];
	    int nx = t->x()+dx; if (nx < 0) {nx = 0; dx = -t->x();}
	    int ny = t->y()+dy+1; if (ny < 0) {ny = 0; dy = -t->y()-1;}
	    t->position(nx, ny);
	  }
	  p.menu = p.nummenus-1; p.item = n->selected;
	  if (!current_item()->activevisible()) mw.selected = -1;
	  else goto STARTUP;
	}
      } else if (p.nummenus > p.menu+1 && p.p[p.menu+1]->menu == menutable) {
	// the menu is already up:
	while (p.nummenus > p.menu+2) delete p.p[--p.nummenus];
	p.p[p.nummenus-1]->set_selected(-1);
      } else {
	// delete all the old menus and create new one:
	while (p.nummenus > p.menu+1) delete p.p[--p.nummenus];
	p.p[p.nummenus++] = new menuwindow(menutable,nX,nY,0,0,0,title);
      }
    } else { // !m->submenu():
      while (p.nummenus > p.menu+1) delete p.p[--p.nummenus];
      if (!p.menu && p.menubar) {
	// kludge so "menubar buttons" turn "on" by using menu title:
	fakemenu = new menuwindow(0,
				  p.p[p.menu]->x()+p.p[p.menu]->titlex(p.item),
				  p.p[p.menu]->y()+p.p[p.menu]->h(),0,0,
				  0, m);
	fakemenu->title->show();
      }
    }
  }
  m = current_item();
  delete fakemenu;
  while (p.nummenus>1) delete p.p[--p.nummenus];
  mw.hide();
  Fl::release();
  return m;
}

////////////////////////////////////////////////////////////////

static Fl_Menu dummy;

const Fl_Menu*
Fl_Menu::popup(int x, int y, const char *title) const {
  dummy.text = title;
  return ::popup(this,
		 x+Fl::event_x_root()-Fl::event_x(),
		 y+Fl::event_y_root()-Fl::event_y(), 0, 0,
		 0, title ? &dummy : 0);
}

const Fl_Menu*
Fl_Menu::popup(int x, int y, int w, int h,
	       const Fl_Menu* p, const char* title) const {
  dummy.text = title;
  return ::popup(this,
		 x+Fl::event_x_root()-Fl::event_x(),
		 y+Fl::event_y_root()-Fl::event_y(), w, h,
		 p, title ? &dummy : 0);
}

const Fl_Menu *Fl_Menu::test_shortcut() const {
  const Fl_Menu *m = this;
  const Fl_Menu *ret = 0;
  if (m) for (; m->text; m = m->next()) {
    if (m->activevisible()) {
      // return immediately any match of an item in top level menu:
      if (Fl::test_shortcut(m->shortcut_)) return m;
      // if (Fl_Widget::test_shortcut(m->text)) return m;
      // only return matches from lower menu if nothing found in top menu:
      if (!ret && m->submenu()) {
	const Fl_Menu* s =
	  (m->flags&FL_SUBMENU) ? m+1:(const Fl_Menu*)m->user_data_;
	ret = s->test_shortcut();
      }
    }
  }
  return ret;
}

/////////////////////////////////////////////////////////////////

#include <FL/Fl_Menu_Bar.H>

void Fl_Menu_Bar::draw() {
  draw_box();
  if (!menu() || !menu()->text) return;
  Fl_Menu::textfont(textfont());
  Fl_Menu::textsize(textsize());
  const Fl_Menu *m;
  int X = x()+LEFT+3;
  for (m=menu(); m->text; m = m->next()) {
    draw_menu_label(m, X, y(), 0, h());
    X += measure(m) + XBORDER;
  }
}

int Fl_Menu_Bar::handle(int event) {
  const Fl_Menu *v;
  int item;
  switch (event) {
  case FL_PUSH:
    v = find_in_menubar(menu(), Fl::event_x()-x());
  J1:
    Fl_Menu::textfont(textfont());
    Fl_Menu::textsize(textsize());
    v = ::popup(menu(),
	      x()+Fl::event_x_root()-Fl::event_x(),
	      y()+Fl::event_y_root()-Fl::event_y(), w(), h(),
	      v, 0, 1);
    picked(v);
    return 1;
  case FL_SHORTCUT:
    v = menu()->test_shortcut();
    if (v) {picked(v); return 1;}
    v = find_shortcut(menu(),item);
    if (v) goto J1;
    return 0;
  default:
    return 0;
  }
}

// end of Fl_Menu.C
