/*	Fl_Browser.H

	Forms-compatable browser.  Probably useful for other
	lists of textual data.  Notice that the line numbers
	start from 1, and 0 means "no line".

*/

#ifndef Fl_Browser_H
#define Fl_Browser_H

#include "Fl_Browser_.H"

struct FL_BLINE;	// why won't GNU let me put this inside the object???

class Fl_Browser : public Fl_Browser_ {

  // required routines for Fl_Browser_ subclass:
  void *item_first() const ;
  void *item_next(void *) const ;
  void *item_prev(void *) const ;
  int item_selected(void *) const ;
  void item_select(void *,int);
  int item_height(void *) const ;
  void item_draw(void *,int,int,int,int) const ;
  int full_height() const ;
  int incr_height() const ;

  FL_BLINE *first,*last,*cache;	// the array of lines
  int cacheline;		// line number of cache
  int lines;                	// Number of lines
  int full_height_;
  uchar textfont_,textsize_,textcolor_;
  char format_char_;		// alternative to @-sign
  char column_char_;		// alternative to tab
  const int *column_widths_;
  FL_BLINE *find_line(int) const ;
  int lineno(void *) const ;

public:

  void remove(int);
  void add(const char *);
  void insert(int,const char *);
  void replace(int,const char *);
  int  load(const char *filename);
  void clear();

  int size() const {return lines;}
  int topline() const ;
  void topline(int);

  int select(int,int=1);
  int selected(int) const ;
  void display(int,int=1);
  int displayed(int) const ;

  int value() const ;
  void value(int v) {select(v);}
  const char *text(int) const ;

  Fl_Browser(int,int,int,int,const char * =0);

  uchar textfont() const {return textfont_;}
  void textfont(uchar s) {textfont_ = s;}
  uchar textsize() const {return textsize_;}
  void textsize(uchar s);
  uchar textcolor() const {return textcolor_;}
  void textcolor(uchar n) {textcolor_ = n;}
  char format_char() const {return format_char_;}
  void format_char(char c) {format_char_ = c;}
  char column_char() const {return column_char_;}
  void column_char(char c) {column_char_ = c;}
  const int* column_widths() const {return column_widths_;}
  void column_widths(int *l) { column_widths_=l; }

};

#endif
