// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  PhotoStatusBars.C

  Stephane Rehel

  October 25 1997
*/

#include "interface/MLStatusBars.h"
#include "interface/MLStatusLine.h"
#include "interface/MLStatusLineText.h"
#include "interface/MLStatusLineButton.h"

#include "PhotoCommand.h"
#include "PhotoCommands.h"
#include "PhotoModule.h"

#include "PhotoStatusBars.h"

/////////////////////////////////////////////////////////////////////////////

PhotoStatusBars::PhotoStatusBars( PhotoModule* _photo,
                                MLStatusBars* _statusBars )
{
  photo= _photo;
  statusBars= _statusBars;

  modeInfo= 0;
  message= 0;
  single_multiple= 0;
}

/////////////////////////////////////////////////////////////////////////////

PhotoStatusBars::~PhotoStatusBars()
{
  modeInfo= 0;
  message= 0;
  single_multiple= 0;
}

/////////////////////////////////////////////////////////////////////////////

void PhotoStatusBars::init()
{
  if( photo == 0 || statusBars == 0 )
    return;

  MLStatusLine* line1= statusBars->getLine(0);
  MLStatusLine* line2= statusBars->getLine(1);

  message= new MLStatusLineText( photo,
                                 line1,
                                 0,
                                 MLStatusLineItem::LEFT, true );

//(new MLStatusLineButton( statusBars->getLine1(),
//                         3, MLStatusLineItem::RIGHT, false ))->
//setMessage("ABC");

  modeInfo= new MLStatusLineText( photo,
                                  line2,
                                  0,
                                  MLStatusLineItem::LEFT, true );

  single_multiple= new MLStatusLineButton( photo,
                                           line2,
                                           3,
                                           MLStatusLineItem::RIGHT, false);
  single_multiple->setActionHandler(this);

  line1->finalize();
  line2->finalize();

  single_multiple->printMessage("SGL");

  update();
}

/////////////////////////////////////////////////////////////////////////////

void PhotoStatusBars::update()
{
  if( photo == 0 || statusBars == 0 )
    return;

  if( single_multiple != 0 )
    single_multiple->setPressed(false);
}

/////////////////////////////////////////////////////////////////////////////

boolean PhotoStatusBars::handleAction( MLAction* action )
{
  if( photo == 0 )
    return false;

  if( action == single_multiple )
    {
//    PhotoCommand* cmd= new PhotoCommand;
//    cmd->type= PhotoCommands::PRESS_IT;
//
//    photo->post(cmd);

    return true;
    }

  return false;
}

/////////////////////////////////////////////////////////////////////////////
